/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.AbstractApiSecurityConfigurer;
import io.dialob.security.key.ServletRequestApiKeyExtractor;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.apikey.ApiKeyAuthenticationProvider;
import io.dialob.security.spring.apikey.ApiKeyAuthoritiesProvider;
import io.dialob.security.spring.apikey.ApiKeyRequestMatcher;
import io.dialob.security.spring.apikey.ApiKeyValidator;
import io.dialob.security.spring.apikey.ClientApiKeyService;
import io.dialob.security.spring.filter.ApiKeyAuthenticationFilter;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class ApiServiceSecurityConfigurer
extends AbstractApiSecurityConfigurer {
    public static final RequestMatcher SESSION_NOT_EXISTS_MATCHER = request -> request.getSession(false) == null;
    private final ClientApiKeyService apiKeyService;
    private final ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider;
    private final ServletRequestApiKeyExtractor keyRequestExtractor;
    private final ApiKeyValidator apiKeyValidator;
    private final boolean allRequests;
    private RequestMatcher requestMatcher;
    private RequestMatcher apiKeyRequestMatcher;

    public ApiServiceSecurityConfigurer(@NonNull ClientApiKeyService apiKeyService, @NonNull ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider, @NonNull ApiKeyValidator apiKeyValidator, @NonNull DialobSettings settings, @NonNull ServletRequestApiKeyExtractor keyRequestExtractor, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy, @NonNull boolean allRequests) {
        super(settings.getApi().getContextPath(), tenantPermissionEvaluator, authenticationStrategy);
        this.apiKeyService = apiKeyService;
        this.apiKeyAuthoritiesProvider = apiKeyAuthoritiesProvider;
        this.keyRequestExtractor = keyRequestExtractor;
        this.apiKeyValidator = apiKeyValidator;
        this.allRequests = allRequests;
    }

    protected RequestMatcher apiKeyRequestMatcher() {
        if (this.apiKeyRequestMatcher == null) {
            this.apiKeyRequestMatcher = this.allRequests ? AnyRequestMatcher.INSTANCE : new ApiKeyRequestMatcher(this.keyRequestExtractor);
        }
        return this.apiKeyRequestMatcher;
    }

    protected RequestMatcher requestMatcher() {
        if (this.requestMatcher == null) {
            ArrayList<Object> requestMatchers = new ArrayList<Object>();
            if (StringUtils.isNotBlank((CharSequence)this.getContextPath())) {
                requestMatchers.add(new AntPathRequestMatcher(this.getContextPath() + "/**"));
            }
            if (!this.allRequests) {
                requestMatchers.add(SESSION_NOT_EXISTS_MATCHER);
                requestMatchers.add(this.apiKeyRequestMatcher());
            }
            this.requestMatcher = requestMatchers.isEmpty() ? AnyRequestMatcher.INSTANCE : new AndRequestMatcher(requestMatchers);
        }
        return this.requestMatcher;
    }

    protected HttpSecurity configureAuthentication(HttpSecurity http) throws Exception {
        return (HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).logout().disable();
    }

    protected HttpSecurity configureCsrf(HttpSecurity http) throws Exception {
        return (HttpSecurity)http.csrf().disable();
    }

    protected HttpSecurity configureFrameOptions(HttpSecurity http) throws Exception {
        return (HttpSecurity)http.headers().frameOptions().disable().and();
    }

    protected ApiKeyAuthenticationProvider apiKeyAuthenticationProvider(@NonNull ClientApiKeyService apiKeyService, @NonNull ApiKeyAuthoritiesProvider apiKeyAuthoritiesProvider, @NonNull ApiKeyValidator apiRequestValidator) {
        return new ApiKeyAuthenticationProvider(apiKeyService, apiKeyAuthoritiesProvider, apiRequestValidator);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.apiKeyAuthenticationProvider(this.apiKeyService, this.apiKeyAuthoritiesProvider, this.apiKeyValidator));
    }

    protected HttpSecurity configureMDCPrincipalFilter(HttpSecurity http) throws Exception {
        return super.configureMDCPrincipalFilter(http).addFilterBefore((Filter)new ApiKeyAuthenticationFilter(this.authenticationManager(), this.keyRequestExtractor, this.apiKeyRequestMatcher()), AnonymousAuthenticationFilter.class);
    }
}

