/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.controller;

import io.dialob.boot.controller.BaseController;
import io.dialob.boot.controller.ComposerController;
import io.dialob.boot.controller.PageAttributes;
import io.dialob.boot.controller.PageSettingsProvider;
import io.dialob.boot.settings.ComposerApplicationSettings;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"${composer.context-path:/composer}"})
public class ComposerController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComposerController.class);
    private ComposerApplicationSettings settings;
    private final PageSettingsProvider pageSettingsProvider;

    public ComposerController(ComposerApplicationSettings settings, PageSettingsProvider pageSettingsProvider) {
        this.settings = settings;
        this.pageSettingsProvider = pageSettingsProvider;
    }

    @GetMapping(value={"/"}, produces={"text/html"})
    public String composer(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        return this.composer(forwardedFor, host, realIp, forwardedProto, null, cfrsToken, model, request);
    }

    @GetMapping(value={"/{id}"}, produces={"text/html"})
    public String composer(@RequestHeader(value="X-Forwarded-For", required=false) String forwardedFor, @RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Real-IP", required=false) String realIp, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="id") String formId, CsrfToken cfrsToken, Model model, HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Host: {}", (Object)host);
            LOGGER.debug("X-Real-IP: {}", (Object)realIp);
            LOGGER.debug("X-Forwarded-For: {}", (Object)forwardedFor);
            LOGGER.debug("X-Forwarded-Proto: {}", (Object)forwardedProto);
        }
        if ("index.html".equals(formId)) {
            formId = null;
        }
        this.index(model, request);
        if (StringUtils.isBlank((CharSequence)forwardedProto)) {
            forwardedProto = request.getScheme();
        }
        AppConfig appConfig = this.getJavascriptAppConfig(host, forwardedProto, formId, cfrsToken, request);
        model.addAttribute("contextPath", (Object)this.settings.getUrl());
        model.addAttribute("subApplicationName", (Object)this.settings.getSubApplicationName());
        model.addAttribute("appConfig", (Object)appConfig);
        PageAttributes pageAttributes = this.pageSettingsProvider.findPageSettings("composer");
        model.addAllAttributes(pageAttributes.getAttributes());
        this.index(model, request);
        return pageAttributes.getTemplate();
    }

    @GetMapping(path={"/{id}/config.json"}, produces={"application/json"})
    @ResponseBody
    public AppConfig config(@RequestHeader(value="Host", required=false) String host, @RequestHeader(value="X-Forwarded-Proto", required=false) String forwardedProto, @PathVariable(value="id") String formId, CsrfToken cfrsToken, HttpServletRequest request) {
        return this.getJavascriptAppConfig(host, forwardedProto, formId, cfrsToken, request);
    }

    protected AppConfig getJavascriptAppConfig(String host, String forwardedProto, String formId, CsrfToken cfrsToken, HttpServletRequest request) {
        String tenantId;
        Object fillingAppUrl = this.settings.getFillingAppUrl();
        if (StringUtils.isBlank((CharSequence)fillingAppUrl)) {
            fillingAppUrl = forwardedProto + "://" + host;
        }
        AppConfig appConfig = new AppConfig();
        appConfig.setFormId(formId);
        appConfig.setBackendApiUrl(this.settings.getBackendApiUrl());
        appConfig.setDocumentationUrl(this.settings.getDocumentationUrl());
        appConfig.setFillingAppUrl((String)fillingAppUrl);
        appConfig.setAdminAppUrl(this.settings.getAdminAppUrl());
        if (cfrsToken != null) {
            appConfig.setCsrf(cfrsToken.getToken());
            appConfig.setCsrfHeader(cfrsToken.getHeaderName());
        }
        if (!StringUtils.isBlank((CharSequence)(tenantId = request.getParameter("tenantId")))) {
            appConfig.setTenantId(tenantId);
        }
        return appConfig;
    }
}

