package io.dialob.boot.controller;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PageAttributes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePageAttributes.builder()}.
 */
@Generated(from = "PageAttributes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePageAttributes implements PageAttributes {
  private final ImmutableMap<String, Object> attributes;
  private final String template;

  private ImmutablePageAttributes(
      ImmutableMap<String, Object> attributes,
      String template) {
    this.attributes = attributes;
    this.template = template;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @Override
  public ImmutableMap<String, Object> getAttributes() {
    return attributes;
  }

  /**
   * @return The value of the {@code template} attribute
   */
  @Override
  public String getTemplate() {
    return template;
  }

  /**
   * Copy the current immutable object by replacing the {@link PageAttributes#getAttributes() attributes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the attributes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePageAttributes withAttributes(Map<String, ? extends Object> entries) {
    if (this.attributes == entries) return this;
    ImmutableMap<String, Object> newValue = ImmutableMap.copyOf(entries);
    return new ImmutablePageAttributes(newValue, this.template);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PageAttributes#getTemplate() template} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for template
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePageAttributes withTemplate(String value) {
    String newValue = Objects.requireNonNull(value, "template");
    if (this.template.equals(newValue)) return this;
    return new ImmutablePageAttributes(this.attributes, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePageAttributes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePageAttributes
        && equalTo((ImmutablePageAttributes) another);
  }

  private boolean equalTo(ImmutablePageAttributes another) {
    return attributes.equals(another.attributes)
        && template.equals(another.template);
  }

  /**
   * Computes a hash code from attributes: {@code attributes}, {@code template}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + attributes.hashCode();
    h += (h << 5) + template.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PageAttributes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PageAttributes")
        .omitNullValues()
        .add("attributes", attributes)
        .add("template", template)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link PageAttributes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PageAttributes instance
   */
  public static ImmutablePageAttributes copyOf(PageAttributes instance) {
    if (instance instanceof ImmutablePageAttributes) {
      return (ImmutablePageAttributes) instance;
    }
    return ImmutablePageAttributes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePageAttributes ImmutablePageAttributes}.
   * <pre>
   * ImmutablePageAttributes.builder()
   *    .putAttributes|putAllAttributes(String =&gt; Object) // {@link PageAttributes#getAttributes() attributes} mappings
   *    .template(String) // required {@link PageAttributes#getTemplate() template}
   *    .build();
   * </pre>
   * @return A new ImmutablePageAttributes builder
   */
  public static ImmutablePageAttributes.Builder builder() {
    return new ImmutablePageAttributes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePageAttributes ImmutablePageAttributes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PageAttributes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEMPLATE = 0x1L;
    private long initBits = 0x1L;

    private ImmutableMap.Builder<String, Object> attributes = ImmutableMap.builder();
    private @Nullable String template;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PageAttributes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PageAttributes instance) {
      Objects.requireNonNull(instance, "instance");
      putAllAttributes(instance.getAttributes());
      template(instance.getTemplate());
      return this;
    }

    /**
     * Put one entry to the {@link PageAttributes#getAttributes() attributes} map.
     * @param key The key in the attributes map
     * @param value The associated value in the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAttributes(String key, Object value) {
      this.attributes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link PageAttributes#getAttributes() attributes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAttributes(Map.Entry<String, ? extends Object> entry) {
      this.attributes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PageAttributes#getAttributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder attributes(Map<String, ? extends Object> entries) {
      this.attributes = ImmutableMap.builder();
      return putAllAttributes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PageAttributes#getAttributes() attributes} map. Nulls are not permitted
     * @param entries The entries that will be added to the attributes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAttributes(Map<String, ? extends Object> entries) {
      this.attributes.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link PageAttributes#getTemplate() template} attribute.
     * @param template The value for template 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder template(String template) {
      this.template = Objects.requireNonNull(template, "template");
      initBits &= ~INIT_BIT_TEMPLATE;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePageAttributes ImmutablePageAttributes}.
     * @return An immutable instance of PageAttributes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePageAttributes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePageAttributes(attributes.build(), template);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEMPLATE) != 0) attributes.add("template");
      return "Cannot build PageAttributes, some of required attributes are not set " + attributes;
    }
  }
}
