/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.AbstractApiSecurityConfigurer;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import io.dialob.settings.DialobSettings;
import org.springframework.lang.NonNull;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;

public class WebApiSecurityConfigurer
extends AbstractApiSecurityConfigurer {
    private final DialobSettings settings;

    public WebApiSecurityConfigurer(@NonNull DialobSettings settings, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, AuthenticationStrategy authenticationStrategy) {
        super(settings.getApi().getContextPath(), tenantPermissionEvaluator, authenticationStrategy);
        this.settings = settings;
    }

    protected HttpSecurity configureCors(HttpSecurity http) {
        return this.settings.getApi().getCors().toCorsConfiguration().map(corsConfiguration -> {
            try {
                return (HttpSecurity)http.cors().configurationSource(request -> corsConfiguration).and();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).orElse(http);
    }
}

