/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.boot.security;

import io.dialob.boot.security.WebUISecurityConfigurer;
import io.dialob.security.spring.AuthenticationStrategy;
import io.dialob.security.spring.tenant.TenantAccessEvaluator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.HttpMethod;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

public class AdminSecurityConfigurer
extends WebUISecurityConfigurer {
    private final ApplicationEventPublisher applicationEventPublisher;

    public AdminSecurityConfigurer(@NonNull String contextPath, @NonNull ApplicationEventPublisher applicationEventPublisher, @NonNull TenantAccessEvaluator tenantPermissionEvaluator, @NonNull AuthenticationStrategy authenticationStrategy) {
        super(contextPath, tenantPermissionEvaluator, authenticationStrategy);
        this.applicationEventPublisher = applicationEventPublisher;
    }

    protected HttpSecurity configurePermissions(HttpSecurity http) throws Exception {
        String contextPath = this.getContextPath();
        contextPath = StringUtils.removeEnd((String)contextPath, (String)"/");
        return (HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.requestMatcher(this.requestMatcher()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{contextPath + "/swagger/**", contextPath + "/swagger-resources", contextPath + "/swagger-resources/**", contextPath + "/swagger-ui/**", contextPath + "/webjars/**"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/_uuids"})).hasAnyAuthority(new String[]{"questionnaires.post", "forms.post"}).antMatchers(HttpMethod.GET, new String[]{contextPath + "**"})).hasAuthority("manager.view").anyRequest()).denyAll().and();
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        super.configure(auth);
        auth.authenticationEventPublisher((AuthenticationEventPublisher)new DefaultAuthenticationEventPublisher(this.applicationEventPublisher));
    }
}

