package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Metadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetadata.builder()}.
 */
@Generated(from = "Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMetadata implements Metadata {
  private final @Nullable String description;
  private final String label;
  private final @Nullable Date created;
  private final @Nullable Date lastSaved;
  private final @Nullable Boolean valid;

  private ImmutableMetadata(
      @Nullable String description,
      String label,
      @Nullable Date created,
      @Nullable Date lastSaved,
      @Nullable Boolean valid) {
    this.description = description;
    this.label = label;
    this.created = created;
    this.lastSaved = lastSaved;
    this.valid = valid;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code lastSaved} attribute
   */
  @JsonProperty("lastSaved")
  @Override
  public @Nullable Date getLastSaved() {
    return lastSaved;
  }

  /**
   * @return The value of the {@code valid} attribute
   */
  @JsonProperty("valid")
  @Override
  public @Nullable Boolean getValid() {
    return valid;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableMetadata(value, this.label, this.created, this.lastSaved, this.valid);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableMetadata(this.description, newValue, this.created, this.lastSaved, this.valid);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withCreated(@Nullable Date value) {
    if (this.created == value) return this;
    return new ImmutableMetadata(this.description, this.label, value, this.lastSaved, this.valid);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getLastSaved() lastSaved} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastSaved (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withLastSaved(@Nullable Date value) {
    if (this.lastSaved == value) return this;
    return new ImmutableMetadata(this.description, this.label, this.created, value, this.valid);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getValid() valid} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valid (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withValid(@Nullable Boolean value) {
    if (Objects.equals(this.valid, value)) return this;
    return new ImmutableMetadata(this.description, this.label, this.created, this.lastSaved, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetadata
        && equalTo(0, (ImmutableMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableMetadata another) {
    return Objects.equals(description, another.description)
        && label.equals(another.label)
        && Objects.equals(created, another.created)
        && Objects.equals(lastSaved, another.lastSaved)
        && Objects.equals(valid, another.valid);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code label}, {@code created}, {@code lastSaved}, {@code valid}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + label.hashCode();
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastSaved);
    h += (h << 5) + Objects.hashCode(valid);
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "description=" + description
        + ", label=" + label
        + ", created=" + created
        + ", lastSaved=" + lastSaved
        + ", valid=" + valid
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Metadata {
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String label;
    @javax.annotation.Nullable Date created;
    @javax.annotation.Nullable Date lastSaved;
    @javax.annotation.Nullable Boolean valid;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("label")
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable Date created) {
      this.created = created;
    }
    @JsonProperty("lastSaved")
    public void setLastSaved(@Nullable Date lastSaved) {
      this.lastSaved = lastSaved;
    }
    @JsonProperty("valid")
    public void setValid(@Nullable Boolean valid) {
      this.valid = valid;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Date getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Date getLastSaved() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getValid() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableMetadata fromJson(Json json) {
    ImmutableMetadata.Builder builder = ImmutableMetadata.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastSaved != null) {
      builder.lastSaved(json.lastSaved);
    }
    if (json.valid != null) {
      builder.valid(json.valid);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Metadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Metadata instance
   */
  public static ImmutableMetadata copyOf(Metadata instance) {
    if (instance instanceof ImmutableMetadata) {
      return (ImmutableMetadata) instance;
    }
    return ImmutableMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetadata ImmutableMetadata}.
   * <pre>
   * ImmutableMetadata.builder()
   *    .description(String | null) // nullable {@link Metadata#getDescription() description}
   *    .label(String) // required {@link Metadata#getLabel() label}
   *    .created(Date | null) // nullable {@link Metadata#getCreated() created}
   *    .lastSaved(Date | null) // nullable {@link Metadata#getLastSaved() lastSaved}
   *    .valid(Boolean | null) // nullable {@link Metadata#getValid() valid}
   *    .build();
   * </pre>
   * @return A new ImmutableMetadata builder
   */
  public static ImmutableMetadata.Builder builder() {
    return new ImmutableMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetadata ImmutableMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Metadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LABEL = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String label;
    private @javax.annotation.Nullable Date created;
    private @javax.annotation.Nullable Date lastSaved;
    private @javax.annotation.Nullable Boolean valid;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      label(instance.getLabel());
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      Date lastSavedValue = instance.getLastSaved();
      if (lastSavedValue != null) {
        lastSaved(lastSavedValue);
      }
      Boolean validValue = instance.getValid();
      if (validValue != null) {
        valid(validValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable Date created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getLastSaved() lastSaved} attribute.
     * @param lastSaved The value for lastSaved (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastSaved")
    public final Builder lastSaved(@Nullable Date lastSaved) {
      this.lastSaved = lastSaved;
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getValid() valid} attribute.
     * @param valid The value for valid (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valid")
    public final Builder valid(@Nullable Boolean valid) {
      this.valid = valid;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetadata ImmutableMetadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetadata build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMetadata(description, label, created, lastSaved, valid);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build Metadata, some of required attributes are not set " + attributes;
    }
  }
}
