package io.dialob.api.rest;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Items}.
 * @see ImmutableItems
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.rest", generator = "Gsons")
public final class GsonAdaptersItems implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ItemsTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ItemsTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersItems(Items)";
  }

  @org.immutables.value.Generated(from = "Items", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ItemsTypeAdapter extends TypeAdapter<Items> {

    ItemsTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return Items.class == type.getRawType()
          || ImmutableItems.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Items value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeItems(out, value);
      }
    }

    @Override
    public Items read(JsonReader in) throws IOException {
      return readItems(in);
    }

    private void writeItems(JsonWriter out, Items instance)
        throws IOException {
      out.beginObject();
      out.name("activeItem");
      out.value(instance.getActiveItem());
      List<String> itemsElements = instance.getItems();
      out.name("items");
      out.beginArray();
      for (String e : itemsElements) {
        out.value(e);
      }
      out.endArray();
      List<String> availableItemsElements = instance.getAvailableItems();
      out.name("availableItems");
      out.beginArray();
      for (String e : availableItemsElements) {
        out.value(e);
      }
      out.endArray();
      out.endObject();
    }

    private  Items readItems(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableItems.Builder builder = ImmutableItems.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableItems.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'a':
        if ("activeItem".equals(attributeName)) {
          readInActiveItem(in, builder);
          return;
        }
        if ("availableItems".equals(attributeName)) {
          readInAvailableItems(in, builder);
          return;
        }
        break;
      case 'i':
        if ("items".equals(attributeName)) {
          readInItems(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInActiveItem(JsonReader in, ImmutableItems.Builder builder)
        throws IOException {
      builder.activeItem(in.nextString());
    }

    private void readInItems(JsonReader in, ImmutableItems.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addItems(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addItems(in.nextString());
      }
    }

    private void readInAvailableItems(JsonReader in, ImmutableItems.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addAvailableItems(in.nextString());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addAvailableItems(in.nextString());
      }
    }
  }
}
