package io.dialob.api.rest;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Errors}.
 * @see ImmutableErrors.Error
 * @see ImmutableErrors
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.rest", generator = "Gsons")
public final class GsonAdaptersErrors implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ErrorTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ErrorTypeAdapter(gson);
    }
    if (ErrorsTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ErrorsTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersErrors(Error, Errors)";
  }

  @org.immutables.value.Generated(from = "Errors.Error", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ErrorTypeAdapter extends TypeAdapter<Errors.Error> {
    public final Object rejectedValueTypeSample = null;
    private final TypeAdapter<Object> rejectedValueTypeAdapter;

    ErrorTypeAdapter(Gson gson) {
      this.rejectedValueTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Errors.Error.class == type.getRawType()
          || ImmutableErrors.Error.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Errors.Error value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeError(out, value);
      }
    }

    @Override
    public Errors.Error read(JsonReader in) throws IOException {
      return readError(in);
    }

    private void writeError(JsonWriter out, Errors.Error instance)
        throws IOException {
      out.beginObject();
      String codeValue = instance.getCode();
      if (codeValue != null) {
        out.name("code");
        out.value(codeValue);
      } else if (out.getSerializeNulls()) {
        out.name("code");
        out.nullValue();
      }
      String contextValue = instance.getContext();
      if (contextValue != null) {
        out.name("context");
        out.value(contextValue);
      } else if (out.getSerializeNulls()) {
        out.name("context");
        out.nullValue();
      }
      Object rejectedValueValue = instance.getRejectedValue();
      if (rejectedValueValue != null) {
        out.name("rejectedValue");
        rejectedValueTypeAdapter.write(out, rejectedValueValue);
      } else if (out.getSerializeNulls()) {
        out.name("rejectedValue");
        out.nullValue();
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        out.name("error");
        out.value(errorValue);
      } else if (out.getSerializeNulls()) {
        out.name("error");
        out.nullValue();
      }
      out.endObject();
    }

    private  Errors.Error readError(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableErrors.Error.Builder builder = ImmutableErrors.Error.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableErrors.Error.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'c':
        if ("code".equals(attributeName)) {
          readInCode(in, builder);
          return;
        }
        if ("context".equals(attributeName)) {
          readInContext(in, builder);
          return;
        }
        break;
      case 'r':
        if ("rejectedValue".equals(attributeName)) {
          readInRejectedValue(in, builder);
          return;
        }
        break;
      case 'e':
        if ("error".equals(attributeName)) {
          readInError(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInCode(JsonReader in, ImmutableErrors.Error.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.code(in.nextString());
      }
    }

    private void readInContext(JsonReader in, ImmutableErrors.Error.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.context(in.nextString());
      }
    }

    private void readInRejectedValue(JsonReader in, ImmutableErrors.Error.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = rejectedValueTypeAdapter.read(in);
        builder.rejectedValue(value);
      }
    }

    private void readInError(JsonReader in, ImmutableErrors.Error.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.error(in.nextString());
      }
    }
  }

  @org.immutables.value.Generated(from = "Errors", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ErrorsTypeAdapter extends TypeAdapter<Errors> {
    public final Date timestampTypeSample = null;
    public final Integer statusTypeSample = null;
    public final Errors.Error errorsTypeSample = null;
    private final TypeAdapter<Date> timestampTypeAdapter;
    private final TypeAdapter<Integer> statusTypeAdapter;
    private final TypeAdapter<Errors.Error> errorsTypeAdapter;

    ErrorsTypeAdapter(Gson gson) {
      this.timestampTypeAdapter = gson.getAdapter( Date.class);
      this.statusTypeAdapter = gson.getAdapter( Integer.class);
      this.errorsTypeAdapter = gson.getAdapter( Errors.Error.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Errors.class == type.getRawType()
          || ImmutableErrors.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Errors value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeErrors(out, value);
      }
    }

    @Override
    public Errors read(JsonReader in) throws IOException {
      return readErrors(in);
    }

    private void writeErrors(JsonWriter out, Errors instance)
        throws IOException {
      out.beginObject();
      Date timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        out.name("timestamp");
        timestampTypeAdapter.write(out, timestampValue);
      } else if (out.getSerializeNulls()) {
        out.name("timestamp");
        out.nullValue();
      }
      Integer statusValue = instance.getStatus();
      if (statusValue != null) {
        out.name("status");
        statusTypeAdapter.write(out, statusValue);
      } else if (out.getSerializeNulls()) {
        out.name("status");
        out.nullValue();
      }
      String errorValue = instance.getError();
      if (errorValue != null) {
        out.name("error");
        out.value(errorValue);
      } else if (out.getSerializeNulls()) {
        out.name("error");
        out.nullValue();
      }
      String messageValue = instance.getMessage();
      if (messageValue != null) {
        out.name("message");
        out.value(messageValue);
      } else if (out.getSerializeNulls()) {
        out.name("message");
        out.nullValue();
      }
      String traceValue = instance.getTrace();
      if (traceValue != null) {
        out.name("trace");
        out.value(traceValue);
      } else if (out.getSerializeNulls()) {
        out.name("trace");
        out.nullValue();
      }
      String pathValue = instance.getPath();
      if (pathValue != null) {
        out.name("path");
        out.value(pathValue);
      } else if (out.getSerializeNulls()) {
        out.name("path");
        out.nullValue();
      }
      List<Errors.Error> errorsElements = instance.getErrors();
      if (errorsElements != null) {
        out.name("errors");
        out.beginArray();
        for (Errors.Error e : errorsElements) {
          errorsTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("errors");
        out.nullValue();
      }
      out.endObject();
    }

    private  Errors readErrors(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableErrors.Builder builder = ImmutableErrors.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 't':
        if ("timestamp".equals(attributeName)) {
          readInTimestamp(in, builder);
          return;
        }
        if ("trace".equals(attributeName)) {
          readInTrace(in, builder);
          return;
        }
        break;
      case 's':
        if ("status".equals(attributeName)) {
          readInStatus(in, builder);
          return;
        }
        break;
      case 'e':
        if ("error".equals(attributeName)) {
          readInError(in, builder);
          return;
        }
        if ("errors".equals(attributeName)) {
          readInErrors(in, builder);
          return;
        }
        break;
      case 'm':
        if ("message".equals(attributeName)) {
          readInMessage(in, builder);
          return;
        }
        break;
      case 'p':
        if ("path".equals(attributeName)) {
          readInPath(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInTimestamp(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        builder.timestamp(null);
      } else {
        Date value = timestampTypeAdapter.read(in);
        builder.timestamp(value);
      }
    }

    private void readInStatus(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Integer value = statusTypeAdapter.read(in);
        builder.status(value);
      }
    }

    private void readInError(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.error(in.nextString());
      }
    }

    private void readInMessage(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.message(in.nextString());
      }
    }

    private void readInTrace(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.trace(in.nextString());
      }
    }

    private void readInPath(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.path(in.nextString());
      }
    }

    private void readInErrors(JsonReader in, ImmutableErrors.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        boolean empty = true;
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Errors.Error value = errorsTypeAdapter.read(in);
            builder.addErrors(value);
            empty = false;
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Errors.Error value = errorsTypeAdapter.read(in);
          builder.addErrors(value);
          empty = false;
        }
        if (empty) {
          builder.addAllErrors(Collections.<Errors.Error>emptyList());
        }
      }
    }
  }
}
