package io.dialob.api.questionnaire;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import io.dialob.api.proto.ValueSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code QuestionnaireRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "questionnaires"}.
 */
@Generated(from = "Questionnaire", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class QuestionnaireRepository extends Repositories.Repository<Questionnaire> {
  private static final String DOCUMENT_COLLECTION_NAME = "questionnaires";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link Questionnaire} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public QuestionnaireRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, Questionnaire.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The questionnaire to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Questionnaire document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends Questionnaire> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find documents by the {@link Questionnaire#getId() id} identity attribute. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.
   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(Questionnaire) replace}
   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.
   * @param id The exact {@code id} value
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findById(java.lang.String id) {
    return find(criteria().id(id));
  }

  /**
   * Update or insert a document, matched by the identifier value of the 'id' attribute.
   * @param document The questionnaire to upsert
   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> upsert(Questionnaire document) {
    Criteria byId = criteria().id(document.getId());
    return super.doUpsert(byId.constraint, document);
  }

  /**
   * Find a document by the given {@link QuestionnaireRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see QuestionnaireRepository#find(Criteria)
   */
  @Generated(from = "Questionnaire", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<Questionnaire, Finder> {
    private final Serialization serialization;

    private Finder(QuestionnaireRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link Questionnaire#getId() id} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getId() id} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderById() {
      ordering = ordering.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getId() id} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getId() id} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByIdDesceding() {
      ordering = ordering.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getRev() rev} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getRev() rev} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRev() {
      ordering = ordering.equal(serialization.revName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getRev() rev} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getRev() rev} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByRevDesceding() {
      ordering = ordering.equal(serialization.revName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getAnswers() answers} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getAnswers() answers} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByAnswers() {
      ordering = ordering.equal(serialization.answersName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getAnswers() answers} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getAnswers() answers} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByAnswersDesceding() {
      ordering = ordering.equal(serialization.answersName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getContext() context} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getContext() context} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByContext() {
      ordering = ordering.equal(serialization.contextName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getContext() context} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getContext() context} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByContextDesceding() {
      ordering = ordering.equal(serialization.contextName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getActiveItem() activeItem} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getActiveItem() activeItem} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByActiveItem() {
      ordering = ordering.equal(serialization.activeItemName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getActiveItem() activeItem} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getActiveItem() activeItem} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByActiveItemDesceding() {
      ordering = ordering.equal(serialization.activeItemName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getErrors() errors} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getErrors() errors} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByErrors() {
      ordering = ordering.equal(serialization.errorsName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getErrors() errors} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getErrors() errors} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByErrorsDesceding() {
      ordering = ordering.equal(serialization.errorsName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getVariableValues() variableValues} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getVariableValues() variableValues} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVariableValues() {
      ordering = ordering.equal(serialization.variableValuesName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getVariableValues() variableValues} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getVariableValues() variableValues} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByVariableValuesDesceding() {
      ordering = ordering.equal(serialization.variableValuesName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getValueSets() valueSets} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getValueSets() valueSets} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByValueSets() {
      ordering = ordering.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getValueSets() valueSets} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getValueSets() valueSets} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByValueSetsDesceding() {
      ordering = ordering.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getMetadata() metadata} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getMetadata() metadata} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByMetadata() {
      ordering = ordering.equal(serialization.metadataName, false, 1);
      return this;
    }

    /**
     * Order by {@link Questionnaire#getMetadata() metadata} in the descending direction.
     * Specify that the next attribute to sort will be the {@link Questionnaire#getMetadata() metadata} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByMetadataDesceding() {
      ordering = ordering.equal(serialization.metadataName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Questionnaire#getAnswers() answers} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeAnswers() {
      exclusion = exclusion.equal(serialization.answersName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Questionnaire#getContext() context} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeContext() {
      exclusion = exclusion.equal(serialization.contextName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Questionnaire#getErrors() errors} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeErrors() {
      exclusion = exclusion.equal(serialization.errorsName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Questionnaire#getVariableValues() variableValues} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeVariableValues() {
      exclusion = exclusion.equal(serialization.variableValuesName, false, -1);
      return this;
    }

    /**
     * Exclude the {@link Questionnaire#getValueSets() valueSets} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeValueSets() {
      exclusion = exclusion.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((QuestionnaireRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(Questionnaire document) {
      return new Replacer((QuestionnaireRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "questionnaires"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "Questionnaire", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<Questionnaire> {
    private final Serialization serialization;

    private Updater(QuestionnaireRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code rev} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code rev} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setRev(java.lang.String value) {
      setFields = setFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code rev} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code rev} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initRev(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearAnswers() {
      unsetFields = unsetFields.equal(serialization.answersName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeAnswers(Answer value) {
      pullFields = pullFields.equal(serialization.answersName, false, Support.writable(serialization.answersEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAnswers(Answer value) {
      pushFields = pushFields.equal(serialization.answersName, false, Support.writable(serialization.answersEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code answers} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setAnswers(Iterable<? extends Answer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Answer value : values) {
         wrappedValues.add(Support.writable(serialization.answersEncoder, value));
       }

       setFields = setFields.equal(serialization.answersName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllAnswers(Iterable<? extends Answer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Answer value : values) {
        wrappedValues.add(Support.writable(serialization.answersEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.answersName, false, v);
      return this;
    }


    /**
     * Clear the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearContext() {
      unsetFields = unsetFields.equal(serialization.contextName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeContext(ContextValue value) {
      pullFields = pullFields.equal(serialization.contextName, false, Support.writable(serialization.contextEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addContext(ContextValue value) {
      pushFields = pushFields.equal(serialization.contextName, false, Support.writable(serialization.contextEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code context} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setContext(Iterable<? extends ContextValue> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ContextValue value : values) {
         wrappedValues.add(Support.writable(serialization.contextEncoder, value));
       }

       setFields = setFields.equal(serialization.contextName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllContext(Iterable<? extends ContextValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ContextValue value : values) {
        wrappedValues.add(Support.writable(serialization.contextEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.contextName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code activeItem} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code activeItem} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setActiveItem(java.lang.String value) {
      setFields = setFields.equal(serialization.activeItemName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code activeItem} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code activeItem} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initActiveItem(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.activeItemName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearErrors() {
      unsetFields = unsetFields.equal(serialization.errorsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeErrors(Error value) {
      pullFields = pullFields.equal(serialization.errorsName, false, Support.writable(serialization.errorsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addErrors(Error value) {
      pushFields = pushFields.equal(serialization.errorsName, false, Support.writable(serialization.errorsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code errors} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setErrors(Iterable<? extends Error> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Error value : values) {
         wrappedValues.add(Support.writable(serialization.errorsEncoder, value));
       }

       setFields = setFields.equal(serialization.errorsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllErrors(Iterable<? extends Error> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Error value : values) {
        wrappedValues.add(Support.writable(serialization.errorsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.errorsName, false, v);
      return this;
    }


    /**
     * Clear the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearVariableValues() {
      unsetFields = unsetFields.equal(serialization.variableValuesName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeVariableValues(VariableValue value) {
      pullFields = pullFields.equal(serialization.variableValuesName, false, Support.writable(serialization.variableValuesEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addVariableValues(VariableValue value) {
      pushFields = pushFields.equal(serialization.variableValuesName, false, Support.writable(serialization.variableValuesEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code variableValues} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setVariableValues(Iterable<? extends VariableValue> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (VariableValue value : values) {
         wrappedValues.add(Support.writable(serialization.variableValuesEncoder, value));
       }

       setFields = setFields.equal(serialization.variableValuesName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllVariableValues(Iterable<? extends VariableValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (VariableValue value : values) {
        wrappedValues.add(Support.writable(serialization.variableValuesEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.variableValuesName, false, v);
      return this;
    }


    /**
     * Clear the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearValueSets() {
      unsetFields = unsetFields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeValueSets(ValueSet value) {
      pullFields = pullFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addValueSets(ValueSet value) {
      pushFields = pushFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code valueSets} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setValueSets(Iterable<? extends ValueSet> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ValueSet value : values) {
         wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
       }

       setFields = setFields.equal(serialization.valueSetsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllValueSets(Iterable<? extends ValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.valueSetsName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code metadata} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code metadata} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setMetadata(Questionnaire.Metadata value) {
      setFields = setFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code metadata} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code metadata} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initMetadata(Questionnaire.Metadata value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

  }

  @Generated(from = "Questionnaire", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<Questionnaire, Modifier> {
    private final Serialization serialization;

    private Modifier(
        QuestionnaireRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code id} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code id} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setId(java.lang.String value) {
      setFields = setFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code id} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code id} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initId(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.idName, false, Support.writable(value));
      return this;
    }


    /**
     * Specify a new value for the {@code rev} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code rev} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setRev(java.lang.String value) {
      setFields = setFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code rev} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code rev} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initRev(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.revName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearAnswers() {
      unsetFields = unsetFields.equal(serialization.answersName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeAnswers(Answer value) {
      pullFields = pullFields.equal(serialization.answersName, false, Support.writable(serialization.answersEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAnswers(Answer value) {
      pushFields = pushFields.equal(serialization.answersName, false, Support.writable(serialization.answersEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code answers} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setAnswers(Iterable<? extends Answer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Answer value : values) {
         wrappedValues.add(Support.writable(serialization.answersEncoder, value));
       }

       setFields = setFields.equal(serialization.answersName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code answers} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllAnswers(Iterable<? extends Answer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Answer value : values) {
        wrappedValues.add(Support.writable(serialization.answersEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.answersName, false, v);
      return this;
    }


    /**
     * Clear the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearContext() {
      unsetFields = unsetFields.equal(serialization.contextName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeContext(ContextValue value) {
      pullFields = pullFields.equal(serialization.contextName, false, Support.writable(serialization.contextEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addContext(ContextValue value) {
      pushFields = pushFields.equal(serialization.contextName, false, Support.writable(serialization.contextEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code context} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setContext(Iterable<? extends ContextValue> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ContextValue value : values) {
         wrappedValues.add(Support.writable(serialization.contextEncoder, value));
       }

       setFields = setFields.equal(serialization.contextName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code context} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllContext(Iterable<? extends ContextValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ContextValue value : values) {
        wrappedValues.add(Support.writable(serialization.contextEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.contextName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code activeItem} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code activeItem} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setActiveItem(java.lang.String value) {
      setFields = setFields.equal(serialization.activeItemName, false, Support.writable(value));
      return this;
    }

    /**
     * Specify an initial value for the {@code activeItem} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code activeItem} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initActiveItem(java.lang.String value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.activeItemName, false, Support.writable(value));
      return this;
    }


    /**
     * Clear the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearErrors() {
      unsetFields = unsetFields.equal(serialization.errorsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeErrors(Error value) {
      pullFields = pullFields.equal(serialization.errorsName, false, Support.writable(serialization.errorsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addErrors(Error value) {
      pushFields = pushFields.equal(serialization.errorsName, false, Support.writable(serialization.errorsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code errors} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setErrors(Iterable<? extends Error> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Error value : values) {
         wrappedValues.add(Support.writable(serialization.errorsEncoder, value));
       }

       setFields = setFields.equal(serialization.errorsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code errors} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllErrors(Iterable<? extends Error> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Error value : values) {
        wrappedValues.add(Support.writable(serialization.errorsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.errorsName, false, v);
      return this;
    }


    /**
     * Clear the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearVariableValues() {
      unsetFields = unsetFields.equal(serialization.variableValuesName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeVariableValues(VariableValue value) {
      pullFields = pullFields.equal(serialization.variableValuesName, false, Support.writable(serialization.variableValuesEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addVariableValues(VariableValue value) {
      pushFields = pushFields.equal(serialization.variableValuesName, false, Support.writable(serialization.variableValuesEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code variableValues} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setVariableValues(Iterable<? extends VariableValue> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (VariableValue value : values) {
         wrappedValues.add(Support.writable(serialization.variableValuesEncoder, value));
       }

       setFields = setFields.equal(serialization.variableValuesName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code variableValues} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllVariableValues(Iterable<? extends VariableValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (VariableValue value : values) {
        wrappedValues.add(Support.writable(serialization.variableValuesEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.variableValuesName, false, v);
      return this;
    }


    /**
     * Clear the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $unset} operator
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearValueSets() {
      unsetFields = unsetFields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Remove a value from the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeValueSets(ValueSet value) {
      pullFields = pullFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Add a value to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addValueSets(ValueSet value) {
      pushFields = pushFields.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value));
      return this;
    }

    /**
     * Override all values of {@code valueSets} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setValueSets(Iterable<? extends ValueSet> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ValueSet value : values) {
         wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
       }

       setFields = setFields.equal(serialization.valueSetsName, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code valueSets} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllValueSets(Iterable<? extends ValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.valueSetsName, false, v);
      return this;
    }


    /**
     * Specify a new value for the {@code metadata} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code metadata} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setMetadata(Questionnaire.Metadata value) {
      setFields = setFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code metadata} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code metadata} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initMetadata(Questionnaire.Metadata value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value));
      return this;
    }

  }

  @Generated(from = "Questionnaire", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<Questionnaire, Replacer> {
    protected Replacer(QuestionnaireRepository repository, Questionnaire document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection questionnaires by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "questionnaires"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "Questionnaire", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<Questionnaire, Indexer> {
    private final Serialization serialization;

    private Indexer(QuestionnaireRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getId() id}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withId() {
      fields = fields.equal(serialization.idName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getId() id}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withIdDesceding() {
      fields = fields.equal(serialization.idName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getRev() rev}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRev() {
      fields = fields.equal(serialization.revName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getRev() rev}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withRevDesceding() {
      fields = fields.equal(serialization.revName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getAnswers() answers}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withAnswers() {
      fields = fields.equal(serialization.answersName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getAnswers() answers}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withAnswersDesceding() {
      fields = fields.equal(serialization.answersName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getContext() context}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withContext() {
      fields = fields.equal(serialization.contextName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getContext() context}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withContextDesceding() {
      fields = fields.equal(serialization.contextName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getActiveItem() activeItem}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withActiveItem() {
      fields = fields.equal(serialization.activeItemName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getActiveItem() activeItem}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withActiveItemDesceding() {
      fields = fields.equal(serialization.activeItemName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getErrors() errors}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withErrors() {
      fields = fields.equal(serialization.errorsName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getErrors() errors}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withErrorsDesceding() {
      fields = fields.equal(serialization.errorsName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getVariableValues() variableValues}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVariableValues() {
      fields = fields.equal(serialization.variableValuesName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getVariableValues() variableValues}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withVariableValuesDesceding() {
      fields = fields.equal(serialization.variableValuesName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getValueSets() valueSets}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withValueSets() {
      fields = fields.equal(serialization.valueSetsName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getValueSets() valueSets}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withValueSetsDesceding() {
      fields = fields.equal(serialization.valueSetsName, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getMetadata() metadata}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withMetadata() {
      fields = fields.equal(serialization.metadataName, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link Questionnaire#getMetadata() metadata}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withMetadataDesceding() {
      fields = fields.equal(serialization.metadataName, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code QuestionnaireRepository.Criteria} is a Questionnaire document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "Questionnaire", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria id(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, false, Support.writable(value)));
    }

    public Criteria idNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.idName, true, Support.writable(value)));
    }

    public Criteria idIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, wrappedValues));
    }

    public Criteria idIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, false, values));
    }

    public Criteria idNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, wrappedValues));
    }

    public Criteria idNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.idName, true, values));
    }

    public Criteria idStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria idMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, false, pattern));
    }

    public Criteria idNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.idName, true, pattern));
    }

    public Criteria idGreaterThan(java.lang.String lower) {
      return idIn(Range.greaterThan(lower));
    }

    public Criteria idLessThan(java.lang.String upper) {
      return idIn(Range.lessThan(upper));
    }

    public Criteria idAtMost(java.lang.String upperInclusive) {
      return idIn(Range.atMost(upperInclusive));
    }

    public Criteria idAtLeast(java.lang.String lowerInclusive) {
      return idIn(Range.atLeast(lowerInclusive));
    }

    public Criteria idIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, false, Support.writable(range)));
    }

    public Criteria idNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.idName, true, Support.writable(range)));
    }

    public Criteria rev(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.revName, false, Support.writable(value)));
    }

    public Criteria revNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.revName, true, Support.writable(value)));
    }

    public Criteria revIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, false, wrappedValues));
    }

    public Criteria revIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, false, values));
    }

    public Criteria revNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, true, wrappedValues));
    }

    public Criteria revNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.revName, true, values));
    }

    public Criteria revStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.revName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria revMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.revName, false, pattern));
    }

    public Criteria revNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.revName, true, pattern));
    }

    public Criteria revGreaterThan(java.lang.String lower) {
      return revIn(Range.greaterThan(lower));
    }

    public Criteria revLessThan(java.lang.String upper) {
      return revIn(Range.lessThan(upper));
    }

    public Criteria revAtMost(java.lang.String upperInclusive) {
      return revIn(Range.atMost(upperInclusive));
    }

    public Criteria revAtLeast(java.lang.String lowerInclusive) {
      return revIn(Range.atLeast(lowerInclusive));
    }

    public Criteria revIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.revName, false, Support.writable(range)));
    }

    public Criteria revNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.revName, true, Support.writable(range)));
    }

    public Criteria answersEmpty() {
      return new Criteria(serialization, constraint.size(serialization.answersName, false, 0));
    }

    public Criteria answersNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.answersName, true, 0));
    }

    public Criteria answersSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.answersName, false, size));
    }

    public Criteria answersContains(Answer value) {
      return new Criteria(serialization, constraint.equal(serialization.answersName, false, Support.writable(serialization.answersEncoder, value)));
    }

    public Criteria answersContainsAll(Iterable<Answer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Answer value : values) {
        wrappedValues.add(Support.writable(serialization.answersEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.answersName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria contextEmpty() {
      return new Criteria(serialization, constraint.size(serialization.contextName, false, 0));
    }

    public Criteria contextNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.contextName, true, 0));
    }

    public Criteria contextSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.contextName, false, size));
    }

    public Criteria contextContains(ContextValue value) {
      return new Criteria(serialization, constraint.equal(serialization.contextName, false, Support.writable(serialization.contextEncoder, value)));
    }

    public Criteria contextContainsAll(Iterable<ContextValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ContextValue value : values) {
        wrappedValues.add(Support.writable(serialization.contextEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.contextName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria activeItem(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.activeItemName, false, Support.writable(value)));
    }

    public Criteria activeItemNot(java.lang.String value) {
      return new Criteria(serialization, constraint.equal(serialization.activeItemName, true, Support.writable(value)));
    }

    public Criteria activeItemIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.activeItemName, false, wrappedValues));
    }

    public Criteria activeItemIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.activeItemName, false, values));
    }

    public Criteria activeItemNotIn(Iterable<java.lang.String> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.String value : values) {
        wrappedValues.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.activeItemName, true, wrappedValues));
    }

    public Criteria activeItemNotIn(java.lang.String first, java.lang.String second, java.lang.String... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(first));
      values.add(Support.writable(second));
      for (java.lang.String value : rest) {
        values.add(Support.writable(value));
      }
      return new Criteria(serialization, constraint.in(serialization.activeItemName, true, values));
    }

    public Criteria activeItemStartsWith(String prefix) {
      return new Criteria(serialization, constraint.match(serialization.activeItemName, false, Constraints.prefixPatternOf(prefix)));
    }

    public Criteria activeItemMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.activeItemName, false, pattern));
    }

    public Criteria activeItemNotMatches(Pattern pattern) {
      return new Criteria(serialization, constraint.match(serialization.activeItemName, true, pattern));
    }

    public Criteria activeItemGreaterThan(java.lang.String lower) {
      return activeItemIn(Range.greaterThan(lower));
    }

    public Criteria activeItemLessThan(java.lang.String upper) {
      return activeItemIn(Range.lessThan(upper));
    }

    public Criteria activeItemAtMost(java.lang.String upperInclusive) {
      return activeItemIn(Range.atMost(upperInclusive));
    }

    public Criteria activeItemAtLeast(java.lang.String lowerInclusive) {
      return activeItemIn(Range.atLeast(lowerInclusive));
    }

    public Criteria activeItemIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.activeItemName, false, Support.writable(range)));
    }

    public Criteria activeItemNotIn(Range<java.lang.String> range) {
      return new Criteria(serialization, constraint.range(serialization.activeItemName, true, Support.writable(range)));
    }

    public Criteria errorsEmpty() {
      return new Criteria(serialization, constraint.size(serialization.errorsName, false, 0));
    }

    public Criteria errorsNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.errorsName, true, 0));
    }

    public Criteria errorsSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.errorsName, false, size));
    }

    public Criteria errorsContains(Error value) {
      return new Criteria(serialization, constraint.equal(serialization.errorsName, false, Support.writable(serialization.errorsEncoder, value)));
    }

    public Criteria errorsContainsAll(Iterable<Error> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Error value : values) {
        wrappedValues.add(Support.writable(serialization.errorsEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.errorsName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria variableValuesEmpty() {
      return new Criteria(serialization, constraint.size(serialization.variableValuesName, false, 0));
    }

    public Criteria variableValuesNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.variableValuesName, true, 0));
    }

    public Criteria variableValuesSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.variableValuesName, false, size));
    }

    public Criteria variableValuesContains(VariableValue value) {
      return new Criteria(serialization, constraint.equal(serialization.variableValuesName, false, Support.writable(serialization.variableValuesEncoder, value)));
    }

    public Criteria variableValuesContainsAll(Iterable<VariableValue> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (VariableValue value : values) {
        wrappedValues.add(Support.writable(serialization.variableValuesEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.variableValuesName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria valueSetsEmpty() {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, false, 0));
    }

    public Criteria valueSetsNonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, true, 0));
    }

    public Criteria valueSetsSize(int size) {
      return new Criteria(serialization, constraint.size(serialization.valueSetsName, false, size));
    }

    public Criteria valueSetsContains(ValueSet value) {
      return new Criteria(serialization, constraint.equal(serialization.valueSetsName, false, Support.writable(serialization.valueSetsEncoder, value)));
    }

    public Criteria valueSetsContainsAll(Iterable<ValueSet> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ValueSet value : values) {
        wrappedValues.add(Support.writable(serialization.valueSetsEncoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.valueSetsName, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria metadata(Questionnaire.Metadata value) {
      return new Criteria(serialization, constraint.equal(serialization.metadataName, false, Support.writable(serialization.metadataEncoder, value)));
    }

    public Criteria metadataNot(Questionnaire.Metadata value) {
      return new Criteria(serialization, constraint.equal(serialization.metadataName, true, Support.writable(serialization.metadataEncoder, value)));
    }

    public Criteria metadataIn(Iterable<Questionnaire.Metadata> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Questionnaire.Metadata value : values) {
        wrappedValues.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, false, wrappedValues));
    }

    public Criteria metadataIn(Questionnaire.Metadata first, Questionnaire.Metadata second, Questionnaire.Metadata... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.metadataEncoder, first));
      values.add(Support.writable(serialization.metadataEncoder, second));
      for (Questionnaire.Metadata value : rest) {
        values.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, false, values));
    }

    public Criteria metadataNotIn(Iterable<Questionnaire.Metadata> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Questionnaire.Metadata value : values) {
        wrappedValues.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, true, wrappedValues));
    }

    public Criteria metadataNotIn(Questionnaire.Metadata first, Questionnaire.Metadata second, Questionnaire.Metadata... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.metadataEncoder, first));
      values.add(Support.writable(serialization.metadataEncoder, second));
      for (Questionnaire.Metadata value : rest) {
        values.add(Support.writable(serialization.metadataEncoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.metadataName, true, values));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "QuestionnaireRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "Questionnaire", generator = "Repositories")
  private static class Serialization {
    final Encoder<Answer> answersEncoder;
    final Encoder<ContextValue> contextEncoder;
    final Encoder<Error> errorsEncoder;
    final Encoder<VariableValue> variableValuesEncoder;
    final Encoder<ValueSet> valueSetsEncoder;
    final Encoder<Questionnaire.Metadata> metadataEncoder;
    final CodecRegistry registry;
    final String idName;
    final String revName;
    final String answersName;
    final String contextName;
    final String activeItemName;
    final String errorsName;
    final String variableValuesName;
    final String valueSetsName;
    final String metadataName;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.answersEncoder = this.registry.get(Answer.class);
      this.contextEncoder = this.registry.get(ContextValue.class);
      this.errorsEncoder = this.registry.get(Error.class);
      this.variableValuesEncoder = this.registry.get(VariableValue.class);
      this.valueSetsEncoder = this.registry.get(ValueSet.class);
      this.metadataEncoder = this.registry.get(Questionnaire.Metadata.class);
      this.idName = "_id";
      this.revName = "_rev";
      this.answersName = translateName(fieldNamingStrategy, "answers");
      this.contextName = translateName(fieldNamingStrategy, "context");
      this.activeItemName = translateName(fieldNamingStrategy, "activeItem");
      this.errorsName = translateName(fieldNamingStrategy, "errors");
      this.variableValuesName = translateName(fieldNamingStrategy, "variableValues");
      this.valueSetsName = translateName(fieldNamingStrategy, "valueSets");
      this.metadataName = translateName(fieldNamingStrategy, "metadata");
    }

    @Generated(from = "Questionnaire", generator = "Repositories")
    static final class QuestionnaireNamingFields {
      public java.lang.String id;
      public java.lang.String rev;
      public List<Answer> answers;
      public List<ContextValue> context;
      public java.lang.String activeItem;
      public List<Error> errors;
      public List<VariableValue> variableValues;
      public List<ValueSet> valueSets;
      public Questionnaire.Metadata metadata;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            QuestionnaireNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
