package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Questionnaire.Metadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaireMetadata.builder()}.
 */
@Generated(from = "Questionnaire.Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaireMetadata extends Questionnaire.Metadata {
  private final String formId;
  private final @Nullable String formName;
  private final Questionnaire.Metadata.Status status;
  private final @Nullable String formRev;
  private final @Nullable String tenantId;
  private final @Nullable Date created;
  private final @Nullable Date lastAnswer;
  private final @Nullable Date opened;
  private final @Nullable Date completed;
  private final @Nullable String label;
  private final @Nullable String submitUrl;
  private final @Nullable Questionnaire.Metadata.Reason reason;
  private final @Nullable String language;
  private final @Nullable String owner;
  private final @Nullable String creator;
  private final Map<String, Object> additionalProperties;

  private ImmutableQuestionnaireMetadata(ImmutableQuestionnaireMetadata.Builder builder) {
    this.formId = builder.formId;
    this.formName = builder.formName;
    this.formRev = builder.formRev;
    this.tenantId = builder.tenantId;
    this.created = builder.created;
    this.lastAnswer = builder.lastAnswer;
    this.opened = builder.opened;
    this.completed = builder.completed;
    this.label = builder.label;
    this.submitUrl = builder.submitUrl;
    this.reason = builder.reason;
    this.language = builder.language;
    this.owner = builder.owner;
    this.creator = builder.creator;
    this.additionalProperties = createUnmodifiableMap(false, false, builder.additionalProperties);
    this.status = builder.statusIsSet()
        ? builder.status
        : super.getStatus();
  }

  private ImmutableQuestionnaireMetadata(
      String formId,
      @Nullable String formName,
      Questionnaire.Metadata.Status status,
      @Nullable String formRev,
      @Nullable String tenantId,
      @Nullable Date created,
      @Nullable Date lastAnswer,
      @Nullable Date opened,
      @Nullable Date completed,
      @Nullable String label,
      @Nullable String submitUrl,
      @Nullable Questionnaire.Metadata.Reason reason,
      @Nullable String language,
      @Nullable String owner,
      @Nullable String creator,
      Map<String, Object> additionalProperties) {
    this.formId = formId;
    this.formName = formName;
    this.status = status;
    this.formRev = formRev;
    this.tenantId = tenantId;
    this.created = created;
    this.lastAnswer = lastAnswer;
    this.opened = opened;
    this.completed = completed;
    this.label = label;
    this.submitUrl = submitUrl;
    this.reason = reason;
    this.language = language;
    this.owner = owner;
    this.creator = creator;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The value of the {@code formId} attribute
   */
  @JsonProperty("formId")
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return The value of the {@code formName} attribute
   */
  @JsonProperty("formName")
  @Override
  public @Nullable String getFormName() {
    return formName;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public Questionnaire.Metadata.Status getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code formRev} attribute
   */
  @JsonProperty("formRev")
  @Override
  public @Nullable String getFormRev() {
    return formRev;
  }

  /**
   * @return The value of the {@code tenantId} attribute
   */
  @JsonProperty("tenantId")
  @Override
  public @Nullable String getTenantId() {
    return tenantId;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code lastAnswer} attribute
   */
  @JsonProperty("lastAnswer")
  @Override
  public @Nullable Date getLastAnswer() {
    return lastAnswer;
  }

  /**
   * @return The value of the {@code opened} attribute
   */
  @JsonProperty("opened")
  @Override
  public @Nullable Date getOpened() {
    return opened;
  }

  /**
   * @return The value of the {@code completed} attribute
   */
  @JsonProperty("completed")
  @Override
  public @Nullable Date getCompleted() {
    return completed;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public @Nullable String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code submitUrl} attribute
   */
  @JsonProperty("submitUrl")
  @Override
  public @Nullable String getSubmitUrl() {
    return submitUrl;
  }

  /**
   * Completion reason, null if normally completed.
   */
  @JsonProperty("reason")
  @Override
  public @Nullable Questionnaire.Metadata.Reason getReason() {
    return reason;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @JsonProperty("language")
  @Override
  public @Nullable String getLanguage() {
    return language;
  }

  /**
   * userId of document owner
   */
  @JsonProperty("owner")
  @Override
  public @Nullable String getOwner() {
    return owner;
  }

  /**
   * userId of one who created questionnaire
   */
  @JsonProperty("creator")
  @Override
  public @Nullable String getCreator() {
    return creator;
  }

  /**
   * @return The value of the {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @JsonAnyGetter
  @Override
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withFormId(String value) {
    if (Objects.equals(this.formId, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        value,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getFormName() formName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withFormName(@Nullable String value) {
    if (Objects.equals(this.formName, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        value,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withStatus(Questionnaire.Metadata.Status value) {
    Questionnaire.Metadata.Status newValue = value;
    if (this.status == newValue) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        newValue,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getFormRev() formRev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formRev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withFormRev(@Nullable String value) {
    if (Objects.equals(this.formRev, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        value,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withTenantId(@Nullable String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        value,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withCreated(@Nullable Date value) {
    if (this.created == value) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        value,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getLastAnswer() lastAnswer} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastAnswer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withLastAnswer(@Nullable Date value) {
    if (this.lastAnswer == value) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        value,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getOpened() opened} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for opened (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withOpened(@Nullable Date value) {
    if (this.opened == value) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        value,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getCompleted() completed} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for completed (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withCompleted(@Nullable Date value) {
    if (this.completed == value) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        value,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withLabel(@Nullable String value) {
    if (Objects.equals(this.label, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        value,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getSubmitUrl() submitUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for submitUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withSubmitUrl(@Nullable String value) {
    if (Objects.equals(this.submitUrl, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        value,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getReason() reason} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withReason(@Nullable Questionnaire.Metadata.Reason value) {
    if (this.reason == value) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        value,
        this.language,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getLanguage() language} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for language (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withLanguage(@Nullable String value) {
    if (Objects.equals(this.language, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        value,
        this.owner,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getOwner() owner} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for owner (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withOwner(@Nullable String value) {
    if (Objects.equals(this.owner, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        value,
        this.creator,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire.Metadata#getCreator() creator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for creator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withCreator(@Nullable String value) {
    if (Objects.equals(this.creator, value)) return this;
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        value,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the additionalProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaireMetadata withAdditionalProperties(Map<String, ? extends Object> entries) {
    if (this.additionalProperties == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableQuestionnaireMetadata(
        this.formId,
        this.formName,
        this.status,
        this.formRev,
        this.tenantId,
        this.created,
        this.lastAnswer,
        this.opened,
        this.completed,
        this.label,
        this.submitUrl,
        this.reason,
        this.language,
        this.owner,
        this.creator,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaireMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaireMetadata
        && equalTo(0, (ImmutableQuestionnaireMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableQuestionnaireMetadata another) {
    return Objects.equals(formId, another.formId)
        && Objects.equals(formName, another.formName)
        && status.equals(another.status)
        && Objects.equals(formRev, another.formRev)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(created, another.created)
        && Objects.equals(lastAnswer, another.lastAnswer)
        && Objects.equals(opened, another.opened)
        && Objects.equals(completed, another.completed)
        && Objects.equals(label, another.label)
        && Objects.equals(submitUrl, another.submitUrl)
        && Objects.equals(reason, another.reason)
        && Objects.equals(language, another.language)
        && Objects.equals(owner, another.owner)
        && Objects.equals(creator, another.creator)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code formName}, {@code status}, {@code formRev}, {@code tenantId}, {@code created}, {@code lastAnswer}, {@code opened}, {@code completed}, {@code label}, {@code submitUrl}, {@code reason}, {@code language}, {@code owner}, {@code creator}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(formId);
    h += (h << 5) + Objects.hashCode(formName);
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(formRev);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastAnswer);
    h += (h << 5) + Objects.hashCode(opened);
    h += (h << 5) + Objects.hashCode(completed);
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(submitUrl);
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(language);
    h += (h << 5) + Objects.hashCode(owner);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "formId=" + formId
        + ", formName=" + formName
        + ", status=" + status
        + ", formRev=" + formRev
        + ", tenantId=" + tenantId
        + ", created=" + created
        + ", lastAnswer=" + lastAnswer
        + ", opened=" + opened
        + ", completed=" + completed
        + ", label=" + label
        + ", submitUrl=" + submitUrl
        + ", reason=" + reason
        + ", language=" + language
        + ", owner=" + owner
        + ", creator=" + creator
        + ", additionalProperties=" + additionalProperties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Questionnaire.Metadata", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Questionnaire.Metadata {
    @javax.annotation.Nullable String formId;
    @javax.annotation.Nullable String formName;
    @javax.annotation.Nullable Questionnaire.Metadata.Status status;
    boolean statusIsSet;
    @javax.annotation.Nullable String formRev;
    @javax.annotation.Nullable String tenantId;
    @javax.annotation.Nullable Date created;
    @javax.annotation.Nullable Date lastAnswer;
    @javax.annotation.Nullable Date opened;
    @javax.annotation.Nullable Date completed;
    @javax.annotation.Nullable String label;
    @javax.annotation.Nullable String submitUrl;
    @javax.annotation.Nullable Questionnaire.Metadata.Reason reason;
    @javax.annotation.Nullable String language;
    @javax.annotation.Nullable String owner;
    @javax.annotation.Nullable String creator;
    final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty("formId")
    public void setFormId(String formId) {
      this.formId = formId;
    }
    @JsonProperty("formName")
    public void setFormName(@Nullable String formName) {
      this.formName = formName;
    }
    @JsonProperty("status")
    public void setStatus(Questionnaire.Metadata.Status status) {
      this.status = status;
      this.statusIsSet = null != status;
    }
    @JsonProperty("formRev")
    public void setFormRev(@Nullable String formRev) {
      this.formRev = formRev;
    }
    @JsonProperty("tenantId")
    public void setTenantId(@Nullable String tenantId) {
      this.tenantId = tenantId;
    }
    @JsonProperty("created")
    public void setCreated(@Nullable Date created) {
      this.created = created;
    }
    @JsonProperty("lastAnswer")
    public void setLastAnswer(@Nullable Date lastAnswer) {
      this.lastAnswer = lastAnswer;
    }
    @JsonProperty("opened")
    public void setOpened(@Nullable Date opened) {
      this.opened = opened;
    }
    @JsonProperty("completed")
    public void setCompleted(@Nullable Date completed) {
      this.completed = completed;
    }
    @JsonProperty("label")
    public void setLabel(@Nullable String label) {
      this.label = label;
    }
    @JsonProperty("submitUrl")
    public void setSubmitUrl(@Nullable String submitUrl) {
      this.submitUrl = submitUrl;
    }
    @JsonProperty("reason")
    public void setReason(@Nullable Questionnaire.Metadata.Reason reason) {
      this.reason = reason;
    }
    @JsonProperty("language")
    public void setLanguage(@Nullable String language) {
      this.language = language;
    }
    @JsonProperty("owner")
    public void setOwner(@Nullable String owner) {
      this.owner = owner;
    }
    @JsonProperty("creator")
    public void setCreator(@Nullable String creator) {
      this.creator = creator;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
    @Override
    public String getFormId() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormName() { throw new UnsupportedOperationException(); }
    @Override
    public Questionnaire.Metadata.Status getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public String getFormRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getTenantId() { throw new UnsupportedOperationException(); }
    @Override
    public Date getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Date getLastAnswer() { throw new UnsupportedOperationException(); }
    @Override
    public Date getOpened() { throw new UnsupportedOperationException(); }
    @Override
    public Date getCompleted() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubmitUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Questionnaire.Metadata.Reason getReason() { throw new UnsupportedOperationException(); }
    @Override
    public String getLanguage() { throw new UnsupportedOperationException(); }
    @Override
    public String getOwner() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreator() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getAdditionalProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQuestionnaireMetadata fromJson(Json json) {
    ImmutableQuestionnaireMetadata.Builder builder = ImmutableQuestionnaireMetadata.builder();
    if (json.formId != null) {
      builder.formId(json.formId);
    }
    if (json.formName != null) {
      builder.formName(json.formName);
    }
    if (json.statusIsSet) {
      builder.status(json.status);
    }
    if (json.formRev != null) {
      builder.formRev(json.formRev);
    }
    if (json.tenantId != null) {
      builder.tenantId(json.tenantId);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.lastAnswer != null) {
      builder.lastAnswer(json.lastAnswer);
    }
    if (json.opened != null) {
      builder.opened(json.opened);
    }
    if (json.completed != null) {
      builder.completed(json.completed);
    }
    if (json.label != null) {
      builder.label(json.label);
    }
    if (json.submitUrl != null) {
      builder.submitUrl(json.submitUrl);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    if (json.language != null) {
      builder.language(json.language);
    }
    if (json.owner != null) {
      builder.owner(json.owner);
    }
    if (json.creator != null) {
      builder.creator(json.creator);
    }
    if (json.additionalProperties != null) {
      builder.putAllAdditionalProperties(json.additionalProperties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Questionnaire.Metadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Metadata instance
   */
  public static ImmutableQuestionnaireMetadata copyOf(Questionnaire.Metadata instance) {
    if (instance instanceof ImmutableQuestionnaireMetadata) {
      return (ImmutableQuestionnaireMetadata) instance;
    }
    return ImmutableQuestionnaireMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaireMetadata ImmutableQuestionnaireMetadata}.
   * <pre>
   * ImmutableQuestionnaireMetadata.builder()
   *    .formId(String | null) // nullable {@link Questionnaire.Metadata#getFormId() formId}
   *    .formName(String | null) // nullable {@link Questionnaire.Metadata#getFormName() formName}
   *    .status(io.dialob.api.questionnaire.Questionnaire.Metadata.Status) // optional {@link Questionnaire.Metadata#getStatus() status}
   *    .formRev(String | null) // nullable {@link Questionnaire.Metadata#getFormRev() formRev}
   *    .tenantId(String | null) // nullable {@link Questionnaire.Metadata#getTenantId() tenantId}
   *    .created(Date | null) // nullable {@link Questionnaire.Metadata#getCreated() created}
   *    .lastAnswer(Date | null) // nullable {@link Questionnaire.Metadata#getLastAnswer() lastAnswer}
   *    .opened(Date | null) // nullable {@link Questionnaire.Metadata#getOpened() opened}
   *    .completed(Date | null) // nullable {@link Questionnaire.Metadata#getCompleted() completed}
   *    .label(String | null) // nullable {@link Questionnaire.Metadata#getLabel() label}
   *    .submitUrl(String | null) // nullable {@link Questionnaire.Metadata#getSubmitUrl() submitUrl}
   *    .reason(io.dialob.api.questionnaire.Questionnaire.Metadata.Reason | null) // nullable {@link Questionnaire.Metadata#getReason() reason}
   *    .language(String | null) // nullable {@link Questionnaire.Metadata#getLanguage() language}
   *    .owner(String | null) // nullable {@link Questionnaire.Metadata#getOwner() owner}
   *    .creator(String | null) // nullable {@link Questionnaire.Metadata#getCreator() creator}
   *    .putAdditionalProperties|putAllAdditionalProperties(String =&gt; Object) // {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaireMetadata builder
   */
  public static ImmutableQuestionnaireMetadata.Builder builder() {
    return new ImmutableQuestionnaireMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaireMetadata ImmutableQuestionnaireMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Questionnaire.Metadata", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_STATUS = 0x1L;
    private long optBits;

    private @javax.annotation.Nullable String formId;
    private @javax.annotation.Nullable String formName;
    private @javax.annotation.Nullable Questionnaire.Metadata.Status status;
    private @javax.annotation.Nullable String formRev;
    private @javax.annotation.Nullable String tenantId;
    private @javax.annotation.Nullable Date created;
    private @javax.annotation.Nullable Date lastAnswer;
    private @javax.annotation.Nullable Date opened;
    private @javax.annotation.Nullable Date completed;
    private @javax.annotation.Nullable String label;
    private @javax.annotation.Nullable String submitUrl;
    private @javax.annotation.Nullable Questionnaire.Metadata.Reason reason;
    private @javax.annotation.Nullable String language;
    private @javax.annotation.Nullable String owner;
    private @javax.annotation.Nullable String creator;
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableQuestionnaireMetadata} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableQuestionnaireMetadata instance) {
      Objects.requireNonNull(instance, "instance");
      String formIdValue = instance.getFormId();
      if (formIdValue != null) {
        formId(formIdValue);
      }
      String formNameValue = instance.getFormName();
      if (formNameValue != null) {
        formName(formNameValue);
      }
      status(instance.getStatus());
      String formRevValue = instance.getFormRev();
      if (formRevValue != null) {
        formRev(formRevValue);
      }
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        tenantId(tenantIdValue);
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      Date lastAnswerValue = instance.getLastAnswer();
      if (lastAnswerValue != null) {
        lastAnswer(lastAnswerValue);
      }
      Date openedValue = instance.getOpened();
      if (openedValue != null) {
        opened(openedValue);
      }
      Date completedValue = instance.getCompleted();
      if (completedValue != null) {
        completed(completedValue);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      String submitUrlValue = instance.getSubmitUrl();
      if (submitUrlValue != null) {
        submitUrl(submitUrlValue);
      }
      Questionnaire.Metadata.Reason reasonValue = instance.getReason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      String languageValue = instance.getLanguage();
      if (languageValue != null) {
        language(languageValue);
      }
      String ownerValue = instance.getOwner();
      if (ownerValue != null) {
        owner(ownerValue);
      }
      String creatorValue = instance.getCreator();
      if (creatorValue != null) {
        creator(creatorValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Questionnaire.Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableQuestionnaireMetadata) {
        return from((ModifiableQuestionnaireMetadata) instance);
      }
      String formIdValue = instance.getFormId();
      if (formIdValue != null) {
        formId(formIdValue);
      }
      String formNameValue = instance.getFormName();
      if (formNameValue != null) {
        formName(formNameValue);
      }
      status(instance.getStatus());
      String formRevValue = instance.getFormRev();
      if (formRevValue != null) {
        formRev(formRevValue);
      }
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        tenantId(tenantIdValue);
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        created(createdValue);
      }
      Date lastAnswerValue = instance.getLastAnswer();
      if (lastAnswerValue != null) {
        lastAnswer(lastAnswerValue);
      }
      Date openedValue = instance.getOpened();
      if (openedValue != null) {
        opened(openedValue);
      }
      Date completedValue = instance.getCompleted();
      if (completedValue != null) {
        completed(completedValue);
      }
      String labelValue = instance.getLabel();
      if (labelValue != null) {
        label(labelValue);
      }
      String submitUrlValue = instance.getSubmitUrl();
      if (submitUrlValue != null) {
        submitUrl(submitUrlValue);
      }
      Questionnaire.Metadata.Reason reasonValue = instance.getReason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      String languageValue = instance.getLanguage();
      if (languageValue != null) {
        language(languageValue);
      }
      String ownerValue = instance.getOwner();
      if (ownerValue != null) {
        owner(ownerValue);
      }
      String creatorValue = instance.getCreator();
      if (creatorValue != null) {
        creator(creatorValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getFormId() formId} attribute.
     * @param formId The value for formId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formId")
    public final Builder formId(String formId) {
      this.formId = formId;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getFormName() formName} attribute.
     * @param formName The value for formName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formName")
    public final Builder formName(@Nullable String formName) {
      this.formName = formName;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getStatus() status} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link Questionnaire.Metadata#getStatus() status}.</em>
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(Questionnaire.Metadata.Status status) {
      this.status = status;
      optBits |= OPT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getFormRev() formRev} attribute.
     * @param formRev The value for formRev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("formRev")
    public final Builder formRev(@Nullable String formRev) {
      this.formRev = formRev;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tenantId")
    public final Builder tenantId(@Nullable String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getCreated() created} attribute.
     * @param created The value for created (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(@Nullable Date created) {
      this.created = created;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getLastAnswer() lastAnswer} attribute.
     * @param lastAnswer The value for lastAnswer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastAnswer")
    public final Builder lastAnswer(@Nullable Date lastAnswer) {
      this.lastAnswer = lastAnswer;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getOpened() opened} attribute.
     * @param opened The value for opened (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("opened")
    public final Builder opened(@Nullable Date opened) {
      this.opened = opened;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getCompleted() completed} attribute.
     * @param completed The value for completed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("completed")
    public final Builder completed(@Nullable Date completed) {
      this.completed = completed;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getLabel() label} attribute.
     * @param label The value for label (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(@Nullable String label) {
      this.label = label;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getSubmitUrl() submitUrl} attribute.
     * @param submitUrl The value for submitUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("submitUrl")
    public final Builder submitUrl(@Nullable String submitUrl) {
      this.submitUrl = submitUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getReason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reason")
    public final Builder reason(@Nullable Questionnaire.Metadata.Reason reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getLanguage() language} attribute.
     * @param language The value for language (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("language")
    public final Builder language(@Nullable String language) {
      this.language = language;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getOwner() owner} attribute.
     * @param owner The value for owner (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("owner")
    public final Builder owner(@Nullable String owner) {
      this.owner = owner;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire.Metadata#getCreator() creator} attribute.
     * @param creator The value for creator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("creator")
    public final Builder creator(@Nullable String creator) {
      this.creator = creator;
      return this;
    }

    /**
     * Put one entry to the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map.
     * @param key The key in the additionalProperties map
     * @param value The associated value in the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder putAdditionalProperties(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      this.additionalProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.additionalProperties.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("additionalProperties")
    @JsonInclude
    public final Builder additionalProperties(Map<String, ? extends Object> entries) {
      this.additionalProperties.clear();
      return putAllAdditionalProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.additionalProperties.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaireMetadata ImmutableQuestionnaireMetadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaireMetadata build() {
      return new ImmutableQuestionnaireMetadata(this);
    }

    private boolean statusIsSet() {
      return (optBits & OPT_BIT_STATUS) != 0;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
