package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import io.dialob.api.proto.ImmutableValueSet;
import io.dialob.api.proto.ValueSet;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Questionnaire}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQuestionnaire.builder()}.
 */
@Generated(from = "Questionnaire", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQuestionnaire implements Questionnaire {
  private final @Nullable String id;
  private final @Nullable String rev;
  private final List<Answer> answers;
  private final List<ContextValue> context;
  private final @Nullable String activeItem;
  private final List<Error> errors;
  private final List<VariableValue> variableValues;
  private final List<ValueSet> valueSets;
  private final ImmutableQuestionnaireMetadata metadata;

  private ImmutableQuestionnaire(
      @Nullable String id,
      @Nullable String rev,
      List<Answer> answers,
      List<ContextValue> context,
      @Nullable String activeItem,
      List<Error> errors,
      List<VariableValue> variableValues,
      List<ValueSet> valueSets,
      ImmutableQuestionnaireMetadata metadata) {
    this.id = id;
    this.rev = rev;
    this.answers = answers;
    this.context = context;
    this.activeItem = activeItem;
    this.errors = errors;
    this.variableValues = variableValues;
    this.valueSets = valueSets;
    this.metadata = metadata;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("_id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("_rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code answers} attribute
   */
  @JsonProperty("answers")
  @Override
  public List<Answer> getAnswers() {
    return answers;
  }

  /**
   * @return The value of the {@code context} attribute
   */
  @JsonProperty("context")
  @Override
  public List<ContextValue> getContext() {
    return context;
  }

  /**
   * @return The value of the {@code activeItem} attribute
   */
  @JsonProperty("activeItem")
  @Override
  public @Nullable String getActiveItem() {
    return activeItem;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public List<Error> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code variableValues} attribute
   */
  @JsonProperty("variableValues")
  @Override
  public List<VariableValue> getVariableValues() {
    return variableValues;
  }

  /**
   * @return The value of the {@code valueSets} attribute
   */
  @JsonProperty("valueSets")
  @Override
  public List<ValueSet> getValueSets() {
    return valueSets;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @Override
  public ImmutableQuestionnaireMetadata getMetadata() {
    return metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaire withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return validate(new ImmutableQuestionnaire(
        value,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaire withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return validate(new ImmutableQuestionnaire(
        this.id,
        value,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getAnswers() answers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withAnswers(Answer... elements) {
    List<Answer> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        newValue,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getAnswers() answers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of answers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withAnswers(Iterable<? extends Answer> elements) {
    if (this.answers == elements) return this;
    List<Answer> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        newValue,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getContext() context}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withContext(ContextValue... elements) {
    List<ContextValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        newValue,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getContext() context}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of context elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withContext(Iterable<? extends ContextValue> elements) {
    if (this.context == elements) return this;
    List<ContextValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        newValue,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire#getActiveItem() activeItem} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for activeItem (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaire withActiveItem(@Nullable String value) {
    if (Objects.equals(this.activeItem, value)) return this;
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        value,
        this.errors,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withErrors(Error... elements) {
    List<Error> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        newValue,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withErrors(Iterable<? extends Error> elements) {
    if (this.errors == elements) return this;
    List<Error> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        newValue,
        this.variableValues,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getVariableValues() variableValues}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withVariableValues(VariableValue... elements) {
    List<VariableValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        newValue,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getVariableValues() variableValues}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of variableValues elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withVariableValues(Iterable<? extends VariableValue> elements) {
    if (this.variableValues == elements) return this;
    List<VariableValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        newValue,
        this.valueSets,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getValueSets() valueSets}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withValueSets(ValueSet... elements) {
    List<ValueSet> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        newValue,
        this.metadata));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Questionnaire#getValueSets() valueSets}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of valueSets elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQuestionnaire withValueSets(Iterable<? extends ValueSet> elements) {
    if (this.valueSets == elements) return this;
    List<ValueSet> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        newValue,
        this.metadata));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Questionnaire#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuestionnaire withMetadata(Questionnaire.Metadata value) {
    if (this.metadata == value) return this;
    ImmutableQuestionnaireMetadata newValue = value == null ? null : ImmutableQuestionnaireMetadata.copyOf(value);
    return validate(new ImmutableQuestionnaire(
        this.id,
        this.rev,
        this.answers,
        this.context,
        this.activeItem,
        this.errors,
        this.variableValues,
        this.valueSets,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuestionnaire} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuestionnaire
        && equalTo(0, (ImmutableQuestionnaire) another);
  }

  private boolean equalTo(int synthetic, ImmutableQuestionnaire another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && answers.equals(another.answers)
        && context.equals(another.context)
        && Objects.equals(activeItem, another.activeItem)
        && errors.equals(another.errors)
        && variableValues.equals(another.variableValues)
        && valueSets.equals(another.valueSets)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code answers}, {@code context}, {@code activeItem}, {@code errors}, {@code variableValues}, {@code valueSets}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + answers.hashCode();
    h += (h << 5) + context.hashCode();
    h += (h << 5) + Objects.hashCode(activeItem);
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + variableValues.hashCode();
    h += (h << 5) + valueSets.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code Questionnaire} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Questionnaire{"
        + "id=" + id
        + ", rev=" + rev
        + ", answers=" + answers
        + ", context=" + context
        + ", activeItem=" + activeItem
        + ", errors=" + errors
        + ", variableValues=" + variableValues
        + ", valueSets=" + valueSets
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Questionnaire", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Questionnaire {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String rev;
    @javax.annotation.Nullable List<Answer> answers = Collections.emptyList();
    @javax.annotation.Nullable List<ContextValue> context = Collections.emptyList();
    @javax.annotation.Nullable String activeItem;
    @javax.annotation.Nullable List<Error> errors = Collections.emptyList();
    @javax.annotation.Nullable List<VariableValue> variableValues = Collections.emptyList();
    @javax.annotation.Nullable List<ValueSet> valueSets = Collections.emptyList();
    @javax.annotation.Nullable Questionnaire.Metadata metadata;
    @JsonProperty("_id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("_rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("answers")
    public void setAnswers(List<Answer> answers) {
      this.answers = answers;
    }
    @JsonProperty("context")
    public void setContext(List<ContextValue> context) {
      this.context = context;
    }
    @JsonProperty("activeItem")
    public void setActiveItem(@Nullable String activeItem) {
      this.activeItem = activeItem;
    }
    @JsonProperty("errors")
    public void setErrors(List<Error> errors) {
      this.errors = errors;
    }
    @JsonProperty("variableValues")
    public void setVariableValues(List<VariableValue> variableValues) {
      this.variableValues = variableValues;
    }
    @JsonProperty("valueSets")
    public void setValueSets(List<ValueSet> valueSets) {
      this.valueSets = valueSets;
    }
    @JsonProperty("metadata")
    public void setMetadata(Questionnaire.Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public List<Answer> getAnswers() { throw new UnsupportedOperationException(); }
    @Override
    public List<ContextValue> getContext() { throw new UnsupportedOperationException(); }
    @Override
    public String getActiveItem() { throw new UnsupportedOperationException(); }
    @Override
    public List<Error> getErrors() { throw new UnsupportedOperationException(); }
    @Override
    public List<VariableValue> getVariableValues() { throw new UnsupportedOperationException(); }
    @Override
    public List<ValueSet> getValueSets() { throw new UnsupportedOperationException(); }
    @Override
    public Questionnaire.Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQuestionnaire fromJson(Json json) {
    ImmutableQuestionnaire.Builder builder = ImmutableQuestionnaire.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.answers != null) {
      builder.addAllAnswers(json.answers);
    }
    if (json.context != null) {
      builder.addAllContext(json.context);
    }
    if (json.activeItem != null) {
      builder.activeItem(json.activeItem);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    if (json.variableValues != null) {
      builder.addAllVariableValues(json.variableValues);
    }
    if (json.valueSets != null) {
      builder.addAllValueSets(json.valueSets);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  private static ImmutableQuestionnaire validate(ImmutableQuestionnaire instance) {
    instance = (ImmutableQuestionnaire) instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Questionnaire} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Questionnaire instance
   */
  public static ImmutableQuestionnaire copyOf(Questionnaire instance) {
    if (instance instanceof ImmutableQuestionnaire) {
      return (ImmutableQuestionnaire) instance;
    }
    return ImmutableQuestionnaire.builder()
        .from(instance)
        .build();
  }

  private Object readResolve() throws ObjectStreamException {
    return validate(this);
  }

  /**
   * Creates a builder for {@link ImmutableQuestionnaire ImmutableQuestionnaire}.
   * <pre>
   * ImmutableQuestionnaire.builder()
   *    .id(String | null) // nullable {@link Questionnaire#getId() id}
   *    .rev(String | null) // nullable {@link Questionnaire#getRev() rev}
   *    .addAnswers|addAllAnswers(io.dialob.api.questionnaire.Answer) // {@link Questionnaire#getAnswers() answers} elements
   *    .addContext|addAllContext(io.dialob.api.questionnaire.ContextValue) // {@link Questionnaire#getContext() context} elements
   *    .activeItem(String | null) // nullable {@link Questionnaire#getActiveItem() activeItem}
   *    .addErrors|addAllErrors(io.dialob.api.questionnaire.Error) // {@link Questionnaire#getErrors() errors} elements
   *    .addVariableValues|addAllVariableValues(io.dialob.api.questionnaire.VariableValue) // {@link Questionnaire#getVariableValues() variableValues} elements
   *    .addValueSets|addAllValueSets(io.dialob.api.proto.ValueSet) // {@link Questionnaire#getValueSets() valueSets} elements
   *    .metadata(io.dialob.api.questionnaire.Questionnaire.Metadata | null) // nullable {@link Questionnaire#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new ImmutableQuestionnaire builder
   */
  public static ImmutableQuestionnaire.Builder builder() {
    return new ImmutableQuestionnaire.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQuestionnaire ImmutableQuestionnaire}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Questionnaire", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String rev;
    private List<Answer> answers = new ArrayList<Answer>();
    private List<ContextValue> context = new ArrayList<ContextValue>();
    private @javax.annotation.Nullable String activeItem;
    private List<Error> errors = new ArrayList<Error>();
    private List<VariableValue> variableValues = new ArrayList<VariableValue>();
    private List<ValueSet> valueSets = new ArrayList<ValueSet>();
    private @javax.annotation.Nullable Questionnaire.Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableQuestionnaire} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableQuestionnaire instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        rev(revValue);
      }
      addAllAnswers(instance.getAnswers());
      addAllContext(instance.getContext());
      String activeItemValue = instance.getActiveItem();
      if (activeItemValue != null) {
        activeItem(activeItemValue);
      }
      addAllErrors(instance.getErrors());
      addAllVariableValues(instance.getVariableValues());
      addAllValueSets(instance.getValueSets());
      Questionnaire.Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Questionnaire} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Questionnaire instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableQuestionnaire) {
        return from((ModifiableQuestionnaire) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String revValue = instance.getRev();
      if (revValue != null) {
        rev(revValue);
      }
      addAllAnswers(instance.getAnswers());
      addAllContext(instance.getContext());
      String activeItemValue = instance.getActiveItem();
      if (activeItemValue != null) {
        activeItem(activeItemValue);
      }
      addAllErrors(instance.getErrors());
      addAllVariableValues(instance.getVariableValues());
      addAllValueSets(instance.getValueSets());
      Questionnaire.Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("_rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Adds one element to {@link Questionnaire#getAnswers() answers} list.
     * @param element A answers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAnswers(@javax.annotation.Nullable Answer element) {
      if (element != null) element = ImmutableAnswer.copyOf(element);
      this.answers.add(element);
      return this;
    }

    /**
     * Constructs and adds an element for the {@link Questionnaire#getAnswers() answers} list.
     * @param id The value for {@code answers.id} (can be {@code null})
     * @param value The value for {@code answers.value} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAnswers(String id, @Nullable Object value) {
      return addAnswers(ImmutableAnswer.of(id, value));
    }

    /**
     * Adds elements to {@link Questionnaire#getAnswers() answers} list.
     * @param elements An array of answers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAnswers(Answer... elements) {
      for (Answer element : elements) {
        if (element != null) element = ImmutableAnswer.copyOf(element);
        this.answers.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Questionnaire#getAnswers() answers} list.
     * @param elements An iterable of answers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("answers")
    public final Builder answers(Iterable<? extends Answer> elements) {
      this.answers.clear();
      return addAllAnswers(elements);
    }

    /**
     * Adds elements to {@link Questionnaire#getAnswers() answers} list.
     * @param elements An iterable of answers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAnswers(Iterable<? extends Answer> elements) {
      for (Answer element : elements) {
        if (element != null) element = ImmutableAnswer.copyOf(element);
        this.answers.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link Questionnaire#getContext() context} list.
     * @param element A context element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addContext(@javax.annotation.Nullable ContextValue element) {
      if (element != null) element = ImmutableContextValue.copyOf(element);
      this.context.add(element);
      return this;
    }

    /**
     * Constructs and adds an element for the {@link Questionnaire#getContext() context} list.
     * @param id The value for {@code context.id} (can be {@code null})
     * @param value The value for {@code context.value} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addContext(String id, @Nullable Object value) {
      return addContext(ImmutableContextValue.of(id, value));
    }

    /**
     * Adds elements to {@link Questionnaire#getContext() context} list.
     * @param elements An array of context elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addContext(ContextValue... elements) {
      for (ContextValue element : elements) {
        if (element != null) element = ImmutableContextValue.copyOf(element);
        this.context.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Questionnaire#getContext() context} list.
     * @param elements An iterable of context elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("context")
    public final Builder context(Iterable<? extends ContextValue> elements) {
      this.context.clear();
      return addAllContext(elements);
    }

    /**
     * Adds elements to {@link Questionnaire#getContext() context} list.
     * @param elements An iterable of context elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllContext(Iterable<? extends ContextValue> elements) {
      for (ContextValue element : elements) {
        if (element != null) element = ImmutableContextValue.copyOf(element);
        this.context.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire#getActiveItem() activeItem} attribute.
     * @param activeItem The value for activeItem (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeItem")
    public final Builder activeItem(@Nullable String activeItem) {
      this.activeItem = activeItem;
      return this;
    }

    /**
     * Adds one element to {@link Questionnaire#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(@javax.annotation.Nullable Error element) {
      if (element != null) element = ImmutableError.copyOf(element);
      this.errors.add(element);
      return this;
    }

    /**
     * Constructs and adds an element for the {@link Questionnaire#getErrors() errors} list.
     * @param id The value for {@code errors.id} 
     * @param code The value for {@code errors.code} (can be {@code null})
     * @param description The value for {@code errors.description} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(String id, @Nullable String code, @Nullable String description) {
      return addErrors(ImmutableError.of(id, code, description));
    }

    /**
     * Adds elements to {@link Questionnaire#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Error... elements) {
      for (Error element : elements) {
        if (element != null) element = ImmutableError.copyOf(element);
        this.errors.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Questionnaire#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(Iterable<? extends Error> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Questionnaire#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      for (Error element : elements) {
        if (element != null) element = ImmutableError.copyOf(element);
        this.errors.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link Questionnaire#getVariableValues() variableValues} list.
     * @param element A variableValues element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariableValues(@javax.annotation.Nullable VariableValue element) {
      if (element != null) element = ImmutableVariableValue.copyOf(element);
      this.variableValues.add(element);
      return this;
    }

    /**
     * Constructs and adds an element for the {@link Questionnaire#getVariableValues() variableValues} list.
     * @param id The value for {@code variableValues.id} 
     * @param value The value for {@code variableValues.value} (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariableValues(String id, @Nullable Object value) {
      return addVariableValues(ImmutableVariableValue.of(id, value));
    }

    /**
     * Adds elements to {@link Questionnaire#getVariableValues() variableValues} list.
     * @param elements An array of variableValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariableValues(VariableValue... elements) {
      for (VariableValue element : elements) {
        if (element != null) element = ImmutableVariableValue.copyOf(element);
        this.variableValues.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Questionnaire#getVariableValues() variableValues} list.
     * @param elements An iterable of variableValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("variableValues")
    public final Builder variableValues(Iterable<? extends VariableValue> elements) {
      this.variableValues.clear();
      return addAllVariableValues(elements);
    }

    /**
     * Adds elements to {@link Questionnaire#getVariableValues() variableValues} list.
     * @param elements An iterable of variableValues elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariableValues(Iterable<? extends VariableValue> elements) {
      for (VariableValue element : elements) {
        if (element != null) element = ImmutableVariableValue.copyOf(element);
        this.variableValues.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link Questionnaire#getValueSets() valueSets} list.
     * @param element A valueSets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValueSets(@javax.annotation.Nullable ValueSet element) {
      if (element != null) element = ImmutableValueSet.copyOf(element);
      this.valueSets.add(element);
      return this;
    }

    /**
     * Adds elements to {@link Questionnaire#getValueSets() valueSets} list.
     * @param elements An array of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValueSets(ValueSet... elements) {
      for (ValueSet element : elements) {
        if (element != null) element = ImmutableValueSet.copyOf(element);
        this.valueSets.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Questionnaire#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueSets")
    public final Builder valueSets(Iterable<? extends ValueSet> elements) {
      this.valueSets.clear();
      return addAllValueSets(elements);
    }

    /**
     * Adds elements to {@link Questionnaire#getValueSets() valueSets} list.
     * @param elements An iterable of valueSets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValueSets(Iterable<? extends ValueSet> elements) {
      for (ValueSet element : elements) {
        if (element != null) element = ImmutableValueSet.copyOf(element);
        this.valueSets.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Questionnaire#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(Questionnaire.Metadata metadata) {
      this.metadata = metadata == null ? null : ImmutableQuestionnaireMetadata.copyOf(metadata);
      return this;
    }

    /**
     * Builds a new {@link ImmutableQuestionnaire ImmutableQuestionnaire}.
     * @return An immutable instance of Questionnaire
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuestionnaire build() {
      return ImmutableQuestionnaire.validate(new ImmutableQuestionnaire(
          id,
          rev,
          createUnmodifiableList(true, answers),
          createUnmodifiableList(true, context),
          activeItem,
          createUnmodifiableList(true, errors),
          createUnmodifiableList(true, variableValues),
          createUnmodifiableList(true, valueSets),
          metadata == null ? null : ImmutableQuestionnaireMetadata.copyOf(metadata)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
