package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Answer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnswer.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableAnswer.of()}.
 */
@Generated(from = "Answer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAnswer implements Answer {
  private final String id;
  private final @Nullable Object value;
  private final @Nullable String type;
  private final @Nullable Object acceptedValue;
  private final @Nullable Date updated;
  private final @Nullable String userId;

  private ImmutableAnswer(String id, @Nullable Object value) {
    this.id = id;
    this.value = value;
    this.type = null;
    this.acceptedValue = null;
    this.updated = null;
    this.userId = null;
  }

  private ImmutableAnswer(
      String id,
      @Nullable Object value,
      @Nullable String type,
      @Nullable Object acceptedValue,
      @Nullable Date updated,
      @Nullable String userId) {
    this.id = id;
    this.value = value;
    this.type = type;
    this.acceptedValue = acceptedValue;
    this.updated = updated;
    this.userId = userId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Text and number field answers stored in orignal format
   * @return user's answer in original format
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * @return The value of the {@code acceptedValue} attribute
   */
  @JsonProperty("acceptedValue")
  @Override
  public @Nullable Object getAcceptedValue() {
    return acceptedValue;
  }

  /**
   * @return The value of the {@code updated} attribute
   */
  @JsonProperty("updated")
  @Override
  public @Nullable Date getUpdated() {
    return updated;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("userId")
  @Override
  public @Nullable String getUserId() {
    return userId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAnswer(value, this.value, this.type, this.acceptedValue, this.updated, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableAnswer(this.id, value, this.type, this.acceptedValue, this.updated, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableAnswer(this.id, this.value, value, this.acceptedValue, this.updated, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getAcceptedValue() acceptedValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for acceptedValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withAcceptedValue(@Nullable Object value) {
    if (this.acceptedValue == value) return this;
    return new ImmutableAnswer(this.id, this.value, this.type, value, this.updated, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getUpdated() updated} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updated (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withUpdated(@Nullable Date value) {
    if (this.updated == value) return this;
    return new ImmutableAnswer(this.id, this.value, this.type, this.acceptedValue, value, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Answer#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnswer withUserId(@Nullable String value) {
    if (Objects.equals(this.userId, value)) return this;
    return new ImmutableAnswer(this.id, this.value, this.type, this.acceptedValue, this.updated, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnswer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnswer
        && equalTo(0, (ImmutableAnswer) another);
  }

  private boolean equalTo(int synthetic, ImmutableAnswer another) {
    return Objects.equals(id, another.id)
        && Objects.equals(value, another.value)
        && Objects.equals(type, another.type)
        && Objects.equals(acceptedValue, another.acceptedValue)
        && Objects.equals(updated, another.updated)
        && Objects.equals(userId, another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}, {@code type}, {@code acceptedValue}, {@code updated}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(acceptedValue);
    h += (h << 5) + Objects.hashCode(updated);
    h += (h << 5) + Objects.hashCode(userId);
    return h;
  }

  /**
   * Prints the immutable value {@code Answer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Answer{"
        + "id=" + id
        + ", value=" + value
        + ", type=" + type
        + ", acceptedValue=" + acceptedValue
        + ", updated=" + updated
        + ", userId=" + userId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Answer", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Answer {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable Object value;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable Object acceptedValue;
    @javax.annotation.Nullable Date updated;
    @javax.annotation.Nullable String userId;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public void setValue(@Nullable Object value) {
      this.value = value;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @JsonProperty("acceptedValue")
    public void setAcceptedValue(@Nullable Object acceptedValue) {
      this.acceptedValue = acceptedValue;
    }
    @JsonProperty("updated")
    public void setUpdated(@Nullable Date updated) {
      this.updated = updated;
    }
    @JsonProperty("userId")
    public void setUserId(@Nullable String userId) {
      this.userId = userId;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Object getValue() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Object getAcceptedValue() { throw new UnsupportedOperationException(); }
    @Override
    public Date getUpdated() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnswer fromJson(Json json) {
    ImmutableAnswer.Builder builder = ImmutableAnswer.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.acceptedValue != null) {
      builder.acceptedValue(json.acceptedValue);
    }
    if (json.updated != null) {
      builder.updated(json.updated);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Answer} instance.
   * @param id The value for the {@code id} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable Answer instance
   */
  public static ImmutableAnswer of(String id, @Nullable Object value) {
    return new ImmutableAnswer(id, value);
  }

  /**
   * Creates an immutable copy of a {@link Answer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Answer instance
   */
  public static ImmutableAnswer copyOf(Answer instance) {
    if (instance instanceof ImmutableAnswer) {
      return (ImmutableAnswer) instance;
    }
    return ImmutableAnswer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnswer ImmutableAnswer}.
   * <pre>
   * ImmutableAnswer.builder()
   *    .id(String | null) // nullable {@link Answer#getId() id}
   *    .value(Object | null) // nullable {@link Answer#getValue() value}
   *    .type(String | null) // nullable {@link Answer#getType() type}
   *    .acceptedValue(Object | null) // nullable {@link Answer#getAcceptedValue() acceptedValue}
   *    .updated(Date | null) // nullable {@link Answer#getUpdated() updated}
   *    .userId(String | null) // nullable {@link Answer#getUserId() userId}
   *    .build();
   * </pre>
   * @return A new ImmutableAnswer builder
   */
  public static ImmutableAnswer.Builder builder() {
    return new ImmutableAnswer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnswer ImmutableAnswer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Answer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable Object value;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable Object acceptedValue;
    private @javax.annotation.Nullable Date updated;
    private @javax.annotation.Nullable String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableAnswer} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableAnswer instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      Object acceptedValueValue = instance.getAcceptedValue();
      if (acceptedValueValue != null) {
        acceptedValue(acceptedValueValue);
      }
      Date updatedValue = instance.getUpdated();
      if (updatedValue != null) {
        updated(updatedValue);
      }
      String userIdValue = instance.getUserId();
      if (userIdValue != null) {
        userId(userIdValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Answer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Answer instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableAnswer) {
        return from((ModifiableAnswer) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      Object acceptedValueValue = instance.getAcceptedValue();
      if (acceptedValueValue != null) {
        acceptedValue(acceptedValueValue);
      }
      Date updatedValue = instance.getUpdated();
      if (updatedValue != null) {
        updated(updatedValue);
      }
      String userIdValue = instance.getUserId();
      if (userIdValue != null) {
        userId(userIdValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getAcceptedValue() acceptedValue} attribute.
     * @param acceptedValue The value for acceptedValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("acceptedValue")
    public final Builder acceptedValue(@Nullable Object acceptedValue) {
      this.acceptedValue = acceptedValue;
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getUpdated() updated} attribute.
     * @param updated The value for updated (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated")
    public final Builder updated(@Nullable Date updated) {
      this.updated = updated;
      return this;
    }

    /**
     * Initializes the value for the {@link Answer#getUserId() userId} attribute.
     * @param userId The value for userId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userId(@Nullable String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnswer ImmutableAnswer}.
     * @return An immutable instance of Answer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnswer build() {
      return new ImmutableAnswer(id, value, type, acceptedValue, updated, userId);
    }
  }
}
