package io.dialob.api.questionnaire;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code VariableValue}.
 * @see ImmutableVariableValue
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.questionnaire", generator = "Gsons")
public final class GsonAdaptersVariableValue implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (VariableValueTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new VariableValueTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersVariableValue(VariableValue)";
  }

  @org.immutables.value.Generated(from = "VariableValue", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class VariableValueTypeAdapter extends TypeAdapter<VariableValue> {
    public final Object valueTypeSample = null;
    private final TypeAdapter<Object> valueTypeAdapter;

    VariableValueTypeAdapter(Gson gson) {
      this.valueTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return VariableValue.class == type.getRawType()
          || ImmutableVariableValue.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, VariableValue value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeVariableValue(out, value);
      }
    }

    @Override
    public VariableValue read(JsonReader in) throws IOException {
      return readVariableValue(in);
    }

    private void writeVariableValue(JsonWriter out, VariableValue instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        out.name("value");
        valueTypeAdapter.write(out, valueValue);
      } else if (out.getSerializeNulls()) {
        out.name("value");
        out.nullValue();
      }
      out.endObject();
    }

    private  VariableValue readVariableValue(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableVariableValue.Builder builder = ImmutableVariableValue.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableVariableValue.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'v':
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableVariableValue.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInValue(JsonReader in, ImmutableVariableValue.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = valueTypeAdapter.read(in);
        builder.value(value);
      }
    }
  }
}
