package io.dialob.api.questionnaire;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Answer}.
 * @see ImmutableAnswer
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.questionnaire", generator = "Gsons")
public final class GsonAdaptersAnswer implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (AnswerTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new AnswerTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersAnswer(Answer)";
  }

  @org.immutables.value.Generated(from = "Answer", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class AnswerTypeAdapter extends TypeAdapter<Answer> {
    public final Object valueTypeSample = null;
    public final Object acceptedValueTypeSample = null;
    public final Date updatedTypeSample = null;
    private final TypeAdapter<Object> valueTypeAdapter;
    private final TypeAdapter<Object> acceptedValueTypeAdapter;
    private final TypeAdapter<Date> updatedTypeAdapter;

    AnswerTypeAdapter(Gson gson) {
      this.valueTypeAdapter = gson.getAdapter( Object.class);
      this.acceptedValueTypeAdapter = gson.getAdapter( Object.class);
      this.updatedTypeAdapter = gson.getAdapter( Date.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Answer.class == type.getRawType()
          || ImmutableAnswer.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Answer value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeAnswer(out, value);
      }
    }

    @Override
    public Answer read(JsonReader in) throws IOException {
      return readAnswer(in);
    }

    private void writeAnswer(JsonWriter out, Answer instance)
        throws IOException {
      out.beginObject();
      String idValue = instance.getId();
      if (idValue != null) {
        out.name("id");
        out.value(idValue);
      } else if (out.getSerializeNulls()) {
        out.name("id");
        out.nullValue();
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        out.name("value");
        valueTypeAdapter.write(out, valueValue);
      } else if (out.getSerializeNulls()) {
        out.name("value");
        out.nullValue();
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        out.name("type");
        out.value(typeValue);
      } else if (out.getSerializeNulls()) {
        out.name("type");
        out.nullValue();
      }
      Object acceptedValueValue = instance.getAcceptedValue();
      if (acceptedValueValue != null) {
        out.name("acceptedValue");
        acceptedValueTypeAdapter.write(out, acceptedValueValue);
      } else if (out.getSerializeNulls()) {
        out.name("acceptedValue");
        out.nullValue();
      }
      Date updatedValue = instance.getUpdated();
      if (updatedValue != null) {
        out.name("updated");
        updatedTypeAdapter.write(out, updatedValue);
      } else if (out.getSerializeNulls()) {
        out.name("updated");
        out.nullValue();
      }
      String userIdValue = instance.getUserId();
      if (userIdValue != null) {
        out.name("userId");
        out.value(userIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("userId");
        out.nullValue();
      }
      out.endObject();
    }

    private  Answer readAnswer(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableAnswer.Builder builder = ImmutableAnswer.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'v':
        if ("value".equals(attributeName)) {
          readInValue(in, builder);
          return;
        }
        break;
      case 't':
        if ("type".equals(attributeName)) {
          readInType(in, builder);
          return;
        }
        break;
      case 'a':
        if ("acceptedValue".equals(attributeName)) {
          readInAcceptedValue(in, builder);
          return;
        }
        break;
      case 'u':
        if ("updated".equals(attributeName)) {
          readInUpdated(in, builder);
          return;
        }
        if ("userId".equals(attributeName)) {
          readInUserId(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.id(in.nextString());
      }
    }

    private void readInValue(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = valueTypeAdapter.read(in);
        builder.value(value);
      }
    }

    private void readInType(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.type(in.nextString());
      }
    }

    private void readInAcceptedValue(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = acceptedValueTypeAdapter.read(in);
        builder.acceptedValue(value);
      }
    }

    private void readInUpdated(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = updatedTypeAdapter.read(in);
        builder.updated(value);
      }
    }

    private void readInUserId(JsonReader in, ImmutableAnswer.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.userId(in.nextString());
      }
    }
  }
}
