package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Actions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableActions.builder()}.
 */
@Generated(from = "Actions", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableActions implements Actions {
  private final @Nullable String rev;
  private final @Nullable List<Action> actions;

  private ImmutableActions(
      @Nullable String rev,
      @Nullable List<Action> actions) {
    this.rev = rev;
    this.actions = actions;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code actions} attribute
   */
  @JsonProperty("actions")
  @Override
  public @Nullable List<Action> getActions() {
    return actions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Actions#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableActions withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableActions(value, this.actions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Actions#getActions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActions withActions(@Nullable Action... elements) {
    if (elements == null) {
      return new ImmutableActions(this.rev, null);
    }
    List<Action> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableActions(this.rev, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Actions#getActions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableActions withActions(@Nullable Iterable<? extends Action> elements) {
    if (this.actions == elements) return this;
    List<Action> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableActions(this.rev, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableActions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableActions
        && equalTo(0, (ImmutableActions) another);
  }

  private boolean equalTo(int synthetic, ImmutableActions another) {
    return Objects.equals(rev, another.rev)
        && Objects.equals(actions, another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code rev}, {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(actions);
    return h;
  }

  /**
   * Prints the immutable value {@code Actions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Actions{"
        + "rev=" + rev
        + ", actions=" + actions
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Actions", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Actions {
    @javax.annotation.Nullable String rev;
    @javax.annotation.Nullable List<Action> actions = null;
    @JsonProperty("rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("actions")
    public void setActions(@Nullable List<Action> actions) {
      this.actions = actions;
    }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public List<Action> getActions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableActions fromJson(Json json) {
    ImmutableActions.Builder builder = ImmutableActions.builder();
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.actions != null) {
      builder.addAllActions(json.actions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Actions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Actions instance
   */
  public static ImmutableActions copyOf(Actions instance) {
    if (instance instanceof ImmutableActions) {
      return (ImmutableActions) instance;
    }
    return ImmutableActions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableActions ImmutableActions}.
   * <pre>
   * ImmutableActions.builder()
   *    .rev(String | null) // nullable {@link Actions#getRev() rev}
   *    .actions(List&amp;lt;io.dialob.api.proto.Action&amp;gt; | null) // nullable {@link Actions#getActions() actions}
   *    .build();
   * </pre>
   * @return A new ImmutableActions builder
   */
  public static ImmutableActions.Builder builder() {
    return new ImmutableActions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableActions ImmutableActions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Actions", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String rev;
    private List<Action> actions = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Actions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Actions instance) {
      Objects.requireNonNull(instance, "instance");
      String revValue = instance.getRev();
      if (revValue != null) {
        rev(revValue);
      }
      List<Action> actionsValue = instance.getActions();
      if (actionsValue != null) {
        addAllActions(actionsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Actions#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Adds one element to {@link Actions#getActions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActions(Action element) {
      if (this.actions == null) {
        this.actions = new ArrayList<Action>();
      }
      this.actions.add(Objects.requireNonNull(element, "actions element"));
      return this;
    }

    /**
     * Adds elements to {@link Actions#getActions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addActions(Action... elements) {
      if (this.actions == null) {
        this.actions = new ArrayList<Action>();
      }
      for (Action element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Actions#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actions")
    public final Builder actions(@Nullable Iterable<? extends Action> elements) {
      if (elements == null) {
        this.actions = null;
        return this;
      }
      this.actions = new ArrayList<Action>();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link Actions#getActions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllActions(Iterable<? extends Action> elements) {
      Objects.requireNonNull(elements, "actions element");
      if (this.actions == null) {
        this.actions = new ArrayList<Action>();
      }
      for (Action element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableActions ImmutableActions}.
     * @return An immutable instance of Actions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableActions build() {
      return new ImmutableActions(rev, actions == null ? null : createUnmodifiableList(true, actions));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
