package io.dialob.api.proto;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code ValueSet}.
 * @see ImmutableValueSet
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.proto", generator = "Gsons")
public final class GsonAdaptersValueSet implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ValueSetTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ValueSetTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersValueSet(ValueSet)";
  }

  @org.immutables.value.Generated(from = "ValueSet", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ValueSetTypeAdapter extends TypeAdapter<ValueSet> {
    public final ValueSetEntry entriesTypeSample = null;
    private final TypeAdapter<ValueSetEntry> entriesTypeAdapter;

    ValueSetTypeAdapter(Gson gson) {
      this.entriesTypeAdapter = gson.getAdapter( ValueSetEntry.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return ValueSet.class == type.getRawType()
          || ImmutableValueSet.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, ValueSet value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeValueSet(out, value);
      }
    }

    @Override
    public ValueSet read(JsonReader in) throws IOException {
      return readValueSet(in);
    }

    private void writeValueSet(JsonWriter out, ValueSet instance)
        throws IOException {
      out.beginObject();
      out.name("id");
      out.value(instance.getId());
      List<ValueSetEntry> entriesElements = instance.getEntries();
      if (!entriesElements.isEmpty()) {
        out.name("entries");
        out.beginArray();
        for (ValueSetEntry e : entriesElements) {
          entriesTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("entries");
        out.beginArray();
        out.endArray();
      }
      out.endObject();
    }

    private  ValueSet readValueSet(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableValueSet.Builder builder = ImmutableValueSet.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableValueSet.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'i':
        if ("id".equals(attributeName)) {
          readInId(in, builder);
          return;
        }
        break;
      case 'e':
        if ("entries".equals(attributeName)) {
          readInEntries(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInId(JsonReader in, ImmutableValueSet.Builder builder)
        throws IOException {
      builder.id(in.nextString());
    }

    private void readInEntries(JsonReader in, ImmutableValueSet.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          ValueSetEntry value = entriesTypeAdapter.read(in);
          builder.addEntries(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        ValueSetEntry value = entriesTypeAdapter.read(in);
        builder.addEntries(value);
      }
    }
  }
}
