package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link FormValueSetEntry FormValueSetEntry} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFormValueSetEntry is not thread-safe</em>
 * @see ImmutableFormValueSetEntry
 */
@Generated(from = "FormValueSetEntry", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "FormValueSetEntry"})
@NotThreadSafe
public final class ModifiableFormValueSetEntry implements FormValueSetEntry {

  private static final long INIT_BIT_ID = 0x1L;
  private long initBits = 0x1L;

  private String id;
  private final Map<String, String> label = new LinkedHashMap<String, String>();
  private @Nullable String when;
  private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

  private ModifiableFormValueSetEntry() {}

  /**
   * Construct a modifiable instance of {@code FormValueSetEntry}.
   * @return A new modifiable instance
   */
  public static ModifiableFormValueSetEntry create() {
    return new ModifiableFormValueSetEntry();
  }

  /**
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    if (!idIsSet()) {
      checkRequiredAttributes();
    }
    return id;
  }

  /**
   * @return value of {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public final Map<String, String> getLabel() {
    return label;
  }

  /**
   * @return value of {@code when} attribute, may be {@code null}
   */
  @JsonProperty("when")
  @Override
  public final @Nullable String getWhen() {
    return when;
  }

  /**
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @Override
  public final Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry clear() {
    initBits = 0x1L;
    id = null;
    label.clear();
    when = null;
    additionalProperties.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormValueSetEntry} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry from(FormValueSetEntry instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFormValueSetEntry) {
      from((ModifiableFormValueSetEntry) instance);
      return this;
    }
    setId(instance.getId());
    putAllLabel(instance.getLabel());
    String whenValue = instance.getWhen();
    if (whenValue != null) {
      setWhen(whenValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormValueSetEntry} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry from(ModifiableFormValueSetEntry instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.idIsSet()) {
      setId(instance.getId());
    }
    putAllLabel(instance.getLabel());
    String whenValue = instance.getWhen();
    if (whenValue != null) {
      setWhen(whenValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Assigns a value to the {@link FormValueSetEntry#getId() id} attribute.
   * @param id The value for id
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry setId(String id) {
    this.id = Objects.requireNonNull(id, "id");
    initBits &= ~INIT_BIT_ID;
    return this;
  }

  /**
   * Put one entry to the {@link FormValueSetEntry#getLabel() label} map.
   * @param key The key in label map
   * @param value The associated value in the label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry putLabel(String key, String value) {
    this.label.put(
        Objects.requireNonNull(key, "label key"),
        Objects.requireNonNull(value, "label value"));
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSetEntry#getLabel() label} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry setLabel(Map<String, ? extends String> entries) {
    this.label.clear();
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.label.put(
          Objects.requireNonNull(k, "label key"),
          Objects.requireNonNull(v, "label value"));
    }
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormValueSetEntry#getLabel() label} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry putAllLabel(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.label.put(
          Objects.requireNonNull(k, "label key"),
          Objects.requireNonNull(v, "label value"));
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FormValueSetEntry#getWhen() when} attribute.
   * @param when The value for when, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry setWhen(@Nullable String when) {
    this.when = when;
    return this;
  }

  /**
   * Put one entry to the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map.
   * @param key The key in additionalProperties map
   * @param value The associated value in the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry putAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(
        Objects.requireNonNull(key, "additionalProperties key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry setAdditionalProperties(Map<String, ? extends Object> entries) {
    this.additionalProperties.clear();
    this.putAllAdditionalProperties(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormValueSetEntry#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormValueSetEntry putAllAdditionalProperties(Map<String, ? extends Object> entries) {
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.additionalProperties.put(
          Objects.requireNonNull(k, "additionalProperties key"),
          v);
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link FormValueSetEntry#getId() id} is set.
   * @return {@code true} if set
   */
  public final boolean idIsSet() {
    return (initBits & INIT_BIT_ID) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormValueSetEntry unsetId() {
    initBits |= INIT_BIT_ID;
    id = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!idIsSet()) attributes.add("id");
    return "FormValueSetEntry is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableFormValueSetEntry ImmutableFormValueSetEntry}.
   * @return An immutable instance of FormValueSetEntry
   */
  public final ImmutableFormValueSetEntry toImmutable() {
    checkRequiredAttributes();
    return ImmutableFormValueSetEntry.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFormValueSetEntry} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFormValueSetEntry)) return false;
    ModifiableFormValueSetEntry other = (ModifiableFormValueSetEntry) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFormValueSetEntry another) {
    return id.equals(another.id)
        && label.equals(another.label)
        && Objects.equals(when, another.when)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code label}, {@code when}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + label.hashCode();
    h += (h << 5) + Objects.hashCode(when);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code FormValueSetEntry}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableFormValueSetEntry{"
        + "id="  + (idIsSet() ? getId() : "?")
        + ", label=" + getLabel()
        + ", when=" + getWhen()
        + ", additionalProperties=" + getAdditionalProperties()
        + "}";
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
