package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Form.Metadata Metadata} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFormMetadata is not thread-safe</em>
 * @see ImmutableFormMetadata
 */
@Generated(from = "Form.Metadata", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Form.Metadata"})
@NotThreadSafe
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ModifiableFormMetadata implements Form.Metadata {

  private String label;
  private @Nullable Date created;
  private @Nullable Date lastSaved;
  private @Nullable Boolean valid;
  private @Nullable String creator;
  private @Nullable String tenantId;
  private @Nullable String savedBy;
  private final LinkedHashSet<String> labels = new LinkedHashSet<String>();
  private @Nullable String defaultSubmitUrl;
  private final LinkedHashSet<String> languages = new LinkedHashSet<String>();
  private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

  private ModifiableFormMetadata() {}

  /**
   * Construct a modifiable instance of {@code Metadata}.
   * @return A new modifiable instance
   */
  public static ModifiableFormMetadata create() {
    return new ModifiableFormMetadata();
  }

  /**
   * @return value of {@code label} attribute, may be {@code null}
   */
  @JsonProperty("label")
  @Override
  public final String getLabel() {
    return label;
  }

  /**
   * @return value of {@code created} attribute, may be {@code null}
   */
  @JsonProperty("created")
  @Override
  public final @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return value of {@code lastSaved} attribute, may be {@code null}
   */
  @JsonProperty("lastSaved")
  @Override
  public final @Nullable Date getLastSaved() {
    return lastSaved;
  }

  /**
   * @return value of {@code valid} attribute, may be {@code null}
   */
  @JsonProperty("valid")
  @Override
  public final @Nullable Boolean getValid() {
    return valid;
  }

  /**
   * @return value of {@code creator} attribute, may be {@code null}
   */
  @JsonProperty("creator")
  @Override
  public final @Nullable String getCreator() {
    return creator;
  }

  /**
   * @return value of {@code tenantId} attribute, may be {@code null}
   */
  @JsonProperty("tenantId")
  @Override
  public final @Nullable String getTenantId() {
    return tenantId;
  }

  /**
   * @return value of {@code savedBy} attribute, may be {@code null}
   */
  @JsonProperty("savedBy")
  @Override
  public final @Nullable String getSavedBy() {
    return savedBy;
  }

  /**
   * @return modifiable set {@code labels}
   */
  @JsonProperty("labels")
  @Override
  public final Set<String> getLabels() {
    return labels;
  }

  /**
   * @return value of {@code defaultSubmitUrl} attribute, may be {@code null}
   */
  @JsonProperty("defaultSubmitUrl")
  @Override
  public final @Nullable String getDefaultSubmitUrl() {
    return defaultSubmitUrl;
  }

  /**
   * @return modifiable set {@code languages}
   */
  @JsonProperty("languages")
  @Override
  public final Set<String> getLanguages() {
    return languages;
  }

  /**
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @Override
  public final Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata clear() {
    label = null;
    created = null;
    lastSaved = null;
    valid = null;
    creator = null;
    tenantId = null;
    savedBy = null;
    labels.clear();
    defaultSubmitUrl = null;
    languages.clear();
    additionalProperties.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Form.Metadata} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata from(Form.Metadata instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFormMetadata) {
      from((ModifiableFormMetadata) instance);
      return this;
    }
    String labelValue = instance.getLabel();
    if (labelValue != null) {
      setLabel(labelValue);
    }
    Date createdValue = instance.getCreated();
    if (createdValue != null) {
      setCreated(createdValue);
    }
    Date lastSavedValue = instance.getLastSaved();
    if (lastSavedValue != null) {
      setLastSaved(lastSavedValue);
    }
    Boolean validValue = instance.getValid();
    if (validValue != null) {
      setValid(validValue);
    }
    String creatorValue = instance.getCreator();
    if (creatorValue != null) {
      setCreator(creatorValue);
    }
    String tenantIdValue = instance.getTenantId();
    if (tenantIdValue != null) {
      setTenantId(tenantIdValue);
    }
    String savedByValue = instance.getSavedBy();
    if (savedByValue != null) {
      setSavedBy(savedByValue);
    }
    addAllLabels(instance.getLabels());
    String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
    if (defaultSubmitUrlValue != null) {
      setDefaultSubmitUrl(defaultSubmitUrlValue);
    }
    addAllLanguages(instance.getLanguages());
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Form.Metadata} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata from(ModifiableFormMetadata instance) {
    Objects.requireNonNull(instance, "instance");
    String labelValue = instance.getLabel();
    if (labelValue != null) {
      setLabel(labelValue);
    }
    Date createdValue = instance.getCreated();
    if (createdValue != null) {
      setCreated(createdValue);
    }
    Date lastSavedValue = instance.getLastSaved();
    if (lastSavedValue != null) {
      setLastSaved(lastSavedValue);
    }
    Boolean validValue = instance.getValid();
    if (validValue != null) {
      setValid(validValue);
    }
    String creatorValue = instance.getCreator();
    if (creatorValue != null) {
      setCreator(creatorValue);
    }
    String tenantIdValue = instance.getTenantId();
    if (tenantIdValue != null) {
      setTenantId(tenantIdValue);
    }
    String savedByValue = instance.getSavedBy();
    if (savedByValue != null) {
      setSavedBy(savedByValue);
    }
    addAllLabels(instance.getLabels());
    String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
    if (defaultSubmitUrlValue != null) {
      setDefaultSubmitUrl(defaultSubmitUrlValue);
    }
    addAllLanguages(instance.getLanguages());
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getLabel() label} attribute.
   * @param label The value for label, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setLabel(String label) {
    this.label = label;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getCreated() created} attribute.
   * @param created The value for created, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setCreated(@Nullable Date created) {
    this.created = created;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getLastSaved() lastSaved} attribute.
   * @param lastSaved The value for lastSaved, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setLastSaved(@Nullable Date lastSaved) {
    this.lastSaved = lastSaved;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getValid() valid} attribute.
   * @param valid The value for valid, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setValid(@Nullable Boolean valid) {
    this.valid = valid;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getCreator() creator} attribute.
   * @param creator The value for creator, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setCreator(@Nullable String creator) {
    this.creator = creator;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getTenantId() tenantId} attribute.
   * @param tenantId The value for tenantId, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setTenantId(@Nullable String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getSavedBy() savedBy} attribute.
   * @param savedBy The value for savedBy, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setSavedBy(@Nullable String savedBy) {
    this.savedBy = savedBy;
    return this;
  }

  /**
   * Adds one element to {@link Form.Metadata#getLabels() labels} set.
   * @param element The labels element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata addLabels(String element) {
    this.labels.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Form.Metadata#getLabels() labels} set.
   * @param elements An array of labels elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormMetadata addLabels(String... elements) {
    for (String e : elements) {
      addLabels(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Form.Metadata#getLabels() labels} set.
   * @param elements An iterable of labels elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setLabels(Iterable<String> elements) {
    this.labels.clear();
    addAllLabels(elements);
    return this;
  }

  /**
   * Adds elements to {@link Form.Metadata#getLabels() labels} set.
   * @param elements An iterable of labels elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata addAllLabels(Iterable<String> elements) {
    for (String e : elements) {
      addLabels(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Form.Metadata#getDefaultSubmitUrl() defaultSubmitUrl} attribute.
   * @param defaultSubmitUrl The value for defaultSubmitUrl, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setDefaultSubmitUrl(@Nullable String defaultSubmitUrl) {
    this.defaultSubmitUrl = defaultSubmitUrl;
    return this;
  }

  /**
   * Adds one element to {@link Form.Metadata#getLanguages() languages} set.
   * @param element The languages element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata addLanguages(String element) {
    this.languages.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Form.Metadata#getLanguages() languages} set.
   * @param elements An array of languages elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormMetadata addLanguages(String... elements) {
    for (String e : elements) {
      addLanguages(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Form.Metadata#getLanguages() languages} set.
   * @param elements An iterable of languages elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setLanguages(Iterable<String> elements) {
    this.languages.clear();
    addAllLanguages(elements);
    return this;
  }

  /**
   * Adds elements to {@link Form.Metadata#getLanguages() languages} set.
   * @param elements An iterable of languages elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata addAllLanguages(Iterable<String> elements) {
    for (String e : elements) {
      addLanguages(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map.
   * @param key The key in additionalProperties map
   * @param value The associated value in the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata putAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(
        Objects.requireNonNull(key, "additionalProperties key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata setAdditionalProperties(Map<String, ? extends Object> entries) {
    this.additionalProperties.clear();
    this.putAllAdditionalProperties(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Form.Metadata#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormMetadata putAllAdditionalProperties(Map<String, ? extends Object> entries) {
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.additionalProperties.put(
          Objects.requireNonNull(k, "additionalProperties key"),
          v);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableFormMetadata ImmutableFormMetadata}.
   * @return An immutable instance of Metadata
   */
  public final ImmutableFormMetadata toImmutable() {
    return ImmutableFormMetadata.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFormMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFormMetadata)) return false;
    ModifiableFormMetadata other = (ModifiableFormMetadata) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFormMetadata another) {
    return Objects.equals(label, another.label)
        && Objects.equals(created, another.created)
        && Objects.equals(lastSaved, another.lastSaved)
        && Objects.equals(valid, another.valid)
        && Objects.equals(creator, another.creator)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(savedBy, another.savedBy)
        && labels.equals(another.labels)
        && Objects.equals(defaultSubmitUrl, another.defaultSubmitUrl)
        && languages.equals(another.languages)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code created}, {@code lastSaved}, {@code valid}, {@code creator}, {@code tenantId}, {@code savedBy}, {@code labels}, {@code defaultSubmitUrl}, {@code languages}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastSaved);
    h += (h << 5) + Objects.hashCode(valid);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(savedBy);
    h += (h << 5) + labels.hashCode();
    h += (h << 5) + Objects.hashCode(defaultSubmitUrl);
    h += (h << 5) + languages.hashCode();
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Metadata}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableFormMetadata{"
        + "label=" + getLabel()
        + ", created=" + getCreated()
        + ", lastSaved=" + getLastSaved()
        + ", valid=" + getValid()
        + ", creator=" + getCreator()
        + ", tenantId=" + getTenantId()
        + ", savedBy=" + getSavedBy()
        + ", labels=" + getLabels()
        + ", defaultSubmitUrl=" + getDefaultSubmitUrl()
        + ", languages=" + getLanguages()
        + ", additionalProperties=" + getAdditionalProperties()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
