package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link FormItem FormItem} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFormItem is not thread-safe</em>
 * @see ImmutableFormItem
 */
@Generated(from = "FormItem", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "FormItem"})
@NotThreadSafe
@JsonIgnoreProperties({"style", "options"})
public final class ModifiableFormItem implements FormItem {

  private String id;
  private String type;
  private @Nullable String view;
  private final Map<String, String> label = new LinkedHashMap<String, String>();
  private final Map<String, String> description = new LinkedHashMap<String, String>();
  private @Nullable String required;
  private final Map<String, String> requiredErrorText = new LinkedHashMap<String, String>();
  private @Nullable Boolean readOnly;
  private final ArrayList<String> items = new ArrayList<String>();
  private final ArrayList<String> className = new ArrayList<String>();
  private @Nullable String activeWhen;
  private @Nullable String canAddRowWhen;
  private @Nullable String canRemoveRowWhen;
  private final ArrayList<Validation> validations = new ArrayList<Validation>();
  private @Nullable String valueSetId;
  private @Nullable Object defaultValue;
  private @Nullable Map<String, Object> props = null;
  private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

  private ModifiableFormItem() {}

  /**
   * Construct a modifiable instance of {@code FormItem}.
   * @return A new modifiable instance
   */
  public static ModifiableFormItem create() {
    return new ModifiableFormItem();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    return id;
  }

  /**
   * @return value of {@code type} attribute, may be {@code null}
   */
  @JsonProperty("type")
  @Override
  public final String getType() {
    return type;
  }

  /**
   * @return value of {@code view} attribute, may be {@code null}
   */
  @JsonProperty("view")
  @Override
  public final @Nullable String getView() {
    return view;
  }

  /**
   * @return value of {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public final Map<String, String> getLabel() {
    return label;
  }

  /**
   * @return value of {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public final Map<String, String> getDescription() {
    return description;
  }

  /**
   * @return value of {@code required} attribute, may be {@code null}
   */
  @JsonProperty("required")
  @Override
  public final @Nullable String getRequired() {
    return required;
  }

  /**
   * @return value of {@code requiredErrorText} attribute
   */
  @JsonProperty("requiredErrorText")
  @Override
  public final Map<String, String> getRequiredErrorText() {
    return requiredErrorText;
  }

  /**
   * @return value of {@code readOnly} attribute, may be {@code null}
   */
  @JsonProperty("readOnly")
  @Override
  public final @Nullable Boolean getReadOnly() {
    return readOnly;
  }

  /**
   * @return modifiable list {@code items}
   */
  @JsonProperty("items")
  @Override
  public final List<String> getItems() {
    return items;
  }

  /**
   * @return modifiable list {@code className}
   */
  @JsonProperty("className")
  @Override
  public final List<String> getClassName() {
    return className;
  }

  /**
   * @return value of {@code activeWhen} attribute, may be {@code null}
   */
  @JsonProperty("activeWhen")
  @Override
  public final @Nullable String getActiveWhen() {
    return activeWhen;
  }

  /**
   * @return value of {@code canAddRowWhen} attribute, may be {@code null}
   */
  @JsonProperty("canAddRowWhen")
  @Override
  public final @Nullable String getCanAddRowWhen() {
    return canAddRowWhen;
  }

  /**
   * @return value of {@code canRemoveRowWhen} attribute, may be {@code null}
   */
  @JsonProperty("canRemoveRowWhen")
  @Override
  public final @Nullable String getCanRemoveRowWhen() {
    return canRemoveRowWhen;
  }

  /**
   * @return modifiable list {@code validations}
   */
  @JsonProperty("validations")
  @Override
  public final List<Validation> getValidations() {
    return validations;
  }

  /**
   * @return value of {@code valueSetId} attribute, may be {@code null}
   */
  @JsonProperty("valueSetId")
  @Override
  public final @Nullable String getValueSetId() {
    return valueSetId;
  }

  /**
   * @return value of {@code defaultValue} attribute, may be {@code null}
   */
  @JsonProperty("defaultValue")
  @Override
  public final @Nullable Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return value of {@code props} attribute, may be {@code null}
   */
  @JsonProperty("props")
  @Override
  public final @Nullable Map<String, Object> getProps() {
    return props;
  }

  /**
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @Override
  public final Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem clear() {
    id = null;
    type = null;
    view = null;
    label.clear();
    description.clear();
    required = null;
    requiredErrorText.clear();
    readOnly = null;
    items.clear();
    className.clear();
    activeWhen = null;
    canAddRowWhen = null;
    canRemoveRowWhen = null;
    validations.clear();
    valueSetId = null;
    defaultValue = null;
    props = null;
    additionalProperties.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormItem} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem from(FormItem instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFormItem) {
      from((ModifiableFormItem) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String typeValue = instance.getType();
    if (typeValue != null) {
      setType(typeValue);
    }
    String viewValue = instance.getView();
    if (viewValue != null) {
      setView(viewValue);
    }
    putAllLabel(instance.getLabel());
    putAllDescription(instance.getDescription());
    String requiredValue = instance.getRequired();
    if (requiredValue != null) {
      setRequired(requiredValue);
    }
    putAllRequiredErrorText(instance.getRequiredErrorText());
    Boolean readOnlyValue = instance.getReadOnly();
    if (readOnlyValue != null) {
      setReadOnly(readOnlyValue);
    }
    addAllItems(instance.getItems());
    addAllClassName(instance.getClassName());
    String activeWhenValue = instance.getActiveWhen();
    if (activeWhenValue != null) {
      setActiveWhen(activeWhenValue);
    }
    String canAddRowWhenValue = instance.getCanAddRowWhen();
    if (canAddRowWhenValue != null) {
      setCanAddRowWhen(canAddRowWhenValue);
    }
    String canRemoveRowWhenValue = instance.getCanRemoveRowWhen();
    if (canRemoveRowWhenValue != null) {
      setCanRemoveRowWhen(canRemoveRowWhenValue);
    }
    addAllValidations(instance.getValidations());
    String valueSetIdValue = instance.getValueSetId();
    if (valueSetIdValue != null) {
      setValueSetId(valueSetIdValue);
    }
    Object defaultValueValue = instance.getDefaultValue();
    if (defaultValueValue != null) {
      setDefaultValue(defaultValueValue);
    }
    Map<String, Object> propsValue = instance.getProps();
    if (propsValue != null) {
      putAllProps(propsValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link FormItem} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem from(ModifiableFormItem instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String typeValue = instance.getType();
    if (typeValue != null) {
      setType(typeValue);
    }
    String viewValue = instance.getView();
    if (viewValue != null) {
      setView(viewValue);
    }
    putAllLabel(instance.getLabel());
    putAllDescription(instance.getDescription());
    String requiredValue = instance.getRequired();
    if (requiredValue != null) {
      setRequired(requiredValue);
    }
    putAllRequiredErrorText(instance.getRequiredErrorText());
    Boolean readOnlyValue = instance.getReadOnly();
    if (readOnlyValue != null) {
      setReadOnly(readOnlyValue);
    }
    addAllItems(instance.getItems());
    addAllClassName(instance.getClassName());
    String activeWhenValue = instance.getActiveWhen();
    if (activeWhenValue != null) {
      setActiveWhen(activeWhenValue);
    }
    String canAddRowWhenValue = instance.getCanAddRowWhen();
    if (canAddRowWhenValue != null) {
      setCanAddRowWhen(canAddRowWhenValue);
    }
    String canRemoveRowWhenValue = instance.getCanRemoveRowWhen();
    if (canRemoveRowWhenValue != null) {
      setCanRemoveRowWhen(canRemoveRowWhenValue);
    }
    addAllValidations(instance.getValidations());
    String valueSetIdValue = instance.getValueSetId();
    if (valueSetIdValue != null) {
      setValueSetId(valueSetIdValue);
    }
    Object defaultValueValue = instance.getDefaultValue();
    if (defaultValueValue != null) {
      setDefaultValue(defaultValueValue);
    }
    Map<String, Object> propsValue = instance.getProps();
    if (propsValue != null) {
      putAllProps(propsValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getType() type} attribute.
   * @param type The value for type, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setType(String type) {
    this.type = type;
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getView() view} attribute.
   * @param view The value for view, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setView(@Nullable String view) {
    this.view = view;
    return this;
  }

  /**
   * Put one entry to the {@link FormItem#getLabel() label} map.
   * @param key The key in label map
   * @param value The associated value in the label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putLabel(String key, String value) {
    this.label.put(
        Objects.requireNonNull(key, "label key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getLabel() label} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setLabel(Map<String, ? extends String> entries) {
    this.label.clear();
    this.putAllLabel(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormItem#getLabel() label} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to label map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAllLabel(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.label.put(
          Objects.requireNonNull(k, "label key"),
          v);
    }
    return this;
  }

  /**
   * Put one entry to the {@link FormItem#getDescription() description} map.
   * @param key The key in description map
   * @param value The associated value in the description map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putDescription(String key, String value) {
    this.description.put(
        Objects.requireNonNull(key, "description key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getDescription() description} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the description map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setDescription(Map<String, ? extends String> entries) {
    this.description.clear();
    this.putAllDescription(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormItem#getDescription() description} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to description map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAllDescription(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.description.put(
          Objects.requireNonNull(k, "description key"),
          v);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getRequired() required} attribute.
   * @param required The value for required, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setRequired(@Nullable String required) {
    this.required = required;
    return this;
  }

  /**
   * Put one entry to the {@link FormItem#getRequiredErrorText() requiredErrorText} map.
   * @param key The key in requiredErrorText map
   * @param value The associated value in the requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putRequiredErrorText(String key, String value) {
    this.requiredErrorText.put(
        Objects.requireNonNull(key, "requiredErrorText key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getRequiredErrorText() requiredErrorText} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setRequiredErrorText(Map<String, ? extends String> entries) {
    this.requiredErrorText.clear();
    this.putAllRequiredErrorText(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormItem#getRequiredErrorText() requiredErrorText} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAllRequiredErrorText(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.requiredErrorText.put(
          Objects.requireNonNull(k, "requiredErrorText key"),
          v);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getReadOnly() readOnly} attribute.
   * @param readOnly The value for readOnly, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setReadOnly(@Nullable Boolean readOnly) {
    this.readOnly = readOnly;
    return this;
  }

  /**
   * Adds one element to {@link FormItem#getItems() items} list.
   * @param element The items element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addItems(String element) {
    this.items.add(element);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getItems() items} list.
   * @param elements An array of items elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormItem addItems(String... elements) {
    for (String e : elements) {
      addItems(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link FormItem#getItems() items} list.
   * @param elements An iterable of items elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setItems(Iterable<String> elements) {
    this.items.clear();
    addAllItems(elements);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getItems() items} list.
   * @param elements An iterable of items elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addAllItems(Iterable<String> elements) {
    for (String e : elements) {
      addItems(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link FormItem#getClassName() className} list.
   * @param element The className element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addClassName(String element) {
    this.className.add(element);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getClassName() className} list.
   * @param elements An array of className elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormItem addClassName(String... elements) {
    for (String e : elements) {
      addClassName(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link FormItem#getClassName() className} list.
   * @param elements An iterable of className elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setClassName(Iterable<String> elements) {
    this.className.clear();
    addAllClassName(elements);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getClassName() className} list.
   * @param elements An iterable of className elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addAllClassName(Iterable<String> elements) {
    for (String e : elements) {
      addClassName(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getActiveWhen() activeWhen} attribute.
   * @param activeWhen The value for activeWhen, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setActiveWhen(@Nullable String activeWhen) {
    this.activeWhen = activeWhen;
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getCanAddRowWhen() canAddRowWhen} attribute.
   * @param canAddRowWhen The value for canAddRowWhen, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setCanAddRowWhen(@Nullable String canAddRowWhen) {
    this.canAddRowWhen = canAddRowWhen;
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getCanRemoveRowWhen() canRemoveRowWhen} attribute.
   * @param canRemoveRowWhen The value for canRemoveRowWhen, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setCanRemoveRowWhen(@Nullable String canRemoveRowWhen) {
    this.canRemoveRowWhen = canRemoveRowWhen;
    return this;
  }

  /**
   * Adds one element to {@link FormItem#getValidations() validations} list.
   * @param element The validations element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addValidations(Validation element) {
    this.validations.add(element);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getValidations() validations} list.
   * @param elements An array of validations elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableFormItem addValidations(Validation... elements) {
    for (Validation e : elements) {
      addValidations(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link FormItem#getValidations() validations} list.
   * @param elements An iterable of validations elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setValidations(Iterable<? extends Validation> elements) {
    this.validations.clear();
    addAllValidations(elements);
    return this;
  }

  /**
   * Adds elements to {@link FormItem#getValidations() validations} list.
   * @param elements An iterable of validations elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem addAllValidations(Iterable<? extends Validation> elements) {
    for (Validation e : elements) {
      addValidations(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getValueSetId() valueSetId} attribute.
   * @param valueSetId The value for valueSetId, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setValueSetId(@Nullable String valueSetId) {
    this.valueSetId = valueSetId;
    return this;
  }

  /**
   * Assigns a value to the {@link FormItem#getDefaultValue() defaultValue} attribute.
   * @param defaultValue The value for defaultValue, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setDefaultValue(@Nullable Object defaultValue) {
    this.defaultValue = defaultValue;
    return this;
  }

  /**
   * Put one entry to the {@link FormItem#getProps() props} map.
   * @param key The key in props map
   * @param value The associated value in the props map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putProps(String key, Object value) {
    if (this.props == null) {
      this.props = new LinkedHashMap<String, Object>();
    }
    this.props.put(
        Objects.requireNonNull(key, "props key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getProps() props} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the props map, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setProps(@Nullable Map<String, ? extends Object> entries) {
    if (entries == null) {
      this.props = null;
      return this;
    }
    if (this.props == null) {
      this.props = new LinkedHashMap<String, Object>();
    } else {
      this.props.clear();
    }
    this.putAllProps(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormItem#getProps() props} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to props map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAllProps(Map<String, ? extends Object> entries) {
    if (this.props == null) {
      this.props = new LinkedHashMap<String, Object>();
    }
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.props.put(
          Objects.requireNonNull(k, "props key"),
          v);
    }
    return this;
  }

  /**
   * Put one entry to the {@link FormItem#getAdditionalProperties() additionalProperties} map.
   * @param key The key in additionalProperties map
   * @param value The associated value in the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(
        Objects.requireNonNull(key, "additionalProperties key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem setAdditionalProperties(Map<String, ? extends Object> entries) {
    this.additionalProperties.clear();
    this.putAllAdditionalProperties(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link FormItem#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFormItem putAllAdditionalProperties(Map<String, ? extends Object> entries) {
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.additionalProperties.put(
          Objects.requireNonNull(k, "additionalProperties key"),
          v);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableFormItem ImmutableFormItem}.
   * @return An immutable instance of FormItem
   */
  public final ImmutableFormItem toImmutable() {
    return ImmutableFormItem.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFormItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFormItem)) return false;
    ModifiableFormItem other = (ModifiableFormItem) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFormItem another) {
    return Objects.equals(id, another.id)
        && Objects.equals(type, another.type)
        && Objects.equals(view, another.view)
        && label.equals(another.label)
        && description.equals(another.description)
        && Objects.equals(required, another.required)
        && requiredErrorText.equals(another.requiredErrorText)
        && Objects.equals(readOnly, another.readOnly)
        && items.equals(another.items)
        && className.equals(another.className)
        && Objects.equals(activeWhen, another.activeWhen)
        && Objects.equals(canAddRowWhen, another.canAddRowWhen)
        && Objects.equals(canRemoveRowWhen, another.canRemoveRowWhen)
        && validations.equals(another.validations)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(props, another.props)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}, {@code view}, {@code label}, {@code description}, {@code required}, {@code requiredErrorText}, {@code readOnly}, {@code items}, {@code className}, {@code activeWhen}, {@code canAddRowWhen}, {@code canRemoveRowWhen}, {@code validations}, {@code valueSetId}, {@code defaultValue}, {@code props}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(view);
    h += (h << 5) + label.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Objects.hashCode(required);
    h += (h << 5) + requiredErrorText.hashCode();
    h += (h << 5) + Objects.hashCode(readOnly);
    h += (h << 5) + items.hashCode();
    h += (h << 5) + className.hashCode();
    h += (h << 5) + Objects.hashCode(activeWhen);
    h += (h << 5) + Objects.hashCode(canAddRowWhen);
    h += (h << 5) + Objects.hashCode(canRemoveRowWhen);
    h += (h << 5) + validations.hashCode();
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(props);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code FormItem}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableFormItem{"
        + "id=" + getId()
        + ", type=" + getType()
        + ", view=" + getView()
        + ", label=" + getLabel()
        + ", description=" + getDescription()
        + ", required=" + getRequired()
        + ", requiredErrorText=" + getRequiredErrorText()
        + ", readOnly=" + getReadOnly()
        + ", items=" + getItems()
        + ", className=" + getClassName()
        + ", activeWhen=" + getActiveWhen()
        + ", canAddRowWhen=" + getCanAddRowWhen()
        + ", canRemoveRowWhen=" + getCanRemoveRowWhen()
        + ", validations=" + getValidations()
        + ", valueSetId=" + getValueSetId()
        + ", defaultValue=" + getDefaultValue()
        + ", props=" + getProps()
        + ", additionalProperties=" + getAdditionalProperties()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
