package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Form Form} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableForm is not thread-safe</em>
 * @see ImmutableForm
 */
@Generated(from = "Form", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Form"})
@NotThreadSafe
@JsonIgnoreProperties({"saving", "rules", "updated", "failed", "serviceCalls"})
public final class ModifiableForm implements Form {

  private @Nullable String id;
  private @Nullable String rev;
  private @Nullable String name;
  private final Map<String, FormItem> data = new LinkedHashMap<String, FormItem>();
  private Form.Metadata metadata;
  private final ArrayList<Variable> variables = new ArrayList<Variable>();
  private final Map<String, Form> namespaces = new LinkedHashMap<String, Form>();
  private final ArrayList<FormValueSet> valueSets = new ArrayList<FormValueSet>();
  private final Map<String, String> requiredErrorText = new LinkedHashMap<String, String>();

  private ModifiableForm() {}

  /**
   * Construct a modifiable instance of {@code Form}.
   * @return A new modifiable instance
   */
  public static ModifiableForm create() {
    return new ModifiableForm();
  }

  /**
   * @return value of {@code id} attribute, may be {@code null}
   */
  @JsonProperty("_id")
  @Override
  public final @Nullable String getId() {
    return id;
  }

  /**
   * @return value of {@code rev} attribute, may be {@code null}
   */
  @JsonProperty("_rev")
  @Override
  public final @Nullable String getRev() {
    return rev;
  }

  /**
   * @return value of {@code name} attribute, may be {@code null}
   */
  @JsonProperty("name")
  @Override
  public final @Nullable String getName() {
    return name;
  }

  /**
   * @return value of {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public final Map<String, FormItem> getData() {
    return data;
  }

  /**
   * @return value of {@code metadata} attribute, may be {@code null}
   */
  @JsonProperty("metadata")
  @Override
  public final Form.Metadata getMetadata() {
    return metadata;
  }

  /**
   * @return modifiable list {@code variables}
   */
  @JsonProperty("variables")
  @Override
  public final List<Variable> getVariables() {
    return variables;
  }

  /**
   * @return value of {@code namespaces} attribute
   */
  @JsonProperty("namespaces")
  @Override
  public final Map<String, Form> getNamespaces() {
    return namespaces;
  }

  /**
   * @return modifiable list {@code valueSets}
   */
  @JsonProperty("valueSets")
  @Override
  public final List<FormValueSet> getValueSets() {
    return valueSets;
  }

  /**
   * @return error text for required fields, unless not defined per item
   */
  @JsonProperty("requiredErrorText")
  @Override
  public final Map<String, String> getRequiredErrorText() {
    return requiredErrorText;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm clear() {
    id = null;
    rev = null;
    name = null;
    data.clear();
    metadata = null;
    variables.clear();
    namespaces.clear();
    valueSets.clear();
    requiredErrorText.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Form} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm from(Form instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableForm) {
      from((ModifiableForm) instance);
      return this;
    }
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String revValue = instance.getRev();
    if (revValue != null) {
      setRev(revValue);
    }
    String nameValue = instance.getName();
    if (nameValue != null) {
      setName(nameValue);
    }
    putAllData(instance.getData());
    Form.Metadata metadataValue = instance.getMetadata();
    if (metadataValue != null) {
      setMetadata(metadataValue);
    }
    addAllVariables(instance.getVariables());
    putAllNamespaces(instance.getNamespaces());
    addAllValueSets(instance.getValueSets());
    putAllRequiredErrorText(instance.getRequiredErrorText());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Form} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm from(ModifiableForm instance) {
    Objects.requireNonNull(instance, "instance");
    String idValue = instance.getId();
    if (idValue != null) {
      setId(idValue);
    }
    String revValue = instance.getRev();
    if (revValue != null) {
      setRev(revValue);
    }
    String nameValue = instance.getName();
    if (nameValue != null) {
      setName(nameValue);
    }
    putAllData(instance.getData());
    Form.Metadata metadataValue = instance.getMetadata();
    if (metadataValue != null) {
      setMetadata(metadataValue);
    }
    addAllVariables(instance.getVariables());
    putAllNamespaces(instance.getNamespaces());
    addAllValueSets(instance.getValueSets());
    putAllRequiredErrorText(instance.getRequiredErrorText());
    return this;
  }

  /**
   * Assigns a value to the {@link Form#getId() id} attribute.
   * @param id The value for id, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setId(@Nullable String id) {
    this.id = id;
    return this;
  }

  /**
   * Assigns a value to the {@link Form#getRev() rev} attribute.
   * @param rev The value for rev, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setRev(@Nullable String rev) {
    this.rev = rev;
    return this;
  }

  /**
   * Assigns a value to the {@link Form#getName() name} attribute.
   * @param name The value for name, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setName(@Nullable String name) {
    this.name = name;
    return this;
  }

  /**
   * Put one entry to the {@link Form#getData() data} map.
   * @param key The key in data map
   * @param value The associated value in the data map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putData(String key, FormItem value) {
    this.data.put(
        Objects.requireNonNull(key, "data key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Form#getData() data} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the data map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setData(Map<String, ? extends FormItem> entries) {
    this.data.clear();
    this.putAllData(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Form#getData() data} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to data map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putAllData(Map<String, ? extends FormItem> entries) {
    for (Map.Entry<String, ? extends FormItem> e : entries.entrySet()) {
      String k = e.getKey();
      FormItem v = e.getValue();
      this.data.put(
          Objects.requireNonNull(k, "data key"),
          v);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Form#getMetadata() metadata} attribute.
   * @param metadata The value for metadata, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setMetadata(Form.Metadata metadata) {
    this.metadata = metadata;
    return this;
  }

  /**
   * Adds one element to {@link Form#getVariables() variables} list.
   * @param element The variables element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm addVariables(Variable element) {
    this.variables.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Form#getVariables() variables} list.
   * @param elements An array of variables elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableForm addVariables(Variable... elements) {
    for (Variable e : elements) {
      addVariables(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Form#getVariables() variables} list.
   * @param elements An iterable of variables elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setVariables(Iterable<? extends Variable> elements) {
    this.variables.clear();
    addAllVariables(elements);
    return this;
  }

  /**
   * Adds elements to {@link Form#getVariables() variables} list.
   * @param elements An iterable of variables elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm addAllVariables(Iterable<? extends Variable> elements) {
    for (Variable e : elements) {
      addVariables(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Form#getNamespaces() namespaces} map.
   * @param key The key in namespaces map
   * @param value The associated value in the namespaces map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putNamespaces(String key, Form value) {
    this.namespaces.put(
        Objects.requireNonNull(key, "namespaces key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Form#getNamespaces() namespaces} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the namespaces map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setNamespaces(Map<String, ? extends Form> entries) {
    this.namespaces.clear();
    this.putAllNamespaces(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Form#getNamespaces() namespaces} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to namespaces map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putAllNamespaces(Map<String, ? extends Form> entries) {
    for (Map.Entry<String, ? extends Form> e : entries.entrySet()) {
      String k = e.getKey();
      Form v = e.getValue();
      this.namespaces.put(
          Objects.requireNonNull(k, "namespaces key"),
          v);
    }
    return this;
  }

  /**
   * Adds one element to {@link Form#getValueSets() valueSets} list.
   * @param element The valueSets element
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm addValueSets(FormValueSet element) {
    this.valueSets.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Form#getValueSets() valueSets} list.
   * @param elements An array of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableForm addValueSets(FormValueSet... elements) {
    for (FormValueSet e : elements) {
      addValueSets(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Form#getValueSets() valueSets} list.
   * @param elements An iterable of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setValueSets(Iterable<? extends FormValueSet> elements) {
    this.valueSets.clear();
    addAllValueSets(elements);
    return this;
  }

  /**
   * Adds elements to {@link Form#getValueSets() valueSets} list.
   * @param elements An iterable of valueSets elements
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm addAllValueSets(Iterable<? extends FormValueSet> elements) {
    for (FormValueSet e : elements) {
      addValueSets(e);
    }
    return this;
  }

  /**
   * Put one entry to the {@link Form#getRequiredErrorText() requiredErrorText} map.
   * @param key The key in requiredErrorText map
   * @param value The associated value in the requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putRequiredErrorText(String key, String value) {
    this.requiredErrorText.put(
        Objects.requireNonNull(key, "requiredErrorText key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Form#getRequiredErrorText() requiredErrorText} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm setRequiredErrorText(Map<String, ? extends String> entries) {
    this.requiredErrorText.clear();
    this.putAllRequiredErrorText(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Form#getRequiredErrorText() requiredErrorText} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to requiredErrorText map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableForm putAllRequiredErrorText(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.requiredErrorText.put(
          Objects.requireNonNull(k, "requiredErrorText key"),
          v);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableForm ImmutableForm}.
   * @return An immutable instance of Form
   */
  public final ImmutableForm toImmutable() {
    return ImmutableForm.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableForm} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableForm)) return false;
    ModifiableForm other = (ModifiableForm) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableForm another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && Objects.equals(name, another.name)
        && data.equals(another.data)
        && Objects.equals(metadata, another.metadata)
        && variables.equals(another.variables)
        && namespaces.equals(another.namespaces)
        && valueSets.equals(another.valueSets)
        && requiredErrorText.equals(another.requiredErrorText);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code data}, {@code metadata}, {@code variables}, {@code namespaces}, {@code valueSets}, {@code requiredErrorText}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + data.hashCode();
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + namespaces.hashCode();
    h += (h << 5) + valueSets.hashCode();
    h += (h << 5) + requiredErrorText.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Form}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableForm{"
        + "id=" + getId()
        + ", rev=" + getRev()
        + ", name=" + getName()
        + ", data=" + getData()
        + ", metadata=" + getMetadata()
        + ", variables=" + getVariables()
        + ", namespaces=" + getNamespaces()
        + ", valueSets=" + getValueSets()
        + ", requiredErrorText=" + getRequiredErrorText()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
