package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Validation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValidation.builder()}.
 */
@Generated(from = "Validation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableValidation implements Validation {
  private final Map<String, String> message;
  private final @Nullable String rule;

  private ImmutableValidation(
      Map<String, String> message,
      @Nullable String rule) {
    this.message = message;
    this.rule = rule;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty("message")
  @Override
  public Map<String, String> getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code rule} attribute
   */
  @JsonProperty("rule")
  @Override
  public @Nullable String getRule() {
    return rule;
  }

  /**
   * Copy the current immutable object by replacing the {@link Validation#getMessage() message} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the message map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableValidation withMessage(Map<String, ? extends String> entries) {
    if (this.message == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableValidation(newValue, this.rule);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Validation#getRule() rule} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rule (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValidation withRule(@Nullable String value) {
    if (Objects.equals(this.rule, value)) return this;
    return new ImmutableValidation(this.message, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValidation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableValidation
        && equalTo(0, (ImmutableValidation) another);
  }

  private boolean equalTo(int synthetic, ImmutableValidation another) {
    return message.equals(another.message)
        && Objects.equals(rule, another.rule);
  }

  /**
   * Computes a hash code from attributes: {@code message}, {@code rule}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(rule);
    return h;
  }

  /**
   * Prints the immutable value {@code Validation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Validation{"
        + "message=" + message
        + ", rule=" + rule
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Validation", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Validation {
    @javax.annotation.Nullable Map<String, String> message = Collections.emptyMap();
    @javax.annotation.Nullable String rule;
    @JsonProperty("message")
    public void setMessage(Map<String, String> message) {
      this.message = message;
    }
    @JsonProperty("rule")
    public void setRule(@Nullable String rule) {
      this.rule = rule;
    }
    @Override
    public Map<String, String> getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public String getRule() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableValidation fromJson(Json json) {
    ImmutableValidation.Builder builder = ImmutableValidation.builder();
    if (json.message != null) {
      builder.putAllMessage(json.message);
    }
    if (json.rule != null) {
      builder.rule(json.rule);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Validation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Validation instance
   */
  public static ImmutableValidation copyOf(Validation instance) {
    if (instance instanceof ImmutableValidation) {
      return (ImmutableValidation) instance;
    }
    return ImmutableValidation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValidation ImmutableValidation}.
   * <pre>
   * ImmutableValidation.builder()
   *    .putMessage|putAllMessage(String =&gt; String) // {@link Validation#getMessage() message} mappings
   *    .rule(String | null) // nullable {@link Validation#getRule() rule}
   *    .build();
   * </pre>
   * @return A new ImmutableValidation builder
   */
  public static ImmutableValidation.Builder builder() {
    return new ImmutableValidation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValidation ImmutableValidation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Validation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, String> message = new LinkedHashMap<String, String>();
    private @javax.annotation.Nullable String rule;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableValidation} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableValidation instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMessage(instance.getMessage());
      String ruleValue = instance.getRule();
      if (ruleValue != null) {
        rule(ruleValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Validation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Validation instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableValidation) {
        return from((ModifiableValidation) instance);
      }
      putAllMessage(instance.getMessage());
      String ruleValue = instance.getRule();
      if (ruleValue != null) {
        rule(ruleValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link Validation#getMessage() message} map.
     * @param key The key in the message map
     * @param value The associated value in the message map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMessage(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.message.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Validation#getMessage() message} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMessage(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.message.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Validation#getMessage() message} map. Nulls are not permitted
     * @param entries The entries that will be added to the message map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("message")
    public final Builder message(Map<String, ? extends String> entries) {
      this.message.clear();
      return putAllMessage(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Validation#getMessage() message} map. Nulls are not permitted
     * @param entries The entries that will be added to the message map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMessage(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.message.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Validation#getRule() rule} attribute.
     * @param rule The value for rule (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rule")
    public final Builder rule(@Nullable String rule) {
      this.rule = rule;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValidation ImmutableValidation}.
     * @return An immutable instance of Validation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValidation build() {
      return new ImmutableValidation(createUnmodifiableMap(false, false, message), rule);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
