package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.rest.Response;
import io.dialob.api.rest.ResponseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormPutResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormPutResponse.builder()}.
 */
@Generated(from = "FormPutResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableFormPutResponse implements FormPutResponse {
  private final Boolean ok;
  private final String error;
  private final String reason;
  private final String id;
  private final String rev;
  private final List<FormValidationError> errors;
  private final Form form;

  private ImmutableFormPutResponse(
      Boolean ok,
      String error,
      String reason,
      String id,
      String rev,
      List<FormValidationError> errors,
      Form form) {
    this.ok = ok;
    this.error = error;
    this.reason = reason;
    this.id = id;
    this.rev = rev;
    this.errors = errors;
    this.form = form;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty("ok")
  @Override
  public Boolean getOk() {
    return ok;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public String getError() {
    return error;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public String getReason() {
    return reason;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public List<FormValidationError> getErrors() {
    return errors;
  }

  /**
   * @return The value of the {@code form} attribute
   */
  @JsonProperty("form")
  @Override
  public Form getForm() {
    return form;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getOk() ok} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ok (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withOk(Boolean value) {
    if (Objects.equals(this.ok, value)) return this;
    return new ImmutableFormPutResponse(value, this.error, this.reason, this.id, this.rev, this.errors, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withError(String value) {
    if (Objects.equals(this.error, value)) return this;
    return new ImmutableFormPutResponse(this.ok, value, this.reason, this.id, this.rev, this.errors, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getReason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withReason(String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableFormPutResponse(this.ok, this.error, value, this.id, this.rev, this.errors, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormPutResponse(this.ok, this.error, this.reason, value, this.rev, this.errors, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withRev(String value) {
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, value, this.errors, this.form);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormPutResponse#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormPutResponse withErrors(FormValidationError... elements) {
    List<FormValidationError> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, newValue, this.form);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormPutResponse#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormPutResponse withErrors(Iterable<? extends FormValidationError> elements) {
    if (this.errors == elements) return this;
    List<FormValidationError> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, newValue, this.form);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormPutResponse#getForm() form} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for form (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormPutResponse withForm(Form value) {
    if (this.form == value) return this;
    return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, this.errors, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormPutResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormPutResponse
        && equalTo(0, (ImmutableFormPutResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormPutResponse another) {
    return Objects.equals(ok, another.ok)
        && Objects.equals(error, another.error)
        && Objects.equals(reason, another.reason)
        && Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && errors.equals(another.errors)
        && Objects.equals(form, another.form);
  }

  /**
   * Computes a hash code from attributes: {@code ok}, {@code error}, {@code reason}, {@code id}, {@code rev}, {@code errors}, {@code form}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(ok);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + errors.hashCode();
    h += (h << 5) + Objects.hashCode(form);
    return h;
  }

  /**
   * Prints the immutable value {@code FormPutResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormPutResponse{"
        + "ok=" + ok
        + ", error=" + error
        + ", reason=" + reason
        + ", id=" + id
        + ", rev=" + rev
        + ", errors=" + errors
        + ", form=" + form
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormPutResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormPutResponse {
    @Nullable Boolean ok;
    @Nullable String error;
    @Nullable String reason;
    @Nullable String id;
    @Nullable String rev;
    @Nullable List<FormValidationError> errors = Collections.emptyList();
    @Nullable Form form;
    @JsonProperty("ok")
    public void setOk(Boolean ok) {
      this.ok = ok;
    }
    @JsonProperty("error")
    public void setError(String error) {
      this.error = error;
    }
    @JsonProperty("reason")
    public void setReason(String reason) {
      this.reason = reason;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("errors")
    public void setErrors(List<FormValidationError> errors) {
      this.errors = errors;
    }
    @JsonProperty("form")
    public void setForm(Form form) {
      this.form = form;
    }
    @Override
    public Boolean getOk() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getReason() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public List<FormValidationError> getErrors() { throw new UnsupportedOperationException(); }
    @Override
    public Form getForm() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormPutResponse fromJson(Json json) {
    ImmutableFormPutResponse.Builder builder = ImmutableFormPutResponse.builder();
    if (json.ok != null) {
      builder.ok(json.ok);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.errors != null) {
      builder.addAllErrors(json.errors);
    }
    if (json.form != null) {
      builder.form(json.form);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormPutResponse} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormPutResponse instance
   */
  public static ImmutableFormPutResponse copyOf(FormPutResponse instance) {
    if (instance instanceof ImmutableFormPutResponse) {
      return (ImmutableFormPutResponse) instance;
    }
    return ImmutableFormPutResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormPutResponse ImmutableFormPutResponse}.
   * <pre>
   * ImmutableFormPutResponse.builder()
   *    .ok(Boolean | null) // nullable {@link FormPutResponse#getOk() ok}
   *    .error(String | null) // nullable {@link FormPutResponse#getError() error}
   *    .reason(String | null) // nullable {@link FormPutResponse#getReason() reason}
   *    .id(String | null) // nullable {@link FormPutResponse#getId() id}
   *    .rev(String | null) // nullable {@link FormPutResponse#getRev() rev}
   *    .addErrors|addAllErrors(io.dialob.api.form.FormValidationError) // {@link FormPutResponse#getErrors() errors} elements
   *    .form(io.dialob.api.form.Form | null) // nullable {@link FormPutResponse#getForm() form}
   *    .build();
   * </pre>
   * @return A new ImmutableFormPutResponse builder
   */
  public static ImmutableFormPutResponse.Builder builder() {
    return new ImmutableFormPutResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormPutResponse ImmutableFormPutResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormPutResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean ok;
    private @Nullable String error;
    private @Nullable String reason;
    private @Nullable String id;
    private @Nullable String rev;
    private List<FormValidationError> errors = new ArrayList<FormValidationError>();
    private @Nullable Form form;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.api.rest.Response} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Response instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.api.rest.ResponseStatus} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResponseStatus instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.api.form.FormPutResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormPutResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Response) {
        Response instance = (Response) object;
        if ((bits & 0x2L) == 0) {
          Boolean okValue = instance.getOk();
          if (okValue != null) {
            ok(okValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          String reasonValue = instance.getReason();
          if (reasonValue != null) {
            reason(reasonValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof ResponseStatus) {
        ResponseStatus instance = (ResponseStatus) object;
        if ((bits & 0x2L) == 0) {
          Boolean okValue = instance.getOk();
          if (okValue != null) {
            ok(okValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof FormPutResponse) {
        FormPutResponse instance = (FormPutResponse) object;
        if ((bits & 0x1L) == 0) {
          String reasonValue = instance.getReason();
          if (reasonValue != null) {
            reason(reasonValue);
          }
          bits |= 0x1L;
        }
        String revValue = instance.getRev();
        if (revValue != null) {
          rev(revValue);
        }
        Form formValue = instance.getForm();
        if (formValue != null) {
          form(formValue);
        }
        String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
        if ((bits & 0x2L) == 0) {
          Boolean okValue = instance.getOk();
          if (okValue != null) {
            ok(okValue);
          }
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String errorValue = instance.getError();
          if (errorValue != null) {
            error(errorValue);
          }
          bits |= 0x4L;
        }
        addAllErrors(instance.getErrors());
      }
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getOk() ok} attribute.
     * @param ok The value for ok (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ok")
    public final Builder ok(Boolean ok) {
      this.ok = ok;
      return this;
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getReason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reason")
    public final Builder reason(String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Adds one element to {@link FormPutResponse#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(@Nullable FormValidationError element) {
      this.errors.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FormPutResponse#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(FormValidationError... elements) {
      for (FormValidationError element : elements) {
        this.errors.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormPutResponse#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    public final Builder errors(Iterable<? extends FormValidationError> elements) {
      this.errors.clear();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link FormPutResponse#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends FormValidationError> elements) {
      for (FormValidationError element : elements) {
        this.errors.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormPutResponse#getForm() form} attribute.
     * @param form The value for form (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("form")
    public final Builder form(Form form) {
      this.form = form;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormPutResponse ImmutableFormPutResponse}.
     * @return An immutable instance of FormPutResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormPutResponse build() {
      return new ImmutableFormPutResponse(ok, error, reason, id, rev, createUnmodifiableList(true, errors), form);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
