package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FormItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFormItem.builder()}.
 */
@Generated(from = "FormItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@JsonIgnoreProperties({"style", "options"})
public final class ImmutableFormItem implements FormItem {
  private final String id;
  private final String type;
  private final @Nullable String view;
  private final Map<String, String> label;
  private final Map<String, String> description;
  private final @Nullable String required;
  private final Map<String, String> requiredErrorText;
  private final @Nullable Boolean readOnly;
  private final List<String> items;
  private final List<String> className;
  private final @Nullable String activeWhen;
  private final @Nullable String canAddRowWhen;
  private final @Nullable String canRemoveRowWhen;
  private final List<Validation> validations;
  private final @Nullable String valueSetId;
  private final @Nullable Object defaultValue;
  private final @Nullable Map<String, Object> props;
  private final Map<String, Object> additionalProperties;

  private ImmutableFormItem(
      String id,
      String type,
      @Nullable String view,
      Map<String, String> label,
      Map<String, String> description,
      @Nullable String required,
      Map<String, String> requiredErrorText,
      @Nullable Boolean readOnly,
      List<String> items,
      List<String> className,
      @Nullable String activeWhen,
      @Nullable String canAddRowWhen,
      @Nullable String canRemoveRowWhen,
      List<Validation> validations,
      @Nullable String valueSetId,
      @Nullable Object defaultValue,
      @Nullable Map<String, Object> props,
      Map<String, Object> additionalProperties) {
    this.id = id;
    this.type = type;
    this.view = view;
    this.label = label;
    this.description = description;
    this.required = required;
    this.requiredErrorText = requiredErrorText;
    this.readOnly = readOnly;
    this.items = items;
    this.className = className;
    this.activeWhen = activeWhen;
    this.canAddRowWhen = canAddRowWhen;
    this.canRemoveRowWhen = canRemoveRowWhen;
    this.validations = validations;
    this.valueSetId = valueSetId;
    this.defaultValue = defaultValue;
    this.props = props;
    this.additionalProperties = additionalProperties;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code view} attribute
   */
  @JsonProperty("view")
  @Override
  public @Nullable String getView() {
    return view;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public Map<String, String> getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public Map<String, String> getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code required} attribute
   */
  @JsonProperty("required")
  @Override
  public @Nullable String getRequired() {
    return required;
  }

  /**
   * @return The value of the {@code requiredErrorText} attribute
   */
  @JsonProperty("requiredErrorText")
  @Override
  public Map<String, String> getRequiredErrorText() {
    return requiredErrorText;
  }

  /**
   * @return The value of the {@code readOnly} attribute
   */
  @JsonProperty("readOnly")
  @Override
  public @Nullable Boolean getReadOnly() {
    return readOnly;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @JsonProperty("items")
  @Override
  public List<String> getItems() {
    return items;
  }

  /**
   * @return The value of the {@code className} attribute
   */
  @JsonProperty("className")
  @Override
  public List<String> getClassName() {
    return className;
  }

  /**
   * @return The value of the {@code activeWhen} attribute
   */
  @JsonProperty("activeWhen")
  @Override
  public @Nullable String getActiveWhen() {
    return activeWhen;
  }

  /**
   * @return The value of the {@code canAddRowWhen} attribute
   */
  @JsonProperty("canAddRowWhen")
  @Override
  public @Nullable String getCanAddRowWhen() {
    return canAddRowWhen;
  }

  /**
   * @return The value of the {@code canRemoveRowWhen} attribute
   */
  @JsonProperty("canRemoveRowWhen")
  @Override
  public @Nullable String getCanRemoveRowWhen() {
    return canRemoveRowWhen;
  }

  /**
   * @return The value of the {@code validations} attribute
   */
  @JsonProperty("validations")
  @Override
  public List<Validation> getValidations() {
    return validations;
  }

  /**
   * @return The value of the {@code valueSetId} attribute
   */
  @JsonProperty("valueSetId")
  @Override
  public @Nullable String getValueSetId() {
    return valueSetId;
  }

  /**
   * @return The value of the {@code defaultValue} attribute
   */
  @JsonProperty("defaultValue")
  @Override
  public @Nullable Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * @return The value of the {@code props} attribute
   */
  @JsonProperty("props")
  @Override
  public @Nullable Map<String, Object> getProps() {
    return props;
  }

  /**
   * @return The value of the {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @JsonAnyGetter
  @Override
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withId(String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableFormItem(
        value,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableFormItem(
        this.id,
        value,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getView() view} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for view (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withView(@Nullable String value) {
    if (Objects.equals(this.view, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        value,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getLabel() label} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the label map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withLabel(Map<String, ? extends String> entries) {
    if (this.label == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        newValue,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getDescription() description} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the description map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withDescription(Map<String, ? extends String> entries) {
    if (this.description == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        newValue,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getRequired() required} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for required (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withRequired(@Nullable String value) {
    if (Objects.equals(this.required, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        value,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getRequiredErrorText() requiredErrorText} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the requiredErrorText map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withRequiredErrorText(Map<String, ? extends String> entries) {
    if (this.requiredErrorText == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        newValue,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getReadOnly() readOnly} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for readOnly (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withReadOnly(@Nullable Boolean value) {
    if (Objects.equals(this.readOnly, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        value,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withItems(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        newValue,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withItems(Iterable<String> elements) {
    if (this.items == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        newValue,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getClassName() className}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withClassName(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        newValue,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getClassName() className}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of className elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withClassName(Iterable<String> elements) {
    if (this.className == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        newValue,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getActiveWhen() activeWhen} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for activeWhen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withActiveWhen(@Nullable String value) {
    if (Objects.equals(this.activeWhen, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        value,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getCanAddRowWhen() canAddRowWhen} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for canAddRowWhen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withCanAddRowWhen(@Nullable String value) {
    if (Objects.equals(this.canAddRowWhen, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        value,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getCanRemoveRowWhen() canRemoveRowWhen} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for canRemoveRowWhen (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withCanRemoveRowWhen(@Nullable String value) {
    if (Objects.equals(this.canRemoveRowWhen, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        value,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getValidations() validations}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withValidations(Validation... elements) {
    List<Validation> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        newValue,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FormItem#getValidations() validations}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of validations elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withValidations(Iterable<? extends Validation> elements) {
    if (this.validations == elements) return this;
    List<Validation> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        newValue,
        this.valueSetId,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getValueSetId() valueSetId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for valueSetId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withValueSetId(@Nullable String value) {
    if (Objects.equals(this.valueSetId, value)) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        value,
        this.defaultValue,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FormItem#getDefaultValue() defaultValue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFormItem withDefaultValue(@Nullable Object value) {
    if (this.defaultValue == value) return this;
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        value,
        this.props,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getProps() props} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the props map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withProps(@Nullable Map<String, ? extends Object> entries) {
    if (this.props == entries) return this;
    Map<String, Object> newValue = entries == null ? null : createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        newValue,
        this.additionalProperties);
  }

  /**
   * Copy the current immutable object by replacing the {@link FormItem#getAdditionalProperties() additionalProperties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the additionalProperties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFormItem withAdditionalProperties(Map<String, ? extends Object> entries) {
    if (this.additionalProperties == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableFormItem(
        this.id,
        this.type,
        this.view,
        this.label,
        this.description,
        this.required,
        this.requiredErrorText,
        this.readOnly,
        this.items,
        this.className,
        this.activeWhen,
        this.canAddRowWhen,
        this.canRemoveRowWhen,
        this.validations,
        this.valueSetId,
        this.defaultValue,
        this.props,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFormItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFormItem
        && equalTo(0, (ImmutableFormItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableFormItem another) {
    return Objects.equals(id, another.id)
        && Objects.equals(type, another.type)
        && Objects.equals(view, another.view)
        && label.equals(another.label)
        && description.equals(another.description)
        && Objects.equals(required, another.required)
        && requiredErrorText.equals(another.requiredErrorText)
        && Objects.equals(readOnly, another.readOnly)
        && items.equals(another.items)
        && className.equals(another.className)
        && Objects.equals(activeWhen, another.activeWhen)
        && Objects.equals(canAddRowWhen, another.canAddRowWhen)
        && Objects.equals(canRemoveRowWhen, another.canRemoveRowWhen)
        && validations.equals(another.validations)
        && Objects.equals(valueSetId, another.valueSetId)
        && Objects.equals(defaultValue, another.defaultValue)
        && Objects.equals(props, another.props)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code type}, {@code view}, {@code label}, {@code description}, {@code required}, {@code requiredErrorText}, {@code readOnly}, {@code items}, {@code className}, {@code activeWhen}, {@code canAddRowWhen}, {@code canRemoveRowWhen}, {@code validations}, {@code valueSetId}, {@code defaultValue}, {@code props}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + Objects.hashCode(view);
    h += (h << 5) + label.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + Objects.hashCode(required);
    h += (h << 5) + requiredErrorText.hashCode();
    h += (h << 5) + Objects.hashCode(readOnly);
    h += (h << 5) + items.hashCode();
    h += (h << 5) + className.hashCode();
    h += (h << 5) + Objects.hashCode(activeWhen);
    h += (h << 5) + Objects.hashCode(canAddRowWhen);
    h += (h << 5) + Objects.hashCode(canRemoveRowWhen);
    h += (h << 5) + validations.hashCode();
    h += (h << 5) + Objects.hashCode(valueSetId);
    h += (h << 5) + Objects.hashCode(defaultValue);
    h += (h << 5) + Objects.hashCode(props);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FormItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FormItem{"
        + "id=" + id
        + ", type=" + type
        + ", view=" + view
        + ", label=" + label
        + ", description=" + description
        + ", required=" + required
        + ", requiredErrorText=" + requiredErrorText
        + ", readOnly=" + readOnly
        + ", items=" + items
        + ", className=" + className
        + ", activeWhen=" + activeWhen
        + ", canAddRowWhen=" + canAddRowWhen
        + ", canRemoveRowWhen=" + canRemoveRowWhen
        + ", validations=" + validations
        + ", valueSetId=" + valueSetId
        + ", defaultValue=" + defaultValue
        + ", props=" + props
        + ", additionalProperties=" + additionalProperties
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "FormItem", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FormItem {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String type;
    @javax.annotation.Nullable String view;
    @javax.annotation.Nullable Map<String, String> label = Collections.emptyMap();
    @javax.annotation.Nullable Map<String, String> description = Collections.emptyMap();
    @javax.annotation.Nullable String required;
    @javax.annotation.Nullable Map<String, String> requiredErrorText = Collections.emptyMap();
    @javax.annotation.Nullable Boolean readOnly;
    @javax.annotation.Nullable List<String> items = Collections.emptyList();
    @javax.annotation.Nullable List<String> className = Collections.emptyList();
    @javax.annotation.Nullable String activeWhen;
    @javax.annotation.Nullable String canAddRowWhen;
    @javax.annotation.Nullable String canRemoveRowWhen;
    @javax.annotation.Nullable List<Validation> validations = Collections.emptyList();
    @javax.annotation.Nullable String valueSetId;
    @javax.annotation.Nullable Object defaultValue;
    @javax.annotation.Nullable Map<String, Object> props = null;
    final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty("view")
    public void setView(@Nullable String view) {
      this.view = view;
    }
    @JsonProperty("label")
    public void setLabel(Map<String, String> label) {
      this.label = label;
    }
    @JsonProperty("description")
    public void setDescription(Map<String, String> description) {
      this.description = description;
    }
    @JsonProperty("required")
    public void setRequired(@Nullable String required) {
      this.required = required;
    }
    @JsonProperty("requiredErrorText")
    public void setRequiredErrorText(Map<String, String> requiredErrorText) {
      this.requiredErrorText = requiredErrorText;
    }
    @JsonProperty("readOnly")
    public void setReadOnly(@Nullable Boolean readOnly) {
      this.readOnly = readOnly;
    }
    @JsonProperty("items")
    public void setItems(List<String> items) {
      this.items = items;
    }
    @JsonProperty("className")
    public void setClassName(List<String> className) {
      this.className = className;
    }
    @JsonProperty("activeWhen")
    public void setActiveWhen(@Nullable String activeWhen) {
      this.activeWhen = activeWhen;
    }
    @JsonProperty("canAddRowWhen")
    public void setCanAddRowWhen(@Nullable String canAddRowWhen) {
      this.canAddRowWhen = canAddRowWhen;
    }
    @JsonProperty("canRemoveRowWhen")
    public void setCanRemoveRowWhen(@Nullable String canRemoveRowWhen) {
      this.canRemoveRowWhen = canRemoveRowWhen;
    }
    @JsonProperty("validations")
    public void setValidations(List<Validation> validations) {
      this.validations = validations;
    }
    @JsonProperty("valueSetId")
    public void setValueSetId(@Nullable String valueSetId) {
      this.valueSetId = valueSetId;
    }
    @JsonProperty("defaultValue")
    public void setDefaultValue(@Nullable Object defaultValue) {
      this.defaultValue = defaultValue;
    }
    @JsonProperty("props")
    public void setProps(@Nullable Map<String, Object> props) {
      this.props = props;
    }

    @JsonAnySetter
    public void setAdditionalProperties(String key, Object value) {
      this.additionalProperties.put(key, value);
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getView() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getRequired() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getRequiredErrorText() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getReadOnly() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getItems() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getClassName() { throw new UnsupportedOperationException(); }
    @Override
    public String getActiveWhen() { throw new UnsupportedOperationException(); }
    @Override
    public String getCanAddRowWhen() { throw new UnsupportedOperationException(); }
    @Override
    public String getCanRemoveRowWhen() { throw new UnsupportedOperationException(); }
    @Override
    public List<Validation> getValidations() { throw new UnsupportedOperationException(); }
    @Override
    public String getValueSetId() { throw new UnsupportedOperationException(); }
    @Override
    public Object getDefaultValue() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getProps() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getAdditionalProperties() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFormItem fromJson(Json json) {
    ImmutableFormItem.Builder builder = ImmutableFormItem.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.view != null) {
      builder.view(json.view);
    }
    if (json.label != null) {
      builder.putAllLabel(json.label);
    }
    if (json.description != null) {
      builder.putAllDescription(json.description);
    }
    if (json.required != null) {
      builder.required(json.required);
    }
    if (json.requiredErrorText != null) {
      builder.putAllRequiredErrorText(json.requiredErrorText);
    }
    if (json.readOnly != null) {
      builder.readOnly(json.readOnly);
    }
    if (json.items != null) {
      builder.addAllItems(json.items);
    }
    if (json.className != null) {
      builder.addAllClassName(json.className);
    }
    if (json.activeWhen != null) {
      builder.activeWhen(json.activeWhen);
    }
    if (json.canAddRowWhen != null) {
      builder.canAddRowWhen(json.canAddRowWhen);
    }
    if (json.canRemoveRowWhen != null) {
      builder.canRemoveRowWhen(json.canRemoveRowWhen);
    }
    if (json.validations != null) {
      builder.addAllValidations(json.validations);
    }
    if (json.valueSetId != null) {
      builder.valueSetId(json.valueSetId);
    }
    if (json.defaultValue != null) {
      builder.defaultValue(json.defaultValue);
    }
    if (json.props != null) {
      builder.putAllProps(json.props);
    }
    if (json.additionalProperties != null) {
      builder.putAllAdditionalProperties(json.additionalProperties);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FormItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FormItem instance
   */
  public static ImmutableFormItem copyOf(FormItem instance) {
    if (instance instanceof ImmutableFormItem) {
      return (ImmutableFormItem) instance;
    }
    return ImmutableFormItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFormItem ImmutableFormItem}.
   * <pre>
   * ImmutableFormItem.builder()
   *    .id(String | null) // nullable {@link FormItem#getId() id}
   *    .type(String | null) // nullable {@link FormItem#getType() type}
   *    .view(String | null) // nullable {@link FormItem#getView() view}
   *    .putLabel|putAllLabel(String =&gt; String) // {@link FormItem#getLabel() label} mappings
   *    .putDescription|putAllDescription(String =&gt; String) // {@link FormItem#getDescription() description} mappings
   *    .required(String | null) // nullable {@link FormItem#getRequired() required}
   *    .putRequiredErrorText|putAllRequiredErrorText(String =&gt; String) // {@link FormItem#getRequiredErrorText() requiredErrorText} mappings
   *    .readOnly(Boolean | null) // nullable {@link FormItem#getReadOnly() readOnly}
   *    .addItems|addAllItems(String) // {@link FormItem#getItems() items} elements
   *    .addClassName|addAllClassName(String) // {@link FormItem#getClassName() className} elements
   *    .activeWhen(String | null) // nullable {@link FormItem#getActiveWhen() activeWhen}
   *    .canAddRowWhen(String | null) // nullable {@link FormItem#getCanAddRowWhen() canAddRowWhen}
   *    .canRemoveRowWhen(String | null) // nullable {@link FormItem#getCanRemoveRowWhen() canRemoveRowWhen}
   *    .addValidations|addAllValidations(io.dialob.api.form.Validation) // {@link FormItem#getValidations() validations} elements
   *    .valueSetId(String | null) // nullable {@link FormItem#getValueSetId() valueSetId}
   *    .defaultValue(Object | null) // nullable {@link FormItem#getDefaultValue() defaultValue}
   *    .props(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link FormItem#getProps() props}
   *    .putAdditionalProperties|putAllAdditionalProperties(String =&gt; Object) // {@link FormItem#getAdditionalProperties() additionalProperties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableFormItem builder
   */
  public static ImmutableFormItem.Builder builder() {
    return new ImmutableFormItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFormItem ImmutableFormItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FormItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String type;
    private @javax.annotation.Nullable String view;
    private Map<String, String> label = new LinkedHashMap<String, String>();
    private Map<String, String> description = new LinkedHashMap<String, String>();
    private @javax.annotation.Nullable String required;
    private Map<String, String> requiredErrorText = new LinkedHashMap<String, String>();
    private @javax.annotation.Nullable Boolean readOnly;
    private List<String> items = new ArrayList<String>();
    private List<String> className = new ArrayList<String>();
    private @javax.annotation.Nullable String activeWhen;
    private @javax.annotation.Nullable String canAddRowWhen;
    private @javax.annotation.Nullable String canRemoveRowWhen;
    private List<Validation> validations = new ArrayList<Validation>();
    private @javax.annotation.Nullable String valueSetId;
    private @javax.annotation.Nullable Object defaultValue;
    private Map<String, Object> props = null;
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFormItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableFormItem instance) {
      Objects.requireNonNull(instance, "instance");
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      String viewValue = instance.getView();
      if (viewValue != null) {
        view(viewValue);
      }
      putAllLabel(instance.getLabel());
      putAllDescription(instance.getDescription());
      String requiredValue = instance.getRequired();
      if (requiredValue != null) {
        required(requiredValue);
      }
      putAllRequiredErrorText(instance.getRequiredErrorText());
      Boolean readOnlyValue = instance.getReadOnly();
      if (readOnlyValue != null) {
        readOnly(readOnlyValue);
      }
      addAllItems(instance.getItems());
      addAllClassName(instance.getClassName());
      String activeWhenValue = instance.getActiveWhen();
      if (activeWhenValue != null) {
        activeWhen(activeWhenValue);
      }
      String canAddRowWhenValue = instance.getCanAddRowWhen();
      if (canAddRowWhenValue != null) {
        canAddRowWhen(canAddRowWhenValue);
      }
      String canRemoveRowWhenValue = instance.getCanRemoveRowWhen();
      if (canRemoveRowWhenValue != null) {
        canRemoveRowWhen(canRemoveRowWhenValue);
      }
      addAllValidations(instance.getValidations());
      String valueSetIdValue = instance.getValueSetId();
      if (valueSetIdValue != null) {
        valueSetId(valueSetIdValue);
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      Map<String, Object> propsValue = instance.getProps();
      if (propsValue != null) {
        putAllProps(propsValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code FormItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormItem instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFormItem) {
        return from((ModifiableFormItem) instance);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      String viewValue = instance.getView();
      if (viewValue != null) {
        view(viewValue);
      }
      putAllLabel(instance.getLabel());
      putAllDescription(instance.getDescription());
      String requiredValue = instance.getRequired();
      if (requiredValue != null) {
        required(requiredValue);
      }
      putAllRequiredErrorText(instance.getRequiredErrorText());
      Boolean readOnlyValue = instance.getReadOnly();
      if (readOnlyValue != null) {
        readOnly(readOnlyValue);
      }
      addAllItems(instance.getItems());
      addAllClassName(instance.getClassName());
      String activeWhenValue = instance.getActiveWhen();
      if (activeWhenValue != null) {
        activeWhen(activeWhenValue);
      }
      String canAddRowWhenValue = instance.getCanAddRowWhen();
      if (canAddRowWhenValue != null) {
        canAddRowWhen(canAddRowWhenValue);
      }
      String canRemoveRowWhenValue = instance.getCanRemoveRowWhen();
      if (canRemoveRowWhenValue != null) {
        canRemoveRowWhen(canRemoveRowWhenValue);
      }
      addAllValidations(instance.getValidations());
      String valueSetIdValue = instance.getValueSetId();
      if (valueSetIdValue != null) {
        valueSetId(valueSetIdValue);
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      Map<String, Object> propsValue = instance.getProps();
      if (propsValue != null) {
        putAllProps(propsValue);
      }
      putAllAdditionalProperties(instance.getAdditionalProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = type;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getView() view} attribute.
     * @param view The value for view (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("view")
    public final Builder view(@Nullable String view) {
      this.view = view;
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getLabel() label} map.
     * @param key The key in the label map
     * @param value The associated value in the label map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putLabel(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.label.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getLabel() label} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putLabel(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.label.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getLabel() label} map. Nulls are not permitted
     * @param entries The entries that will be added to the label map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(Map<String, ? extends String> entries) {
      this.label.clear();
      return putAllLabel(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getLabel() label} map. Nulls are not permitted
     * @param entries The entries that will be added to the label map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLabel(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.label.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getDescription() description} map.
     * @param key The key in the description map
     * @param value The associated value in the description map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putDescription(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.description.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getDescription() description} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putDescription(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.description.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getDescription() description} map. Nulls are not permitted
     * @param entries The entries that will be added to the description map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(Map<String, ? extends String> entries) {
      this.description.clear();
      return putAllDescription(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getDescription() description} map. Nulls are not permitted
     * @param entries The entries that will be added to the description map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllDescription(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.description.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getRequired() required} attribute.
     * @param required The value for required (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("required")
    public final Builder required(@Nullable String required) {
      this.required = required;
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getRequiredErrorText() requiredErrorText} map.
     * @param key The key in the requiredErrorText map
     * @param value The associated value in the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putRequiredErrorText(@javax.annotation.Nullable String key, @javax.annotation.Nullable String value) {
      this.requiredErrorText.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putRequiredErrorText(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.requiredErrorText.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entries The entries that will be added to the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requiredErrorText")
    public final Builder requiredErrorText(Map<String, ? extends String> entries) {
      this.requiredErrorText.clear();
      return putAllRequiredErrorText(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getRequiredErrorText() requiredErrorText} map. Nulls are not permitted
     * @param entries The entries that will be added to the requiredErrorText map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllRequiredErrorText(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.requiredErrorText.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getReadOnly() readOnly} attribute.
     * @param readOnly The value for readOnly (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("readOnly")
    public final Builder readOnly(@Nullable Boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }

    /**
     * Adds one element to {@link FormItem#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(@javax.annotation.Nullable String element) {
      this.items.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FormItem#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(String... elements) {
      for (String element : elements) {
        this.items.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormItem#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("items")
    public final Builder items(Iterable<String> elements) {
      this.items.clear();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link FormItem#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllItems(Iterable<String> elements) {
      for (String element : elements) {
        this.items.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link FormItem#getClassName() className} list.
     * @param element A className element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClassName(@javax.annotation.Nullable String element) {
      this.className.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FormItem#getClassName() className} list.
     * @param elements An array of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addClassName(String... elements) {
      for (String element : elements) {
        this.className.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormItem#getClassName() className} list.
     * @param elements An iterable of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("className")
    public final Builder className(Iterable<String> elements) {
      this.className.clear();
      return addAllClassName(elements);
    }

    /**
     * Adds elements to {@link FormItem#getClassName() className} list.
     * @param elements An iterable of className elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllClassName(Iterable<String> elements) {
      for (String element : elements) {
        this.className.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getActiveWhen() activeWhen} attribute.
     * @param activeWhen The value for activeWhen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeWhen")
    public final Builder activeWhen(@Nullable String activeWhen) {
      this.activeWhen = activeWhen;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getCanAddRowWhen() canAddRowWhen} attribute.
     * @param canAddRowWhen The value for canAddRowWhen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("canAddRowWhen")
    public final Builder canAddRowWhen(@Nullable String canAddRowWhen) {
      this.canAddRowWhen = canAddRowWhen;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getCanRemoveRowWhen() canRemoveRowWhen} attribute.
     * @param canRemoveRowWhen The value for canRemoveRowWhen (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("canRemoveRowWhen")
    public final Builder canRemoveRowWhen(@Nullable String canRemoveRowWhen) {
      this.canRemoveRowWhen = canRemoveRowWhen;
      return this;
    }

    /**
     * Adds one element to {@link FormItem#getValidations() validations} list.
     * @param element A validations element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValidations(@javax.annotation.Nullable Validation element) {
      this.validations.add(element);
      return this;
    }

    /**
     * Adds elements to {@link FormItem#getValidations() validations} list.
     * @param elements An array of validations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addValidations(Validation... elements) {
      for (Validation element : elements) {
        this.validations.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link FormItem#getValidations() validations} list.
     * @param elements An iterable of validations elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("validations")
    public final Builder validations(Iterable<? extends Validation> elements) {
      this.validations.clear();
      return addAllValidations(elements);
    }

    /**
     * Adds elements to {@link FormItem#getValidations() validations} list.
     * @param elements An iterable of validations elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllValidations(Iterable<? extends Validation> elements) {
      for (Validation element : elements) {
        this.validations.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getValueSetId() valueSetId} attribute.
     * @param valueSetId The value for valueSetId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("valueSetId")
    public final Builder valueSetId(@Nullable String valueSetId) {
      this.valueSetId = valueSetId;
      return this;
    }

    /**
     * Initializes the value for the {@link FormItem#getDefaultValue() defaultValue} attribute.
     * @param defaultValue The value for defaultValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultValue")
    public final Builder defaultValue(@Nullable Object defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getProps() props} map.
     * @param key The key in the props map
     * @param value The associated value in the props map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProps(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      this.props.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getProps() props} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProps(Map.Entry<String, ? extends Object> entry) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.props.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getProps() props} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("props")
    public final Builder props(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.props = null;
        return this;
      }
      this.props = new LinkedHashMap<String, Object>();
      return putAllProps(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getProps() props} map. Nulls are not permitted
     * @param entries The entries that will be added to the props map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProps(Map<String, ? extends Object> entries) {
      if (this.props == null) {
        this.props = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.props.put(k, v);
      }
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getAdditionalProperties() additionalProperties} map.
     * @param key The key in the additionalProperties map
     * @param value The associated value in the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonAnySetter
    public final Builder putAdditionalProperties(@javax.annotation.Nullable String key, @javax.annotation.Nullable Object value) {
      this.additionalProperties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link FormItem#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.additionalProperties.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link FormItem#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("additionalProperties")
    @JsonInclude
    public final Builder additionalProperties(Map<String, ? extends Object> entries) {
      this.additionalProperties.clear();
      return putAllAdditionalProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link FormItem#getAdditionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries The entries that will be added to the additionalProperties map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.additionalProperties.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFormItem ImmutableFormItem}.
     * @return An immutable instance of FormItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFormItem build() {
      return new ImmutableFormItem(
          id,
          type,
          view,
          createUnmodifiableMap(false, false, label),
          createUnmodifiableMap(false, false, description),
          required,
          createUnmodifiableMap(false, false, requiredErrorText),
          readOnly,
          createUnmodifiableList(true, items),
          createUnmodifiableList(true, className),
          activeWhen,
          canAddRowWhen,
          canRemoveRowWhen,
          createUnmodifiableList(true, validations),
          valueSetId,
          defaultValue,
          props == null ? null : createUnmodifiableMap(false, false, props),
          createUnmodifiableMap(false, false, additionalProperties));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
