package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Variable}.
 * @see ImmutableVariable
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersVariable implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (VariableTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new VariableTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersVariable(Variable)";
  }

  @org.immutables.value.Generated(from = "Variable", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class VariableTypeAdapter extends TypeAdapter<Variable> {
    public final Object defaultValueTypeSample = null;
    public final Boolean contextTypeSample = null;
    public final Boolean publishedTypeSample = null;
    private final TypeAdapter<Object> defaultValueTypeAdapter;
    private final TypeAdapter<Boolean> contextTypeAdapter;
    private final TypeAdapter<Boolean> publishedTypeAdapter;

    VariableTypeAdapter(Gson gson) {
      this.defaultValueTypeAdapter = gson.getAdapter( Object.class);
      this.contextTypeAdapter = gson.getAdapter( Boolean.class);
      this.publishedTypeAdapter = gson.getAdapter( Boolean.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return Variable.class == type.getRawType()
          || ImmutableVariable.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Variable value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeVariable(out, value);
      }
    }

    @Override
    public Variable read(JsonReader in) throws IOException {
      return readVariable(in);
    }

    private void writeVariable(JsonWriter out, Variable instance)
        throws IOException {
      out.beginObject();
      String nameValue = instance.getName();
      if (nameValue != null) {
        out.name("name");
        out.value(nameValue);
      } else if (out.getSerializeNulls()) {
        out.name("name");
        out.nullValue();
      }
      String expressionValue = instance.getExpression();
      if (expressionValue != null) {
        out.name("expression");
        out.value(expressionValue);
      } else if (out.getSerializeNulls()) {
        out.name("expression");
        out.nullValue();
      }
      Object defaultValueValue = instance.getDefaultValue();
      if (defaultValueValue != null) {
        out.name("defaultValue");
        defaultValueTypeAdapter.write(out, defaultValueValue);
      } else if (out.getSerializeNulls()) {
        out.name("defaultValue");
        out.nullValue();
      }
      Boolean contextValue = instance.getContext();
      if (contextValue != null) {
        out.name("context");
        contextTypeAdapter.write(out, contextValue);
      } else if (out.getSerializeNulls()) {
        out.name("context");
        out.nullValue();
      }
      Boolean publishedValue = instance.getPublished();
      if (publishedValue != null) {
        out.name("published");
        publishedTypeAdapter.write(out, publishedValue);
      } else if (out.getSerializeNulls()) {
        out.name("published");
        out.nullValue();
      }
      String contextTypeValue = instance.getContextType();
      if (contextTypeValue != null) {
        out.name("contextType");
        out.value(contextTypeValue);
      } else if (out.getSerializeNulls()) {
        out.name("contextType");
        out.nullValue();
      }
      out.endObject();
    }

    private  Variable readVariable(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableVariable.Builder builder = ImmutableVariable.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'n':
        if ("name".equals(attributeName)) {
          readInName(in, builder);
          return;
        }
        break;
      case 'e':
        if ("expression".equals(attributeName)) {
          readInExpression(in, builder);
          return;
        }
        break;
      case 'd':
        if ("defaultValue".equals(attributeName)) {
          readInDefaultValue(in, builder);
          return;
        }
        break;
      case 'c':
        if ("context".equals(attributeName)) {
          readInContext(in, builder);
          return;
        }
        if ("contextType".equals(attributeName)) {
          readInContextType(in, builder);
          return;
        }
        break;
      case 'p':
        if ("published".equals(attributeName)) {
          readInPublished(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInName(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.name(in.nextString());
      }
    }

    private void readInExpression(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.expression(in.nextString());
      }
    }

    private void readInDefaultValue(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Object value = defaultValueTypeAdapter.read(in);
        builder.defaultValue(value);
      }
    }

    private void readInContext(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = contextTypeAdapter.read(in);
        builder.context(value);
      }
    }

    private void readInPublished(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Boolean value = publishedTypeAdapter.read(in);
        builder.published(value);
      }
    }

    private void readInContextType(JsonReader in, ImmutableVariable.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.contextType(in.nextString());
      }
    }
  }
}
