package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code Validation}.
 * @see ImmutableValidation
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersValidation implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (ValidationTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new ValidationTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersValidation(Validation)";
  }

  @org.immutables.value.Generated(from = "Validation", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class ValidationTypeAdapter extends TypeAdapter<Validation> {

    ValidationTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return Validation.class == type.getRawType()
          || ImmutableValidation.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, Validation value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeValidation(out, value);
      }
    }

    @Override
    public Validation read(JsonReader in) throws IOException {
      return readValidation(in);
    }

    private void writeValidation(JsonWriter out, Validation instance)
        throws IOException {
      out.beginObject();
      Map<String, String> messageMapping = instance.getMessage();
      out.name("message");
      out.beginObject();
      for (Map.Entry<String, String> e : messageMapping.entrySet()) {
        String key = e.getKey();
        out.name(key);
        String value = e.getValue();
        out.value(value);
      }
      out.endObject();
      String ruleValue = instance.getRule();
      if (ruleValue != null) {
        out.name("rule");
        out.value(ruleValue);
      } else if (out.getSerializeNulls()) {
        out.name("rule");
        out.nullValue();
      }
      out.endObject();
    }

    private  Validation readValidation(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableValidation.Builder builder = ImmutableValidation.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableValidation.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'm':
        if ("message".equals(attributeName)) {
          readInMessage(in, builder);
          return;
        }
        break;
      case 'r':
        if ("rule".equals(attributeName)) {
          readInRule(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInMessage(JsonReader in, ImmutableValidation.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        in.beginObject();
        while(in.hasNext()) {
          String rawKey = in.nextName();
          String key = rawKey;
          String value = in.nextString();
          builder.putMessage(key, value);
        }
        in.endObject();
      }
    }

    private void readInRule(JsonReader in, ImmutableValidation.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.rule(in.nextString());
      }
    }
  }
}
