package io.dialob.api.form;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.processing.Generated;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code FormTag}.
 * @see ImmutableFormTag
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "io.dialob.api.form", generator = "Gsons")
public final class GsonAdaptersFormTag implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (FormTagTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new FormTagTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersFormTag(FormTag)";
  }

  @org.immutables.value.Generated(from = "FormTag", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class FormTagTypeAdapter extends TypeAdapter<FormTag> {
    public final Date createdTypeSample = null;
    public final FormTag.Type typeTypeSample = null;
    private final TypeAdapter<Date> createdTypeAdapter;
    private final TypeAdapter<FormTag.Type> typeTypeAdapter;

    FormTagTypeAdapter(Gson gson) {
      this.createdTypeAdapter = gson.getAdapter( Date.class);
      this.typeTypeAdapter = gson.getAdapter( FormTag.Type.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return FormTag.class == type.getRawType()
          || ImmutableFormTag.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, FormTag value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeFormTag(out, value);
      }
    }

    @Override
    public FormTag read(JsonReader in) throws IOException {
      return readFormTag(in);
    }

    private void writeFormTag(JsonWriter out, FormTag instance)
        throws IOException {
      out.beginObject();
      String formNameValue = instance.getFormName();
      if (formNameValue != null) {
        out.name("formName");
        out.value(formNameValue);
      } else if (out.getSerializeNulls()) {
        out.name("formName");
        out.nullValue();
      }
      String nameValue = instance.getName();
      if (nameValue != null) {
        out.name("name");
        out.value(nameValue);
      } else if (out.getSerializeNulls()) {
        out.name("name");
        out.nullValue();
      }
      String refNameValue = instance.getRefName();
      if (refNameValue != null) {
        out.name("refName");
        out.value(refNameValue);
      } else if (out.getSerializeNulls()) {
        out.name("refName");
        out.nullValue();
      }
      Date createdValue = instance.getCreated();
      if (createdValue != null) {
        out.name("created");
        createdTypeAdapter.write(out, createdValue);
      } else if (out.getSerializeNulls()) {
        out.name("created");
        out.nullValue();
      }
      String formIdValue = instance.getFormId();
      if (formIdValue != null) {
        out.name("formId");
        out.value(formIdValue);
      } else if (out.getSerializeNulls()) {
        out.name("formId");
        out.nullValue();
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        out.name("description");
        out.value(descriptionValue);
      } else if (out.getSerializeNulls()) {
        out.name("description");
        out.nullValue();
      }
      out.name("type");
      typeTypeAdapter.write(out, instance.getType());
      out.endObject();
    }

    private  FormTag readFormTag(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableFormTag.Builder builder = ImmutableFormTag.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'f':
        if ("formName".equals(attributeName)) {
          readInFormName(in, builder);
          return;
        }
        if ("formId".equals(attributeName)) {
          readInFormId(in, builder);
          return;
        }
        break;
      case 'n':
        if ("name".equals(attributeName)) {
          readInName(in, builder);
          return;
        }
        break;
      case 'r':
        if ("refName".equals(attributeName)) {
          readInRefName(in, builder);
          return;
        }
        break;
      case 'c':
        if ("created".equals(attributeName)) {
          readInCreated(in, builder);
          return;
        }
        break;
      case 'd':
        if ("description".equals(attributeName)) {
          readInDescription(in, builder);
          return;
        }
        break;
      case 't':
        if ("type".equals(attributeName)) {
          readInType(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInFormName(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.formName(in.nextString());
      }
    }

    private void readInName(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.name(in.nextString());
      }
    }

    private void readInRefName(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.refName(in.nextString());
      }
    }

    private void readInCreated(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        Date value = createdTypeAdapter.read(in);
        builder.created(value);
      }
    }

    private void readInFormId(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.formId(in.nextString());
      }
    }

    private void readInDescription(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.description(in.nextString());
      }
    }

    private void readInType(JsonReader in, ImmutableFormTag.Builder builder)
        throws IOException {
      FormTag.Type value = typeTypeAdapter.read(in);
      builder.type(value);
    }
  }
}
