/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.rest.Response;
import io.dialob.api.rest.ResponseStatus;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Response", generator="Immutables")
@Immutable
public final class ImmutableResponse
implements Response {
    private final Boolean ok;
    private final String error;
    private final String reason;

    private ImmutableResponse(Boolean ok, String error, String reason) {
        this.ok = ok;
        this.error = error;
        this.reason = reason;
    }

    @Override
    @JsonProperty(value="ok")
    public Boolean getOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    public final ImmutableResponse withOk(Boolean value) {
        if (Objects.equals(this.ok, value)) {
            return this;
        }
        return new ImmutableResponse(value, this.error, this.reason);
    }

    public final ImmutableResponse withError(String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableResponse(this.ok, value, this.reason);
    }

    public final ImmutableResponse withReason(String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ImmutableResponse(this.ok, this.error, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResponse && this.equalTo(0, (ImmutableResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableResponse another) {
        return Objects.equals(this.ok, another.ok) && Objects.equals(this.error, another.error) && Objects.equals(this.reason, another.reason);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.reason);
        return h;
    }

    public String toString() {
        return "Response{ok=" + this.ok + ", error=" + this.error + ", reason=" + this.reason + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableResponse fromJson(Json json) {
        Builder builder = ImmutableResponse.builder();
        if (json.ok != null) {
            builder.ok(json.ok);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.reason != null) {
            builder.reason(json.reason);
        }
        return builder.build();
    }

    public static ImmutableResponse copyOf(Response instance) {
        if (instance instanceof ImmutableResponse) {
            return (ImmutableResponse)instance;
        }
        return ImmutableResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Response", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean ok;
        @Nullable
        private String error;
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(Response instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResponseStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Boolean okValue;
            ResponseStatus instance;
            long bits = 0L;
            if (object instanceof Response) {
                String reasonValue;
                String errorValue;
                instance = (Response)object;
                if ((bits & 1L) == 0L) {
                    okValue = instance.getOk();
                    if (okValue != null) {
                        this.ok(okValue);
                    }
                    bits |= 1L;
                }
                if ((errorValue = instance.getError()) != null) {
                    this.error(errorValue);
                }
                if ((reasonValue = instance.getReason()) != null) {
                    this.reason(reasonValue);
                }
            }
            if (object instanceof ResponseStatus) {
                instance = (ResponseStatus)object;
                if ((bits & 1L) == 0L) {
                    okValue = instance.getOk();
                    if (okValue != null) {
                        this.ok(okValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="ok")
        public final Builder ok(Boolean ok) {
            this.ok = ok;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="reason")
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public ImmutableResponse build() {
            return new ImmutableResponse(this.ok, this.error, this.reason);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Response", generator="Immutables")
    static final class Json
    implements Response {
        @Nullable
        Boolean ok;
        @Nullable
        String error;
        @Nullable
        String reason;

        Json() {
        }

        @JsonProperty(value="ok")
        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        @JsonProperty(value="error")
        public void setError(String error) {
            this.error = error;
        }

        @JsonProperty(value="reason")
        public void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public Boolean getOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReason() {
            throw new UnsupportedOperationException();
        }
    }
}

