/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.rest.Errors;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Errors", generator="Immutables")
@Immutable
public final class ImmutableErrors
extends Errors {
    private final Date timestamp;
    private final Integer status;
    private final String error;
    private final String message;
    private final String trace;
    private final String path;
    private final List<Errors.Error> errors;

    private ImmutableErrors(Builder builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.message = builder.message;
        this.trace = builder.trace;
        this.path = builder.path;
        this.errors = builder.errors == null ? null : ImmutableErrors.createUnmodifiableList(true, builder.errors);
        this.timestamp = builder.timestampIsSet() ? builder.timestamp : super.getTimestamp();
    }

    private ImmutableErrors(Date timestamp, Integer status, String error, String message, String trace, String path, List<Errors.Error> errors) {
        this.timestamp = timestamp;
        this.status = status;
        this.error = error;
        this.message = message;
        this.trace = trace;
        this.path = path;
        this.errors = errors;
    }

    @Override
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="status")
    public Integer getStatus() {
        return this.status;
    }

    @Override
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="trace")
    public String getTrace() {
        return this.trace;
    }

    @Override
    @JsonProperty(value="path")
    public String getPath() {
        return this.path;
    }

    @Override
    @JsonProperty(value="errors")
    public List<Errors.Error> getErrors() {
        return this.errors;
    }

    public final ImmutableErrors withTimestamp(Date value) {
        if (this.timestamp == value) {
            return this;
        }
        return new ImmutableErrors(value, this.status, this.error, this.message, this.trace, this.path, this.errors);
    }

    public final ImmutableErrors withStatus(Integer value) {
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableErrors(this.timestamp, value, this.error, this.message, this.trace, this.path, this.errors);
    }

    public final ImmutableErrors withError(String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableErrors(this.timestamp, this.status, value, this.message, this.trace, this.path, this.errors);
    }

    public final ImmutableErrors withMessage(String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableErrors(this.timestamp, this.status, this.error, value, this.trace, this.path, this.errors);
    }

    public final ImmutableErrors withTrace(String value) {
        if (Objects.equals(this.trace, value)) {
            return this;
        }
        return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, value, this.path, this.errors);
    }

    public final ImmutableErrors withPath(String value) {
        if (Objects.equals(this.path, value)) {
            return this;
        }
        return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, value, this.errors);
    }

    public final ImmutableErrors withErrors(Errors.Error ... elements) {
        if (elements == null) {
            return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, null);
        }
        List<Errors.Error> newValue = Arrays.asList(elements) == null ? null : ImmutableErrors.createUnmodifiableList(false, ImmutableErrors.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, newValue);
    }

    public final ImmutableErrors withErrors(Iterable<? extends Errors.Error> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<Errors.Error> newValue = elements == null ? null : ImmutableErrors.createUnmodifiableList(false, ImmutableErrors.createSafeList(elements, true, false));
        return new ImmutableErrors(this.timestamp, this.status, this.error, this.message, this.trace, this.path, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrors && this.equalTo(0, (ImmutableErrors)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrors another) {
        return Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.status, another.status) && Objects.equals(this.error, another.error) && Objects.equals(this.message, another.message) && Objects.equals(this.trace, another.trace) && Objects.equals(this.path, another.path) && Objects.equals(this.errors, another.errors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.trace);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.errors);
        return h;
    }

    public String toString() {
        return "Errors{timestamp=" + this.timestamp + ", status=" + this.status + ", error=" + this.error + ", message=" + this.message + ", trace=" + this.trace + ", path=" + this.path + ", errors=" + this.errors + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrors fromJson(Json json) {
        Builder builder = ImmutableErrors.builder();
        if (json.timestampIsSet) {
            builder.timestamp(json.timestamp);
        }
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.trace != null) {
            builder.trace(json.trace);
        }
        if (json.path != null) {
            builder.path(json.path);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        return builder.build();
    }

    public static ImmutableErrors copyOf(Errors instance) {
        if (instance instanceof ImmutableErrors) {
            return (ImmutableErrors)instance;
        }
        return ImmutableErrors.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Errors", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TIMESTAMP = 1L;
        private long optBits;
        @Nullable
        private Date timestamp;
        @Nullable
        private Integer status;
        @Nullable
        private String error;
        @Nullable
        private String message;
        @Nullable
        private String trace;
        @Nullable
        private String path;
        private List<Errors.Error> errors = null;

        private Builder() {
        }

        public final Builder from(Errors instance) {
            List<Errors.Error> errorsValue;
            String pathValue;
            String traceValue;
            String messageValue;
            String errorValue;
            Integer statusValue;
            Objects.requireNonNull(instance, "instance");
            Date timestampValue = instance.getTimestamp();
            if (timestampValue != null) {
                this.timestamp(timestampValue);
            }
            if ((statusValue = instance.getStatus()) != null) {
                this.status(statusValue);
            }
            if ((errorValue = instance.getError()) != null) {
                this.error(errorValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.message(messageValue);
            }
            if ((traceValue = instance.getTrace()) != null) {
                this.trace(traceValue);
            }
            if ((pathValue = instance.getPath()) != null) {
                this.path(pathValue);
            }
            if ((errorsValue = instance.getErrors()) != null) {
                this.addAllErrors(errorsValue);
            }
            return this;
        }

        @JsonProperty(value="timestamp")
        public final Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="status")
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="trace")
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @JsonProperty(value="path")
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Builder addErrors(Errors.Error element) {
            if (this.errors == null) {
                this.errors = new ArrayList<Errors.Error>();
            }
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder addErrors(Errors.Error ... elements) {
            if (this.errors == null) {
                this.errors = new ArrayList<Errors.Error>();
            }
            for (Errors.Error element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        @JsonProperty(value="errors")
        public final Builder errors(Iterable<? extends Errors.Error> elements) {
            if (elements == null) {
                this.errors = null;
                return this;
            }
            this.errors = new ArrayList<Errors.Error>();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends Errors.Error> elements) {
            Objects.requireNonNull(elements, "errors element");
            if (this.errors == null) {
                this.errors = new ArrayList<Errors.Error>();
            }
            for (Errors.Error error : elements) {
                this.errors.add(Objects.requireNonNull(error, "errors element"));
            }
            return this;
        }

        public ImmutableErrors build() {
            return new ImmutableErrors(this);
        }

        private boolean timestampIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Errors", generator="Immutables")
    static final class Json
    extends Errors {
        @Nullable
        Date timestamp;
        boolean timestampIsSet;
        @Nullable
        Integer status;
        @Nullable
        String error;
        @Nullable
        String message;
        @Nullable
        String trace;
        @Nullable
        String path;
        @Nullable
        List<Errors.Error> errors = null;

        Json() {
        }

        @JsonProperty(value="timestamp")
        public void setTimestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.timestampIsSet = true;
        }

        @JsonProperty(value="status")
        public void setStatus(Integer status) {
            this.status = status;
        }

        @JsonProperty(value="error")
        public void setError(String error) {
            this.error = error;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="trace")
        public void setTrace(String trace) {
            this.trace = trace;
        }

        @JsonProperty(value="path")
        public void setPath(String path) {
            this.path = path;
        }

        @JsonProperty(value="errors")
        public void setErrors(List<Errors.Error> errors) {
            this.errors = errors;
        }

        @Override
        public Date getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStatus() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTrace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Errors.Error> getErrors() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="Errors.Error", generator="Immutables")
    @Immutable
    public static final class Error
    implements Errors.Error {
        private final String code;
        private final String context;
        private final Object rejectedValue;
        private final String error;

        private Error(String code, String context, Object rejectedValue, String error) {
            this.code = code;
            this.context = context;
            this.rejectedValue = rejectedValue;
            this.error = error;
        }

        @Override
        @JsonProperty(value="code")
        public String getCode() {
            return this.code;
        }

        @Override
        @JsonProperty(value="context")
        public String getContext() {
            return this.context;
        }

        @Override
        @JsonProperty(value="rejectedValue")
        public Object getRejectedValue() {
            return this.rejectedValue;
        }

        @Override
        @JsonProperty(value="error")
        public String getError() {
            return this.error;
        }

        public final Error withCode(String value) {
            if (Objects.equals(this.code, value)) {
                return this;
            }
            return new Error(value, this.context, this.rejectedValue, this.error);
        }

        public final Error withContext(String value) {
            if (Objects.equals(this.context, value)) {
                return this;
            }
            return new Error(this.code, value, this.rejectedValue, this.error);
        }

        public final Error withRejectedValue(Object value) {
            if (this.rejectedValue == value) {
                return this;
            }
            return new Error(this.code, this.context, value, this.error);
        }

        public final Error withError(String value) {
            if (Objects.equals(this.error, value)) {
                return this;
            }
            return new Error(this.code, this.context, this.rejectedValue, value);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Error && this.equalTo(0, (Error)another);
        }

        private boolean equalTo(int synthetic, Error another) {
            return Objects.equals(this.code, another.code) && Objects.equals(this.context, another.context) && Objects.equals(this.rejectedValue, another.rejectedValue) && Objects.equals(this.error, another.error);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + Objects.hashCode(this.code);
            h += (h << 5) + Objects.hashCode(this.context);
            h += (h << 5) + Objects.hashCode(this.rejectedValue);
            h += (h << 5) + Objects.hashCode(this.error);
            return h;
        }

        public String toString() {
            return "Error{code=" + this.code + ", context=" + this.context + ", rejectedValue=" + this.rejectedValue + ", error=" + this.error + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static Error fromJson(Json json) {
            Builder builder = Error.builder();
            if (json.code != null) {
                builder.code(json.code);
            }
            if (json.context != null) {
                builder.context(json.context);
            }
            if (json.rejectedValue != null) {
                builder.rejectedValue(json.rejectedValue);
            }
            if (json.error != null) {
                builder.error(json.error);
            }
            return builder.build();
        }

        public static Error copyOf(Errors.Error instance) {
            if (instance instanceof Error) {
                return (Error)instance;
            }
            return Error.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Errors.Error", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            @Nullable
            private String code;
            @Nullable
            private String context;
            @Nullable
            private Object rejectedValue;
            @Nullable
            private String error;

            private Builder() {
            }

            public final Builder from(Errors.Error instance) {
                String errorValue;
                Object rejectedValueValue;
                String contextValue;
                Objects.requireNonNull(instance, "instance");
                String codeValue = instance.getCode();
                if (codeValue != null) {
                    this.code(codeValue);
                }
                if ((contextValue = instance.getContext()) != null) {
                    this.context(contextValue);
                }
                if ((rejectedValueValue = instance.getRejectedValue()) != null) {
                    this.rejectedValue(rejectedValueValue);
                }
                if ((errorValue = instance.getError()) != null) {
                    this.error(errorValue);
                }
                return this;
            }

            @JsonProperty(value="code")
            public final Builder code(String code) {
                this.code = code;
                return this;
            }

            @JsonProperty(value="context")
            public final Builder context(String context) {
                this.context = context;
                return this;
            }

            @JsonProperty(value="rejectedValue")
            public final Builder rejectedValue(Object rejectedValue) {
                this.rejectedValue = rejectedValue;
                return this;
            }

            @JsonProperty(value="error")
            public final Builder error(String error) {
                this.error = error;
                return this;
            }

            public Error build() {
                return new Error(this.code, this.context, this.rejectedValue, this.error);
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="Errors.Error", generator="Immutables")
        static final class Json
        implements Errors.Error {
            @Nullable
            String code;
            @Nullable
            String context;
            @Nullable
            Object rejectedValue;
            @Nullable
            String error;

            Json() {
            }

            @JsonProperty(value="code")
            public void setCode(String code) {
                this.code = code;
            }

            @JsonProperty(value="context")
            public void setContext(String context) {
                this.context = context;
            }

            @JsonProperty(value="rejectedValue")
            public void setRejectedValue(Object rejectedValue) {
                this.rejectedValue = rejectedValue;
            }

            @JsonProperty(value="error")
            public void setError(String error) {
                this.error = error;
            }

            @Override
            public String getCode() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getContext() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object getRejectedValue() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String getError() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

