/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.rest;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.rest.ImmutableMetadata;
import io.dialob.api.rest.Metadata;
import java.io.IOException;
import java.util.Date;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.rest", generator="Gsons")
public final class GsonAdaptersMetadata
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (MetadataTypeAdapter.adapts(type)) {
            return new MetadataTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersMetadata(Metadata)";
    }

    @Generated(from="Metadata", generator="Gsons")
    private static class MetadataTypeAdapter
    extends TypeAdapter<Metadata> {
        public final Date createdTypeSample = null;
        public final Date lastSavedTypeSample = null;
        public final Boolean validTypeSample = null;
        private final TypeAdapter<Date> createdTypeAdapter;
        private final TypeAdapter<Date> lastSavedTypeAdapter;
        private final TypeAdapter<Boolean> validTypeAdapter;

        MetadataTypeAdapter(Gson gson) {
            this.createdTypeAdapter = gson.getAdapter(Date.class);
            this.lastSavedTypeAdapter = gson.getAdapter(Date.class);
            this.validTypeAdapter = gson.getAdapter(Boolean.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Metadata.class == type.getRawType() || ImmutableMetadata.class == type.getRawType();
        }

        public void write(JsonWriter out, Metadata value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeMetadata(out, value);
            }
        }

        public Metadata read(JsonReader in) throws IOException {
            return this.readMetadata(in);
        }

        private void writeMetadata(JsonWriter out, Metadata instance) throws IOException {
            out.beginObject();
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                out.name("description");
                out.value(descriptionValue);
            } else if (out.getSerializeNulls()) {
                out.name("description");
                out.nullValue();
            }
            out.name("label");
            out.value(instance.getLabel());
            Date createdValue = instance.getCreated();
            if (createdValue != null) {
                out.name("created");
                this.createdTypeAdapter.write(out, (Object)createdValue);
            } else if (out.getSerializeNulls()) {
                out.name("created");
                out.nullValue();
            }
            Date lastSavedValue = instance.getLastSaved();
            if (lastSavedValue != null) {
                out.name("lastSaved");
                this.lastSavedTypeAdapter.write(out, (Object)lastSavedValue);
            } else if (out.getSerializeNulls()) {
                out.name("lastSaved");
                out.nullValue();
            }
            Boolean validValue = instance.getValid();
            if (validValue != null) {
                out.name("valid");
                this.validTypeAdapter.write(out, (Object)validValue);
            } else if (out.getSerializeNulls()) {
                out.name("valid");
                out.nullValue();
            }
            out.endObject();
        }

        private Metadata readMetadata(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableMetadata.Builder builder = ImmutableMetadata.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
                case 'l': {
                    if ("label".equals(attributeName)) {
                        this.readInLabel(in, builder);
                        return;
                    }
                    if (!"lastSaved".equals(attributeName)) break;
                    this.readInLastSaved(in, builder);
                    return;
                }
                case 'c': {
                    if (!"created".equals(attributeName)) break;
                    this.readInCreated(in, builder);
                    return;
                }
                case 'v': {
                    if (!"valid".equals(attributeName)) break;
                    this.readInValid(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInDescription(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.description(in.nextString());
            }
        }

        private void readInLabel(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            builder.label(in.nextString());
        }

        private void readInCreated(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.createdTypeAdapter.read(in);
                builder.created(value);
            }
        }

        private void readInLastSaved(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.lastSavedTypeAdapter.read(in);
                builder.lastSaved(value);
            }
        }

        private void readInValid(JsonReader in, ImmutableMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.validTypeAdapter.read(in);
                builder.valid(value);
            }
        }
    }
}

