/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.questionnaire.Answer;
import io.dialob.api.questionnaire.ModifiableAnswer;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Answer", generator="Immutables")
@Immutable
public final class ImmutableAnswer
implements Answer {
    private final String id;
    private final Object value;
    private final String type;
    private final Object acceptedValue;
    private final Date updated;
    private final String userId;

    private ImmutableAnswer(String id, Object value) {
        this.id = id;
        this.value = value;
        this.type = null;
        this.acceptedValue = null;
        this.updated = null;
        this.userId = null;
    }

    private ImmutableAnswer(String id, Object value, String type, Object acceptedValue, Date updated, String userId) {
        this.id = id;
        this.value = value;
        this.type = type;
        this.acceptedValue = acceptedValue;
        this.updated = updated;
        this.userId = userId;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Object getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="acceptedValue")
    public Object getAcceptedValue() {
        return this.acceptedValue;
    }

    @Override
    @JsonProperty(value="updated")
    public Date getUpdated() {
        return this.updated;
    }

    @Override
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public final ImmutableAnswer withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableAnswer(value, this.value, this.type, this.acceptedValue, this.updated, this.userId);
    }

    public final ImmutableAnswer withValue(Object value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableAnswer(this.id, value, this.type, this.acceptedValue, this.updated, this.userId);
    }

    public final ImmutableAnswer withType(String value) {
        if (Objects.equals(this.type, value)) {
            return this;
        }
        return new ImmutableAnswer(this.id, this.value, value, this.acceptedValue, this.updated, this.userId);
    }

    public final ImmutableAnswer withAcceptedValue(Object value) {
        if (this.acceptedValue == value) {
            return this;
        }
        return new ImmutableAnswer(this.id, this.value, this.type, value, this.updated, this.userId);
    }

    public final ImmutableAnswer withUpdated(Date value) {
        if (this.updated == value) {
            return this;
        }
        return new ImmutableAnswer(this.id, this.value, this.type, this.acceptedValue, value, this.userId);
    }

    public final ImmutableAnswer withUserId(String value) {
        if (Objects.equals(this.userId, value)) {
            return this;
        }
        return new ImmutableAnswer(this.id, this.value, this.type, this.acceptedValue, this.updated, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnswer && this.equalTo(0, (ImmutableAnswer)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnswer another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.value, another.value) && Objects.equals(this.type, another.type) && Objects.equals(this.acceptedValue, another.acceptedValue) && Objects.equals(this.updated, another.updated) && Objects.equals(this.userId, another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.type);
        h += (h << 5) + Objects.hashCode(this.acceptedValue);
        h += (h << 5) + Objects.hashCode(this.updated);
        h += (h << 5) + Objects.hashCode(this.userId);
        return h;
    }

    public String toString() {
        return "Answer{id=" + this.id + ", value=" + this.value + ", type=" + this.type + ", acceptedValue=" + this.acceptedValue + ", updated=" + this.updated + ", userId=" + this.userId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnswer fromJson(Json json) {
        Builder builder = ImmutableAnswer.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.acceptedValue != null) {
            builder.acceptedValue(json.acceptedValue);
        }
        if (json.updated != null) {
            builder.updated(json.updated);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        return builder.build();
    }

    public static ImmutableAnswer of(String id, Object value) {
        return new ImmutableAnswer(id, value);
    }

    public static ImmutableAnswer copyOf(Answer instance) {
        if (instance instanceof ImmutableAnswer) {
            return (ImmutableAnswer)instance;
        }
        return ImmutableAnswer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Answer", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private Object value;
        @Nullable
        private String type;
        @Nullable
        private Object acceptedValue;
        @Nullable
        private Date updated;
        @Nullable
        private String userId;

        private Builder() {
        }

        public final Builder from(ModifiableAnswer instance) {
            String userIdValue;
            Date updatedValue;
            Object acceptedValueValue;
            String typeValue;
            Object valueValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.value(valueValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            if ((acceptedValueValue = instance.getAcceptedValue()) != null) {
                this.acceptedValue(acceptedValueValue);
            }
            if ((updatedValue = instance.getUpdated()) != null) {
                this.updated(updatedValue);
            }
            if ((userIdValue = instance.getUserId()) != null) {
                this.userId(userIdValue);
            }
            return this;
        }

        public final Builder from(Answer instance) {
            String userIdValue;
            Date updatedValue;
            Object acceptedValueValue;
            String typeValue;
            Object valueValue;
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableAnswer) {
                return this.from((ModifiableAnswer)instance);
            }
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.value(valueValue);
            }
            if ((typeValue = instance.getType()) != null) {
                this.type(typeValue);
            }
            if ((acceptedValueValue = instance.getAcceptedValue()) != null) {
                this.acceptedValue(acceptedValueValue);
            }
            if ((updatedValue = instance.getUpdated()) != null) {
                this.updated(updatedValue);
            }
            if ((userIdValue = instance.getUserId()) != null) {
                this.userId(userIdValue);
            }
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="value")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        public final Builder value(Object value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="acceptedValue")
        public final Builder acceptedValue(Object acceptedValue) {
            this.acceptedValue = acceptedValue;
            return this;
        }

        @JsonProperty(value="updated")
        public final Builder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        @JsonProperty(value="userId")
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public ImmutableAnswer build() {
            return new ImmutableAnswer(this.id, this.value, this.type, this.acceptedValue, this.updated, this.userId);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Answer", generator="Immutables")
    static final class Json
    implements Answer {
        @Nullable
        String id;
        @Nullable
        Object value;
        @Nullable
        String type;
        @Nullable
        Object acceptedValue;
        @Nullable
        Date updated;
        @Nullable
        String userId;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="value")
        @JsonInclude(value=JsonInclude.Include.ALWAYS)
        public void setValue(Object value) {
            this.value = value;
        }

        @JsonProperty(value="type")
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty(value="acceptedValue")
        public void setAcceptedValue(Object acceptedValue) {
            this.acceptedValue = acceptedValue;
        }

        @JsonProperty(value="updated")
        public void setUpdated(Date updated) {
            this.updated = updated;
        }

        @JsonProperty(value="userId")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getAcceptedValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

