/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.questionnaire.Error;
import io.dialob.api.questionnaire.ImmutableError;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.questionnaire", generator="Gsons")
public final class GsonAdaptersError
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ErrorTypeAdapter.adapts(type)) {
            return new ErrorTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersError(Error)";
    }

    @Generated(from="Error", generator="Gsons")
    private static class ErrorTypeAdapter
    extends TypeAdapter<Error> {
        ErrorTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return Error.class == type.getRawType() || ImmutableError.class == type.getRawType();
        }

        public void write(JsonWriter out, Error value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeError(out, value);
            }
        }

        public Error read(JsonReader in) throws IOException {
            return this.readError(in);
        }

        private void writeError(JsonWriter out, Error instance) throws IOException {
            out.beginObject();
            out.name("id");
            out.value(instance.getId());
            String codeValue = instance.getCode();
            if (codeValue != null) {
                out.name("code");
                out.value(codeValue);
            } else if (out.getSerializeNulls()) {
                out.name("code");
                out.nullValue();
            }
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                out.name("description");
                out.value(descriptionValue);
            } else if (out.getSerializeNulls()) {
                out.name("description");
                out.nullValue();
            }
            out.endObject();
        }

        private Error readError(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableError.Builder builder = ImmutableError.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableError.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'c': {
                    if (!"code".equals(attributeName)) break;
                    this.readInCode(in, builder);
                    return;
                }
                case 'd': {
                    if (!"description".equals(attributeName)) break;
                    this.readInDescription(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableError.Builder builder) throws IOException {
            builder.id(in.nextString());
        }

        private void readInCode(JsonReader in, ImmutableError.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.code(in.nextString());
            }
        }

        private void readInDescription(JsonReader in, ImmutableError.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.description(in.nextString());
            }
        }
    }
}

