/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.questionnaire.ContextValue;
import io.dialob.api.questionnaire.ImmutableContextValue;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.questionnaire", generator="Gsons")
public final class GsonAdaptersContextValue
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ContextValueTypeAdapter.adapts(type)) {
            return new ContextValueTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersContextValue(ContextValue)";
    }

    @Generated(from="ContextValue", generator="Gsons")
    private static class ContextValueTypeAdapter
    extends TypeAdapter<ContextValue> {
        public final Object valueTypeSample = null;
        private final TypeAdapter<Object> valueTypeAdapter;

        ContextValueTypeAdapter(Gson gson) {
            this.valueTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return ContextValue.class == type.getRawType() || ImmutableContextValue.class == type.getRawType();
        }

        public void write(JsonWriter out, ContextValue value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeContextValue(out, value);
            }
        }

        public ContextValue read(JsonReader in) throws IOException {
            return this.readContextValue(in);
        }

        private void writeContextValue(JsonWriter out, ContextValue instance) throws IOException {
            out.beginObject();
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("id");
                out.nullValue();
            }
            Object valueValue = instance.getValue();
            if (valueValue != null) {
                out.name("value");
                this.valueTypeAdapter.write(out, valueValue);
            } else if (out.getSerializeNulls()) {
                out.name("value");
                out.nullValue();
            }
            out.endObject();
        }

        private ContextValue readContextValue(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableContextValue.Builder builder = ImmutableContextValue.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableContextValue.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if (!"id".equals(attributeName)) break;
                    this.readInId(in, builder);
                    return;
                }
                case 'v': {
                    if (!"value".equals(attributeName)) break;
                    this.readInValue(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableContextValue.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInValue(JsonReader in, ImmutableContextValue.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.valueTypeAdapter.read(in);
                builder.value(value);
            }
        }
    }
}

