/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import io.dialob.api.proto.ValueSetEntry;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ValueSetEntry", generator="Immutables")
@Immutable
public final class ImmutableValueSetEntry
implements ValueSetEntry {
    private final String key;
    private final String value;

    private ImmutableValueSetEntry(String key, String value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = value;
    }

    private ImmutableValueSetEntry(ImmutableValueSetEntry original, String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public final ImmutableValueSetEntry withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableValueSetEntry(this, newValue, this.value);
    }

    public final ImmutableValueSetEntry withValue(String value) {
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new ImmutableValueSetEntry(this, this.key, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSetEntry && this.equalTo(0, (ImmutableValueSetEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableValueSetEntry another) {
        return this.key.equals(another.key) && Objects.equals(this.value, another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.value);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ValueSetEntry").omitNullValues().add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableValueSetEntry fromJson(Json json) {
        Builder builder = ImmutableValueSetEntry.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        return builder.build();
    }

    public static ImmutableValueSetEntry of(String key, String value) {
        return new ImmutableValueSetEntry(key, value);
    }

    public static ImmutableValueSetEntry copyOf(ValueSetEntry instance) {
        if (instance instanceof ImmutableValueSetEntry) {
            return (ImmutableValueSetEntry)instance;
        }
        return ImmutableValueSetEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ValueSetEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private String key;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(ValueSetEntry instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            String valueValue = instance.getValue();
            if (valueValue != null) {
                this.value(valueValue);
            }
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public ImmutableValueSetEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSetEntry(null, this.key, this.value);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build ValueSetEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ValueSetEntry", generator="Immutables")
    static final class Json
    implements ValueSetEntry {
        @Nullable
        String key;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

