/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.proto.ImmutableValueSetEntry;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.proto.ValueSetEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ValueSet", generator="Immutables")
@Immutable
public final class ImmutableValueSet
implements ValueSet {
    private final String id;
    private final List<ValueSetEntry> entries;

    private ImmutableValueSet(String id, List<ValueSetEntry> entries) {
        this.id = id;
        this.entries = entries;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="entries")
    public List<ValueSetEntry> getEntries() {
        return this.entries;
    }

    public final ImmutableValueSet withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableValueSet(newValue, this.entries);
    }

    public final ImmutableValueSet withEntries(ValueSetEntry ... elements) {
        List<ValueSetEntry> newValue = ImmutableValueSet.createUnmodifiableList(false, ImmutableValueSet.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableValueSet(this.id, newValue);
    }

    public final ImmutableValueSet withEntries(Iterable<? extends ValueSetEntry> elements) {
        if (this.entries == elements) {
            return this;
        }
        List<ValueSetEntry> newValue = ImmutableValueSet.createUnmodifiableList(false, ImmutableValueSet.createSafeList(elements, true, false));
        return new ImmutableValueSet(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValueSet && this.equalTo(0, (ImmutableValueSet)another);
    }

    private boolean equalTo(int synthetic, ImmutableValueSet another) {
        return this.id.equals(another.id) && this.entries.equals(another.entries);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.entries.hashCode();
        return h;
    }

    public String toString() {
        return "ValueSet{id=" + this.id + ", entries=" + this.entries + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableValueSet fromJson(Json json) {
        Builder builder = ImmutableValueSet.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.entries != null) {
            builder.addAllEntries(json.entries);
        }
        return builder.build();
    }

    public static ImmutableValueSet copyOf(ValueSet instance) {
        if (instance instanceof ImmutableValueSet) {
            return (ImmutableValueSet)instance;
        }
        return ImmutableValueSet.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ValueSet", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private List<ValueSetEntry> entries = new ArrayList<ValueSetEntry>();

        private Builder() {
        }

        public final Builder from(ValueSet instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.addAllEntries(instance.getEntries());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEntries(ValueSetEntry element) {
            element = ImmutableValueSetEntry.copyOf(element);
            this.entries.add(Objects.requireNonNull(element, "entries element"));
            return this;
        }

        public final Builder addEntries(String key, String value) {
            return this.addEntries((ValueSetEntry)ImmutableValueSetEntry.of(key, value));
        }

        public final Builder addEntries(ValueSetEntry ... elements) {
            for (ValueSetEntry element : elements) {
                element = ImmutableValueSetEntry.copyOf(element);
                this.entries.add(Objects.requireNonNull(element, "entries element"));
            }
            return this;
        }

        @JsonProperty(value="entries")
        public final Builder entries(Iterable<? extends ValueSetEntry> elements) {
            this.entries.clear();
            return this.addAllEntries(elements);
        }

        public final Builder addAllEntries(Iterable<? extends ValueSetEntry> elements) {
            for (ValueSetEntry valueSetEntry : elements) {
                ImmutableValueSetEntry immutableValueSetEntry = ImmutableValueSetEntry.copyOf(valueSetEntry);
                this.entries.add(Objects.requireNonNull(immutableValueSetEntry, "entries element"));
            }
            return this;
        }

        public ImmutableValueSet build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableValueSet(this.id, ImmutableValueSet.createUnmodifiableList(true, this.entries));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build ValueSet, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ValueSet", generator="Immutables")
    static final class Json
    implements ValueSet {
        @Nullable
        String id;
        @Nullable
        List<ValueSetEntry> entries = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="entries")
        public void setEntries(List<ValueSetEntry> entries) {
            this.entries = entries;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ValueSetEntry> getEntries() {
            throw new UnsupportedOperationException();
        }
    }
}

