/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.proto;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.proto.Action;
import io.dialob.api.proto.ActionItem;
import io.dialob.api.proto.ValueSet;
import io.dialob.api.questionnaire.Error;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Action", generator="Immutables")
@Immutable
public final class ImmutableAction
implements Action {
    private final Action.Type type;
    private final String id;
    private final String message;
    private final String trace;
    private final ActionItem item;
    private final Error error;
    private final Object answer;
    private final List<String> ids;
    private final Object value;
    private final ValueSet valueSet;
    private final Boolean serverEvent;
    private final String resourceId;

    private ImmutableAction(Action.Type type, String id, String message, String trace, ActionItem item, Error error, Object answer, List<String> ids, Object value, ValueSet valueSet, Boolean serverEvent, String resourceId) {
        this.type = type;
        this.id = id;
        this.message = message;
        this.trace = trace;
        this.item = item;
        this.error = error;
        this.answer = answer;
        this.ids = ids;
        this.value = value;
        this.valueSet = valueSet;
        this.serverEvent = serverEvent;
        this.resourceId = resourceId;
    }

    @Override
    @JsonProperty(value="type")
    public Action.Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty(value="trace")
    public String getTrace() {
        return this.trace;
    }

    @Override
    @JsonProperty(value="item")
    public ActionItem getItem() {
        return this.item;
    }

    @Override
    @JsonProperty(value="error")
    public Error getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="answer")
    public Object getAnswer() {
        return this.answer;
    }

    @Override
    @JsonProperty(value="ids")
    public List<String> getIds() {
        return this.ids;
    }

    @Override
    @JsonProperty(value="value")
    public Object getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="valueSet")
    public ValueSet getValueSet() {
        return this.valueSet;
    }

    @Override
    @JsonProperty(value="serverEvent")
    @JsonIgnore
    public Boolean getServerEvent() {
        return this.serverEvent;
    }

    @Override
    @JsonProperty(value="resourceId")
    @JsonIgnore
    public String getResourceId() {
        return this.resourceId;
    }

    public final ImmutableAction withType(Action.Type value) {
        Action.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableAction(newValue, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableAction(this.type, value, this.message, this.trace, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withMessage(String value) {
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, value, this.trace, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withTrace(String value) {
        if (Objects.equals(this.trace, value)) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, value, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withItem(ActionItem value) {
        if (this.item == value) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, value, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withError(Error value) {
        if (this.error == value) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, value, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withAnswer(Object value) {
        if (this.answer == value) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, value, this.ids, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withIds(String ... elements) {
        if (elements == null) {
            return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, null, this.value, this.valueSet, this.serverEvent, this.resourceId);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableAction.createUnmodifiableList(false, ImmutableAction.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, newValue, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withIds(Iterable<String> elements) {
        if (this.ids == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableAction.createUnmodifiableList(false, ImmutableAction.createSafeList(elements, true, false));
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, newValue, this.value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withValue(Object value) {
        if (this.value == value) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids, value, this.valueSet, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withValueSet(ValueSet value) {
        if (this.valueSet == value) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids, this.value, value, this.serverEvent, this.resourceId);
    }

    public final ImmutableAction withServerEvent(Boolean value) {
        if (Objects.equals(this.serverEvent, value)) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, value, this.resourceId);
    }

    public final ImmutableAction withResourceId(String value) {
        if (Objects.equals(this.resourceId, value)) {
            return this;
        }
        return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids, this.value, this.valueSet, this.serverEvent, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAction && this.equalTo(0, (ImmutableAction)another);
    }

    private boolean equalTo(int synthetic, ImmutableAction another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.message, another.message) && Objects.equals(this.trace, another.trace) && Objects.equals(this.item, another.item) && Objects.equals(this.error, another.error) && Objects.equals(this.answer, another.answer) && Objects.equals(this.ids, another.ids) && Objects.equals(this.value, another.value) && Objects.equals(this.valueSet, another.valueSet) && Objects.equals(this.serverEvent, another.serverEvent) && Objects.equals(this.resourceId, another.resourceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.message);
        h += (h << 5) + Objects.hashCode(this.trace);
        h += (h << 5) + Objects.hashCode(this.item);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.answer);
        h += (h << 5) + Objects.hashCode(this.ids);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.valueSet);
        h += (h << 5) + Objects.hashCode(this.serverEvent);
        h += (h << 5) + Objects.hashCode(this.resourceId);
        return h;
    }

    public String toString() {
        return "Action{type=" + this.type + ", id=" + this.id + ", message=" + this.message + ", trace=" + this.trace + ", item=" + this.item + ", error=" + this.error + ", answer=" + this.answer + ", ids=" + this.ids + ", value=" + this.value + ", valueSet=" + this.valueSet + ", serverEvent=" + this.serverEvent + ", resourceId=" + this.resourceId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAction fromJson(Json json) {
        Builder builder = ImmutableAction.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.message != null) {
            builder.message(json.message);
        }
        if (json.trace != null) {
            builder.trace(json.trace);
        }
        if (json.item != null) {
            builder.item(json.item);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.answer != null) {
            builder.answer(json.answer);
        }
        if (json.ids != null) {
            builder.addAllIds(json.ids);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.valueSet != null) {
            builder.valueSet(json.valueSet);
        }
        if (json.serverEvent != null) {
            builder.serverEvent(json.serverEvent);
        }
        if (json.resourceId != null) {
            builder.resourceId(json.resourceId);
        }
        return builder.build();
    }

    public static ImmutableAction copyOf(Action instance) {
        if (instance instanceof ImmutableAction) {
            return (ImmutableAction)instance;
        }
        return ImmutableAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Action", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private Action.Type type;
        @Nullable
        private String id;
        @Nullable
        private String message;
        @Nullable
        private String trace;
        @Nullable
        private ActionItem item;
        @Nullable
        private Error error;
        @Nullable
        private Object answer;
        private List<String> ids = null;
        @Nullable
        private Object value;
        @Nullable
        private ValueSet valueSet;
        @Nullable
        private Boolean serverEvent;
        @Nullable
        private String resourceId;

        private Builder() {
        }

        public final Builder from(Action instance) {
            String resourceIdValue;
            Boolean serverEventValue;
            ValueSet valueSetValue;
            Object valueValue;
            List<String> idsValue;
            Object answerValue;
            Error errorValue;
            ActionItem itemValue;
            String traceValue;
            String messageValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((messageValue = instance.getMessage()) != null) {
                this.message(messageValue);
            }
            if ((traceValue = instance.getTrace()) != null) {
                this.trace(traceValue);
            }
            if ((itemValue = instance.getItem()) != null) {
                this.item(itemValue);
            }
            if ((errorValue = instance.getError()) != null) {
                this.error(errorValue);
            }
            if ((answerValue = instance.getAnswer()) != null) {
                this.answer(answerValue);
            }
            if ((idsValue = instance.getIds()) != null) {
                this.addAllIds(idsValue);
            }
            if ((valueValue = instance.getValue()) != null) {
                this.value(valueValue);
            }
            if ((valueSetValue = instance.getValueSet()) != null) {
                this.valueSet(valueSetValue);
            }
            if ((serverEventValue = instance.getServerEvent()) != null) {
                this.serverEvent(serverEventValue);
            }
            if ((resourceIdValue = instance.getResourceId()) != null) {
                this.resourceId(resourceIdValue);
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(Action.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="message")
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="trace")
        public final Builder trace(String trace) {
            this.trace = trace;
            return this;
        }

        @JsonProperty(value="item")
        public final Builder item(ActionItem item) {
            this.item = item;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(Error error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="answer")
        public final Builder answer(Object answer) {
            this.answer = answer;
            return this;
        }

        public final Builder addIds(String element) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(Objects.requireNonNull(element, "ids element"));
            return this;
        }

        public final Builder addIds(String ... elements) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        @JsonProperty(value="ids")
        public final Builder ids(Iterable<String> elements) {
            if (elements == null) {
                this.ids = null;
                return this;
            }
            this.ids = new ArrayList<String>();
            return this.addAllIds(elements);
        }

        public final Builder addAllIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "ids element");
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            for (String element : elements) {
                this.ids.add(Objects.requireNonNull(element, "ids element"));
            }
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(Object value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="valueSet")
        public final Builder valueSet(ValueSet valueSet) {
            this.valueSet = valueSet;
            return this;
        }

        @JsonProperty(value="serverEvent")
        @JsonIgnore
        public final Builder serverEvent(Boolean serverEvent) {
            this.serverEvent = serverEvent;
            return this;
        }

        @JsonProperty(value="resourceId")
        @JsonIgnore
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public ImmutableAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAction(this.type, this.id, this.message, this.trace, this.item, this.error, this.answer, this.ids == null ? null : ImmutableAction.createUnmodifiableList(true, this.ids), this.value, this.valueSet, this.serverEvent, this.resourceId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build Action, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Action", generator="Immutables")
    static final class Json
    implements Action {
        @Nullable
        Action.Type type;
        @Nullable
        String id;
        @Nullable
        String message;
        @Nullable
        String trace;
        @Nullable
        ActionItem item;
        @Nullable
        Error error;
        @Nullable
        Object answer;
        @Nullable
        List<String> ids = null;
        @Nullable
        Object value;
        @Nullable
        ValueSet valueSet;
        @Nullable
        Boolean serverEvent;
        @Nullable
        String resourceId;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Action.Type type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="message")
        public void setMessage(String message) {
            this.message = message;
        }

        @JsonProperty(value="trace")
        public void setTrace(String trace) {
            this.trace = trace;
        }

        @JsonProperty(value="item")
        public void setItem(ActionItem item) {
            this.item = item;
        }

        @JsonProperty(value="error")
        public void setError(Error error) {
            this.error = error;
        }

        @JsonProperty(value="answer")
        public void setAnswer(Object answer) {
            this.answer = answer;
        }

        @JsonProperty(value="ids")
        public void setIds(List<String> ids) {
            this.ids = ids;
        }

        @JsonProperty(value="value")
        public void setValue(Object value) {
            this.value = value;
        }

        @JsonProperty(value="valueSet")
        public void setValueSet(ValueSet valueSet) {
            this.valueSet = valueSet;
        }

        @JsonProperty(value="serverEvent")
        @JsonIgnore
        public void setServerEvent(Boolean serverEvent) {
            this.serverEvent = serverEvent;
        }

        @JsonProperty(value="resourceId")
        @JsonIgnore
        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public Action.Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTrace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ActionItem getItem() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Error getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getAnswer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueSet getValueSet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getServerEvent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getResourceId() {
            throw new UnsupportedOperationException();
        }
    }
}

