/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ImmutableFormValueSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormValueSet", generator="Modifiables")
@NotThreadSafe
public final class ModifiableFormValueSet
implements FormValueSet {
    private String id;
    private final ArrayList<FormValueSetEntry> entries = new ArrayList();
    private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

    private ModifiableFormValueSet() {
    }

    public static ModifiableFormValueSet create() {
        return new ModifiableFormValueSet();
    }

    @Override
    @JsonProperty(value="id")
    public final String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="entries")
    public final List<FormValueSetEntry> getEntries() {
        return this.entries;
    }

    @Override
    @JsonProperty(value="additionalProperties")
    @JsonInclude
    public final Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public ModifiableFormValueSet clear() {
        this.id = null;
        this.entries.clear();
        this.additionalProperties.clear();
        return this;
    }

    public ModifiableFormValueSet from(FormValueSet instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableFormValueSet) {
            this.from((ModifiableFormValueSet)instance);
            return this;
        }
        String idValue = instance.getId();
        if (idValue != null) {
            this.setId(idValue);
        }
        this.addAllEntries(instance.getEntries());
        this.putAllAdditionalProperties(instance.getAdditionalProperties());
        return this;
    }

    public ModifiableFormValueSet from(ModifiableFormValueSet instance) {
        Objects.requireNonNull(instance, "instance");
        String idValue = instance.getId();
        if (idValue != null) {
            this.setId(idValue);
        }
        this.addAllEntries(instance.getEntries());
        this.putAllAdditionalProperties(instance.getAdditionalProperties());
        return this;
    }

    public ModifiableFormValueSet setId(String id) {
        this.id = id;
        return this;
    }

    public ModifiableFormValueSet addEntries(FormValueSetEntry element) {
        this.entries.add(element);
        return this;
    }

    public final ModifiableFormValueSet addEntries(FormValueSetEntry ... elements) {
        for (FormValueSetEntry e : elements) {
            this.addEntries(e);
        }
        return this;
    }

    public ModifiableFormValueSet setEntries(Iterable<? extends FormValueSetEntry> elements) {
        this.entries.clear();
        this.addAllEntries(elements);
        return this;
    }

    public ModifiableFormValueSet addAllEntries(Iterable<? extends FormValueSetEntry> elements) {
        for (FormValueSetEntry formValueSetEntry : elements) {
            this.addEntries(formValueSetEntry);
        }
        return this;
    }

    public ModifiableFormValueSet putAdditionalProperties(String key, Object value) {
        this.additionalProperties.put(Objects.requireNonNull(key, "additionalProperties key"), value);
        return this;
    }

    public ModifiableFormValueSet setAdditionalProperties(Map<String, ? extends Object> entries) {
        this.additionalProperties.clear();
        this.putAllAdditionalProperties(entries);
        return this;
    }

    public ModifiableFormValueSet putAllAdditionalProperties(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.additionalProperties.put(Objects.requireNonNull(k, "additionalProperties key"), v);
        }
        return this;
    }

    public final boolean isInitialized() {
        return true;
    }

    public final ImmutableFormValueSet toImmutable() {
        return ImmutableFormValueSet.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableFormValueSet)) {
            return false;
        }
        ModifiableFormValueSet other = (ModifiableFormValueSet)another;
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableFormValueSet another) {
        return Objects.equals(this.id, another.id) && this.entries.equals(another.entries) && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.entries.hashCode();
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return "ModifiableFormValueSet{id=" + this.getId() + ", entries=" + this.getEntries() + ", additionalProperties=" + this.getAdditionalProperties() + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

