/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.FormValueSetEntry;
import io.dialob.api.form.ModifiableFormValueSetEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormValueSetEntry", generator="Immutables")
@Immutable
public final class ImmutableFormValueSetEntry
implements FormValueSetEntry {
    private final String id;
    private final Map<String, String> label;
    private final String when;
    private final Map<String, Object> additionalProperties;

    private ImmutableFormValueSetEntry(String id, Map<String, String> label, String when, Map<String, Object> additionalProperties) {
        this.id = id;
        this.label = label;
        this.when = when;
        this.additionalProperties = additionalProperties;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="label")
    public Map<String, String> getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty(value="when")
    public String getWhen() {
        return this.when;
    }

    @Override
    @JsonProperty(value="additionalProperties")
    @JsonInclude
    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final ImmutableFormValueSetEntry withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableFormValueSetEntry(newValue, this.label, this.when, this.additionalProperties);
    }

    public final ImmutableFormValueSetEntry withLabel(Map<String, ? extends String> entries) {
        if (this.label == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableFormValueSetEntry.createUnmodifiableMap(true, false, entries);
        return new ImmutableFormValueSetEntry(this.id, newValue, this.when, this.additionalProperties);
    }

    public final ImmutableFormValueSetEntry withWhen(String value) {
        if (Objects.equals(this.when, value)) {
            return this;
        }
        return new ImmutableFormValueSetEntry(this.id, this.label, value, this.additionalProperties);
    }

    public final ImmutableFormValueSetEntry withAdditionalProperties(Map<String, ? extends Object> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableFormValueSetEntry.createUnmodifiableMap(false, false, entries);
        return new ImmutableFormValueSetEntry(this.id, this.label, this.when, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormValueSetEntry && this.equalTo(0, (ImmutableFormValueSetEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormValueSetEntry another) {
        return this.id.equals(another.id) && this.label.equals(another.label) && Objects.equals(this.when, another.when) && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + Objects.hashCode(this.when);
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return "FormValueSetEntry{id=" + this.id + ", label=" + this.label + ", when=" + this.when + ", additionalProperties=" + this.additionalProperties + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormValueSetEntry fromJson(Json json) {
        Builder builder = ImmutableFormValueSetEntry.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.label != null) {
            builder.putAllLabel(json.label);
        }
        if (json.when != null) {
            builder.when(json.when);
        }
        if (json.additionalProperties != null) {
            builder.putAllAdditionalProperties(json.additionalProperties);
        }
        return builder.build();
    }

    public static ImmutableFormValueSetEntry copyOf(FormValueSetEntry instance) {
        if (instance instanceof ImmutableFormValueSetEntry) {
            return (ImmutableFormValueSetEntry)instance;
        }
        return ImmutableFormValueSetEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="FormValueSetEntry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private Map<String, String> label = new LinkedHashMap<String, String>();
        @Nullable
        private String when;
        private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        public final Builder from(ModifiableFormValueSetEntry instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.idIsSet()) {
                this.id(instance.getId());
            }
            this.putAllLabel(instance.getLabel());
            String whenValue = instance.getWhen();
            if (whenValue != null) {
                this.when(whenValue);
            }
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        public final Builder from(FormValueSetEntry instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableFormValueSetEntry) {
                return this.from((ModifiableFormValueSetEntry)instance);
            }
            this.id(instance.getId());
            this.putAllLabel(instance.getLabel());
            String whenValue = instance.getWhen();
            if (whenValue != null) {
                this.when(whenValue);
            }
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putLabel(String key, String value) {
            this.label.put(Objects.requireNonNull(key, "label key"), value == null ? Objects.requireNonNull(value, "label value for key: " + key) : value);
            return this;
        }

        public final Builder putLabel(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.label.put(Objects.requireNonNull(k, "label key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "label value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(Map<String, ? extends String> entries) {
            this.label.clear();
            return this.putAllLabel(entries);
        }

        public final Builder putAllLabel(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.label.put(Objects.requireNonNull(k, "label key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "label value for key: " + k) : v);
            }
            return this;
        }

        @JsonProperty(value="when")
        public final Builder when(String when) {
            this.when = when;
            return this;
        }

        @JsonAnySetter
        public final Builder putAdditionalProperties(@Nullable String key, @Nullable Object value) {
            this.additionalProperties.put(key, value);
            return this;
        }

        public final Builder putAdditionalProperties(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.additionalProperties.put(k, v);
            return this;
        }

        @JsonProperty(value="additionalProperties")
        @JsonInclude
        public final Builder additionalProperties(Map<String, ? extends Object> entries) {
            this.additionalProperties.clear();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.additionalProperties.put(k, v);
            }
            return this;
        }

        public ImmutableFormValueSetEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFormValueSetEntry(this.id, ImmutableFormValueSetEntry.createUnmodifiableMap(false, false, this.label), this.when, ImmutableFormValueSetEntry.createUnmodifiableMap(false, false, this.additionalProperties));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build FormValueSetEntry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormValueSetEntry", generator="Immutables")
    static final class Json
    implements FormValueSetEntry {
        @Nullable
        String id;
        @Nullable
        Map<String, String> label = Collections.emptyMap();
        @Nullable
        String when;
        final Map<String, Object> additionalProperties = new HashMap<String, Object>();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="label")
        public void setLabel(Map<String, String> label) {
            this.label = label;
        }

        @JsonProperty(value="when")
        public void setWhen(String when) {
            this.when = when;
        }

        @JsonAnySetter
        public void setAdditionalProperties(String key, Object value) {
            this.additionalProperties.put(key, value);
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWhen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getAdditionalProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

