/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.FormTag;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormTag", generator="Immutables")
@Immutable
public final class ImmutableFormTag
implements FormTag {
    private final String formName;
    private final String name;
    private final String refName;
    private final Date created;
    private final String formId;
    private final String description;
    private final FormTag.Type type;

    private ImmutableFormTag(Builder builder) {
        this.formName = builder.formName;
        this.name = builder.name;
        this.refName = builder.refName;
        this.created = builder.created;
        this.formId = builder.formId;
        this.description = builder.description;
        this.type = builder.typeIsSet() ? builder.type : FormTag.super.getType();
    }

    private ImmutableFormTag(String formName, String name, String refName, Date created, String formId, String description, FormTag.Type type) {
        this.formName = formName;
        this.name = name;
        this.refName = refName;
        this.created = created;
        this.formId = formId;
        this.description = description;
        this.type = type;
    }

    @Override
    @JsonProperty(value="formName")
    public String getFormName() {
        return this.formName;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="refName")
    public String getRefName() {
        return this.refName;
    }

    @Override
    @JsonProperty(value="created")
    public Date getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty(value="formId")
    public String getFormId() {
        return this.formId;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="type")
    public FormTag.Type getType() {
        return this.type;
    }

    public final ImmutableFormTag withFormName(String value) {
        if (Objects.equals(this.formName, value)) {
            return this;
        }
        return new ImmutableFormTag(value, this.name, this.refName, this.created, this.formId, this.description, this.type);
    }

    public final ImmutableFormTag withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new ImmutableFormTag(this.formName, value, this.refName, this.created, this.formId, this.description, this.type);
    }

    public final ImmutableFormTag withRefName(String value) {
        if (Objects.equals(this.refName, value)) {
            return this;
        }
        return new ImmutableFormTag(this.formName, this.name, value, this.created, this.formId, this.description, this.type);
    }

    public final ImmutableFormTag withCreated(Date value) {
        if (this.created == value) {
            return this;
        }
        return new ImmutableFormTag(this.formName, this.name, this.refName, value, this.formId, this.description, this.type);
    }

    public final ImmutableFormTag withFormId(String value) {
        if (Objects.equals(this.formId, value)) {
            return this;
        }
        return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, value, this.description, this.type);
    }

    public final ImmutableFormTag withDescription(String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, this.formId, value, this.type);
    }

    public final ImmutableFormTag withType(FormTag.Type value) {
        FormTag.Type newValue = value;
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableFormTag(this.formName, this.name, this.refName, this.created, this.formId, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormTag && this.equalTo(0, (ImmutableFormTag)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormTag another) {
        return Objects.equals(this.formName, another.formName) && Objects.equals(this.name, another.name) && Objects.equals(this.refName, another.refName) && Objects.equals(this.created, another.created) && Objects.equals(this.formId, another.formId) && Objects.equals(this.description, another.description) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.formName);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.refName);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.formId);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "FormTag{formName=" + this.formName + ", name=" + this.name + ", refName=" + this.refName + ", created=" + this.created + ", formId=" + this.formId + ", description=" + this.description + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormTag fromJson(Json json) {
        Builder builder = ImmutableFormTag.builder();
        if (json.formName != null) {
            builder.formName(json.formName);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.refName != null) {
            builder.refName(json.refName);
        }
        if (json.created != null) {
            builder.created(json.created);
        }
        if (json.formId != null) {
            builder.formId(json.formId);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static ImmutableFormTag copyOf(FormTag instance) {
        if (instance instanceof ImmutableFormTag) {
            return (ImmutableFormTag)instance;
        }
        return ImmutableFormTag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FormTag", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_TYPE = 1L;
        private long optBits;
        @Nullable
        private String formName;
        @Nullable
        private String name;
        @Nullable
        private String refName;
        @Nullable
        private Date created;
        @Nullable
        private String formId;
        @Nullable
        private String description;
        @Nullable
        private FormTag.Type type;

        private Builder() {
        }

        public final Builder from(FormTag instance) {
            String descriptionValue;
            String formIdValue;
            Date createdValue;
            String refNameValue;
            String nameValue;
            Objects.requireNonNull(instance, "instance");
            String formNameValue = instance.getFormName();
            if (formNameValue != null) {
                this.formName(formNameValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            if ((refNameValue = instance.getRefName()) != null) {
                this.refName(refNameValue);
            }
            if ((createdValue = instance.getCreated()) != null) {
                this.created(createdValue);
            }
            if ((formIdValue = instance.getFormId()) != null) {
                this.formId(formIdValue);
            }
            if ((descriptionValue = instance.getDescription()) != null) {
                this.description(descriptionValue);
            }
            this.type(instance.getType());
            return this;
        }

        @JsonProperty(value="formName")
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="refName")
        public final Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        @JsonProperty(value="created")
        public final Builder created(Date created) {
            this.created = created;
            return this;
        }

        @JsonProperty(value="formId")
        public final Builder formId(String formId) {
            this.formId = formId;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(FormTag.Type type) {
            this.type = type;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableFormTag build() {
            return new ImmutableFormTag(this);
        }

        private boolean typeIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormTag", generator="Immutables")
    static final class Json
    implements FormTag {
        @Nullable
        String formName;
        @Nullable
        String name;
        @Nullable
        String refName;
        @Nullable
        Date created;
        @Nullable
        String formId;
        @Nullable
        String description;
        @Nullable
        FormTag.Type type;
        boolean typeIsSet;

        Json() {
        }

        @JsonProperty(value="formName")
        public void setFormName(String formName) {
            this.formName = formName;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="refName")
        public void setRefName(String refName) {
            this.refName = refName;
        }

        @JsonProperty(value="created")
        public void setCreated(Date created) {
            this.created = created;
        }

        @JsonProperty(value="formId")
        public void setFormId(String formId) {
            this.formId = formId;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="type")
        public void setType(FormTag.Type type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @Override
        public String getFormName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRefName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFormId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FormTag.Type getType() {
            throw new UnsupportedOperationException();
        }
    }
}

