/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormPutResponse;
import io.dialob.api.form.FormValidationError;
import io.dialob.api.rest.Response;
import io.dialob.api.rest.ResponseStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FormPutResponse", generator="Immutables")
@Immutable
public final class ImmutableFormPutResponse
implements FormPutResponse {
    private final Boolean ok;
    private final String error;
    private final String reason;
    private final String id;
    private final String rev;
    private final List<FormValidationError> errors;
    private final Form form;

    private ImmutableFormPutResponse(Boolean ok, String error, String reason, String id, String rev, List<FormValidationError> errors, Form form) {
        this.ok = ok;
        this.error = error;
        this.reason = reason;
        this.id = id;
        this.rev = rev;
        this.errors = errors;
        this.form = form;
    }

    @Override
    @JsonProperty(value="ok")
    public Boolean getOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="error")
    public String getError() {
        return this.error;
    }

    @Override
    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @Override
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="rev")
    public String getRev() {
        return this.rev;
    }

    @Override
    @JsonProperty(value="errors")
    public List<FormValidationError> getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty(value="form")
    public Form getForm() {
        return this.form;
    }

    public final ImmutableFormPutResponse withOk(Boolean value) {
        if (Objects.equals(this.ok, value)) {
            return this;
        }
        return new ImmutableFormPutResponse(value, this.error, this.reason, this.id, this.rev, this.errors, this.form);
    }

    public final ImmutableFormPutResponse withError(String value) {
        if (Objects.equals(this.error, value)) {
            return this;
        }
        return new ImmutableFormPutResponse(this.ok, value, this.reason, this.id, this.rev, this.errors, this.form);
    }

    public final ImmutableFormPutResponse withReason(String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new ImmutableFormPutResponse(this.ok, this.error, value, this.id, this.rev, this.errors, this.form);
    }

    public final ImmutableFormPutResponse withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableFormPutResponse(this.ok, this.error, this.reason, value, this.rev, this.errors, this.form);
    }

    public final ImmutableFormPutResponse withRev(String value) {
        if (Objects.equals(this.rev, value)) {
            return this;
        }
        return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, value, this.errors, this.form);
    }

    public final ImmutableFormPutResponse withErrors(FormValidationError ... elements) {
        List<FormValidationError> newValue = ImmutableFormPutResponse.createUnmodifiableList(false, ImmutableFormPutResponse.createSafeList(Arrays.asList(elements), false, false));
        return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, newValue, this.form);
    }

    public final ImmutableFormPutResponse withErrors(Iterable<? extends FormValidationError> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<FormValidationError> newValue = ImmutableFormPutResponse.createUnmodifiableList(false, ImmutableFormPutResponse.createSafeList(elements, false, false));
        return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, newValue, this.form);
    }

    public final ImmutableFormPutResponse withForm(Form value) {
        if (this.form == value) {
            return this;
        }
        return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, this.errors, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFormPutResponse && this.equalTo(0, (ImmutableFormPutResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableFormPutResponse another) {
        return Objects.equals(this.ok, another.ok) && Objects.equals(this.error, another.error) && Objects.equals(this.reason, another.reason) && Objects.equals(this.id, another.id) && Objects.equals(this.rev, another.rev) && this.errors.equals(another.errors) && Objects.equals(this.form, another.form);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.rev);
        h += (h << 5) + this.errors.hashCode();
        h += (h << 5) + Objects.hashCode(this.form);
        return h;
    }

    public String toString() {
        return "FormPutResponse{ok=" + this.ok + ", error=" + this.error + ", reason=" + this.reason + ", id=" + this.id + ", rev=" + this.rev + ", errors=" + this.errors + ", form=" + this.form + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFormPutResponse fromJson(Json json) {
        Builder builder = ImmutableFormPutResponse.builder();
        if (json.ok != null) {
            builder.ok(json.ok);
        }
        if (json.error != null) {
            builder.error(json.error);
        }
        if (json.reason != null) {
            builder.reason(json.reason);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.rev != null) {
            builder.rev(json.rev);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        if (json.form != null) {
            builder.form(json.form);
        }
        return builder.build();
    }

    public static ImmutableFormPutResponse copyOf(FormPutResponse instance) {
        if (instance instanceof ImmutableFormPutResponse) {
            return (ImmutableFormPutResponse)instance;
        }
        return ImmutableFormPutResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="FormPutResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean ok;
        @Nullable
        private String error;
        @Nullable
        private String reason;
        @Nullable
        private String id;
        @Nullable
        private String rev;
        private List<FormValidationError> errors = new ArrayList<FormValidationError>();
        @Nullable
        private Form form;

        private Builder() {
        }

        public final Builder from(Response instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResponseStatus instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormPutResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String reasonValue;
            Boolean okValue;
            ResponseStatus instance;
            long bits = 0L;
            if (object instanceof Response) {
                instance = (Response)object;
                if ((bits & 2L) == 0L) {
                    okValue = instance.getOk();
                    if (okValue != null) {
                        this.ok(okValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String errorValue = instance.getError();
                    if (errorValue != null) {
                        this.error(errorValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    reasonValue = instance.getReason();
                    if (reasonValue != null) {
                        this.reason(reasonValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ResponseStatus) {
                instance = (ResponseStatus)object;
                if ((bits & 2L) == 0L) {
                    okValue = instance.getOk();
                    if (okValue != null) {
                        this.ok(okValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof FormPutResponse) {
                String idValue;
                Form formValue;
                String revValue;
                instance = (FormPutResponse)object;
                if ((bits & 1L) == 0L) {
                    reasonValue = instance.getReason();
                    if (reasonValue != null) {
                        this.reason(reasonValue);
                    }
                    bits |= 1L;
                }
                if ((revValue = instance.getRev()) != null) {
                    this.rev(revValue);
                }
                if ((formValue = instance.getForm()) != null) {
                    this.form(formValue);
                }
                if ((idValue = instance.getId()) != null) {
                    this.id(idValue);
                }
                if ((bits & 2L) == 0L) {
                    Boolean okValue2 = instance.getOk();
                    if (okValue2 != null) {
                        this.ok(okValue2);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    String errorValue = instance.getError();
                    if (errorValue != null) {
                        this.error(errorValue);
                    }
                    bits |= 4L;
                }
                this.addAllErrors(instance.getErrors());
            }
        }

        @JsonProperty(value="ok")
        public final Builder ok(Boolean ok) {
            this.ok = ok;
            return this;
        }

        @JsonProperty(value="error")
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @JsonProperty(value="reason")
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="rev")
        public final Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public final Builder addErrors(@Nullable FormValidationError element) {
            this.errors.add(element);
            return this;
        }

        public final Builder addErrors(FormValidationError ... elements) {
            for (FormValidationError element : elements) {
                this.errors.add(element);
            }
            return this;
        }

        @JsonProperty(value="errors")
        public final Builder errors(Iterable<? extends FormValidationError> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends FormValidationError> elements) {
            for (FormValidationError formValidationError : elements) {
                this.errors.add(formValidationError);
            }
            return this;
        }

        @JsonProperty(value="form")
        public final Builder form(Form form) {
            this.form = form;
            return this;
        }

        public ImmutableFormPutResponse build() {
            return new ImmutableFormPutResponse(this.ok, this.error, this.reason, this.id, this.rev, ImmutableFormPutResponse.createUnmodifiableList(true, this.errors), this.form);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FormPutResponse", generator="Immutables")
    static final class Json
    implements FormPutResponse {
        @Nullable
        Boolean ok;
        @Nullable
        String error;
        @Nullable
        String reason;
        @Nullable
        String id;
        @Nullable
        String rev;
        @Nullable
        List<FormValidationError> errors = Collections.emptyList();
        @Nullable
        Form form;

        Json() {
        }

        @JsonProperty(value="ok")
        public void setOk(Boolean ok) {
            this.ok = ok;
        }

        @JsonProperty(value="error")
        public void setError(String error) {
            this.error = error;
        }

        @JsonProperty(value="reason")
        public void setReason(String reason) {
            this.reason = reason;
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="rev")
        public void setRev(String rev) {
            this.rev = rev;
        }

        @JsonProperty(value="errors")
        public void setErrors(List<FormValidationError> errors) {
            this.errors = errors;
        }

        @JsonProperty(value="form")
        public void setForm(Form form) {
            this.form = form;
        }

        @Override
        public Boolean getOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FormValidationError> getErrors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Form getForm() {
            throw new UnsupportedOperationException();
        }
    }
}

