/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.ModifiableForm;
import io.dialob.api.form.Variable;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(value={"saving", "rules", "updated", "failed", "serviceCalls"})
@Generated(from="Form", generator="Immutables")
@Immutable
public final class ImmutableForm
implements Form {
    private final String id;
    private final String rev;
    private final String name;
    private final Map<String, FormItem> data;
    private final Form.Metadata metadata;
    private final List<Variable> variables;
    private final Map<String, Form> namespaces;
    private final List<FormValueSet> valueSets;
    private final Map<String, String> requiredErrorText;

    private ImmutableForm(String id, String rev, String name, Map<String, FormItem> data, Form.Metadata metadata, List<Variable> variables, Map<String, Form> namespaces, List<FormValueSet> valueSets, Map<String, String> requiredErrorText) {
        this.id = id;
        this.rev = rev;
        this.name = name;
        this.data = data;
        this.metadata = metadata;
        this.variables = variables;
        this.namespaces = namespaces;
        this.valueSets = valueSets;
        this.requiredErrorText = requiredErrorText;
    }

    @Override
    @JsonProperty(value="_id")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="_rev")
    public String getRev() {
        return this.rev;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="data")
    public Map<String, FormItem> getData() {
        return this.data;
    }

    @Override
    @JsonProperty(value="metadata")
    public Form.Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="variables")
    public List<Variable> getVariables() {
        return this.variables;
    }

    @Override
    @JsonProperty(value="namespaces")
    public Map<String, Form> getNamespaces() {
        return this.namespaces;
    }

    @Override
    @JsonProperty(value="valueSets")
    public List<FormValueSet> getValueSets() {
        return this.valueSets;
    }

    @Override
    @JsonProperty(value="requiredErrorText")
    public Map<String, String> getRequiredErrorText() {
        return this.requiredErrorText;
    }

    public final ImmutableForm withId(String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableForm.validate(new ImmutableForm(value, this.rev, this.name, this.data, this.metadata, this.variables, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withRev(String value) {
        if (Objects.equals(this.rev, value)) {
            return this;
        }
        return ImmutableForm.validate(new ImmutableForm(this.id, value, this.name, this.data, this.metadata, this.variables, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withName(String value) {
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, value, this.data, this.metadata, this.variables, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withData(Map<String, ? extends FormItem> entries) {
        if (this.data == entries) {
            return this;
        }
        Map<String, FormItem> newValue = ImmutableForm.createUnmodifiableMap(false, false, entries);
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, newValue, this.metadata, this.variables, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withMetadata(Form.Metadata value) {
        if (this.metadata == value) {
            return this;
        }
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, value, this.variables, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withVariables(Variable ... elements) {
        List<Variable> newValue = ImmutableForm.createUnmodifiableList(false, ImmutableForm.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, newValue, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withVariables(Iterable<? extends Variable> elements) {
        if (this.variables == elements) {
            return this;
        }
        List<Variable> newValue = ImmutableForm.createUnmodifiableList(false, ImmutableForm.createSafeList(elements, false, false));
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, newValue, this.namespaces, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withNamespaces(Map<String, ? extends Form> entries) {
        if (this.namespaces == entries) {
            return this;
        }
        Map<String, Form> newValue = ImmutableForm.createUnmodifiableMap(false, false, entries);
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, this.variables, newValue, this.valueSets, this.requiredErrorText));
    }

    public final ImmutableForm withValueSets(FormValueSet ... elements) {
        List<FormValueSet> newValue = ImmutableForm.createUnmodifiableList(false, ImmutableForm.createSafeList(Arrays.asList(elements), false, false));
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, this.variables, this.namespaces, newValue, this.requiredErrorText));
    }

    public final ImmutableForm withValueSets(Iterable<? extends FormValueSet> elements) {
        if (this.valueSets == elements) {
            return this;
        }
        List<FormValueSet> newValue = ImmutableForm.createUnmodifiableList(false, ImmutableForm.createSafeList(elements, false, false));
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, this.variables, this.namespaces, newValue, this.requiredErrorText));
    }

    public final ImmutableForm withRequiredErrorText(Map<String, ? extends String> entries) {
        if (this.requiredErrorText == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableForm.createUnmodifiableMap(false, false, entries);
        return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, this.data, this.metadata, this.variables, this.namespaces, this.valueSets, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForm && this.equalTo(0, (ImmutableForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableForm another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.rev, another.rev) && Objects.equals(this.name, another.name) && this.data.equals(another.data) && Objects.equals(this.metadata, another.metadata) && this.variables.equals(another.variables) && this.namespaces.equals(another.namespaces) && this.valueSets.equals(another.valueSets) && this.requiredErrorText.equals(another.requiredErrorText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.rev);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.data.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.variables.hashCode();
        h += (h << 5) + this.namespaces.hashCode();
        h += (h << 5) + this.valueSets.hashCode();
        h += (h << 5) + this.requiredErrorText.hashCode();
        return h;
    }

    public String toString() {
        return "Form{id=" + this.id + ", rev=" + this.rev + ", name=" + this.name + ", data=" + this.data + ", metadata=" + this.metadata + ", variables=" + this.variables + ", namespaces=" + this.namespaces + ", valueSets=" + this.valueSets + ", requiredErrorText=" + this.requiredErrorText + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableForm fromJson(Json json) {
        Builder builder = ImmutableForm.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.rev != null) {
            builder.rev(json.rev);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.data != null) {
            builder.putAllData(json.data);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.variables != null) {
            builder.addAllVariables(json.variables);
        }
        if (json.namespaces != null) {
            builder.putAllNamespaces(json.namespaces);
        }
        if (json.valueSets != null) {
            builder.addAllValueSets(json.valueSets);
        }
        if (json.requiredErrorText != null) {
            builder.putAllRequiredErrorText(json.requiredErrorText);
        }
        return builder.build();
    }

    private static ImmutableForm validate(ImmutableForm instance) {
        instance = (ImmutableForm)instance.validate();
        return instance;
    }

    public static ImmutableForm copyOf(Form instance) {
        if (instance instanceof ImmutableForm) {
            return (ImmutableForm)instance;
        }
        return ImmutableForm.builder().from(instance).build();
    }

    private Object readResolve() throws ObjectStreamException {
        return ImmutableForm.validate(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Form", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String id;
        @Nullable
        private String rev;
        @Nullable
        private String name;
        private Map<String, FormItem> data = new LinkedHashMap<String, FormItem>();
        @Nullable
        private Form.Metadata metadata;
        private List<Variable> variables = new ArrayList<Variable>();
        private Map<String, Form> namespaces = new LinkedHashMap<String, Form>();
        private List<FormValueSet> valueSets = new ArrayList<FormValueSet>();
        private Map<String, String> requiredErrorText = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(ModifiableForm instance) {
            String nameValue;
            String revValue;
            Objects.requireNonNull(instance, "instance");
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((revValue = instance.getRev()) != null) {
                this.rev(revValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            this.putAllData(instance.getData());
            Form.Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            this.addAllVariables(instance.getVariables());
            this.putAllNamespaces(instance.getNamespaces());
            this.addAllValueSets(instance.getValueSets());
            this.putAllRequiredErrorText(instance.getRequiredErrorText());
            return this;
        }

        public final Builder from(Form instance) {
            String nameValue;
            String revValue;
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableForm) {
                return this.from((ModifiableForm)instance);
            }
            String idValue = instance.getId();
            if (idValue != null) {
                this.id(idValue);
            }
            if ((revValue = instance.getRev()) != null) {
                this.rev(revValue);
            }
            if ((nameValue = instance.getName()) != null) {
                this.name(nameValue);
            }
            this.putAllData(instance.getData());
            Form.Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                this.metadata(metadataValue);
            }
            this.addAllVariables(instance.getVariables());
            this.putAllNamespaces(instance.getNamespaces());
            this.addAllValueSets(instance.getValueSets());
            this.putAllRequiredErrorText(instance.getRequiredErrorText());
            return this;
        }

        @JsonProperty(value="_id")
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="_rev")
        public final Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder putData(@Nullable String key, @Nullable FormItem value) {
            this.data.put(key, value);
            return this;
        }

        public final Builder putData(Map.Entry<String, ? extends FormItem> entry) {
            String k = entry.getKey();
            FormItem v = entry.getValue();
            this.data.put(k, v);
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(Map<String, ? extends FormItem> entries) {
            this.data.clear();
            return this.putAllData(entries);
        }

        public final Builder putAllData(Map<String, ? extends FormItem> entries) {
            for (Map.Entry<String, ? extends FormItem> e : entries.entrySet()) {
                String k = e.getKey();
                FormItem v = e.getValue();
                this.data.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(Form.Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder addVariables(@Nullable Variable element) {
            this.variables.add(element);
            return this;
        }

        public final Builder addVariables(Variable ... elements) {
            for (Variable element : elements) {
                this.variables.add(element);
            }
            return this;
        }

        @JsonProperty(value="variables")
        public final Builder variables(Iterable<? extends Variable> elements) {
            this.variables.clear();
            return this.addAllVariables(elements);
        }

        public final Builder addAllVariables(Iterable<? extends Variable> elements) {
            for (Variable variable : elements) {
                this.variables.add(variable);
            }
            return this;
        }

        public final Builder putNamespaces(@Nullable String key, @Nullable Form value) {
            this.namespaces.put(key, value);
            return this;
        }

        public final Builder putNamespaces(Map.Entry<String, ? extends Form> entry) {
            String k = entry.getKey();
            Form v = entry.getValue();
            this.namespaces.put(k, v);
            return this;
        }

        @JsonProperty(value="namespaces")
        public final Builder namespaces(Map<String, ? extends Form> entries) {
            this.namespaces.clear();
            return this.putAllNamespaces(entries);
        }

        public final Builder putAllNamespaces(Map<String, ? extends Form> entries) {
            for (Map.Entry<String, ? extends Form> e : entries.entrySet()) {
                String k = e.getKey();
                Form v = e.getValue();
                this.namespaces.put(k, v);
            }
            return this;
        }

        public final Builder addValueSets(@Nullable FormValueSet element) {
            this.valueSets.add(element);
            return this;
        }

        public final Builder addValueSets(FormValueSet ... elements) {
            for (FormValueSet element : elements) {
                this.valueSets.add(element);
            }
            return this;
        }

        @JsonProperty(value="valueSets")
        public final Builder valueSets(Iterable<? extends FormValueSet> elements) {
            this.valueSets.clear();
            return this.addAllValueSets(elements);
        }

        public final Builder addAllValueSets(Iterable<? extends FormValueSet> elements) {
            for (FormValueSet formValueSet : elements) {
                this.valueSets.add(formValueSet);
            }
            return this;
        }

        public final Builder putRequiredErrorText(@Nullable String key, @Nullable String value) {
            this.requiredErrorText.put(key, value);
            return this;
        }

        public final Builder putRequiredErrorText(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.requiredErrorText.put(k, v);
            return this;
        }

        @JsonProperty(value="requiredErrorText")
        public final Builder requiredErrorText(Map<String, ? extends String> entries) {
            this.requiredErrorText.clear();
            return this.putAllRequiredErrorText(entries);
        }

        public final Builder putAllRequiredErrorText(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.requiredErrorText.put(k, v);
            }
            return this;
        }

        public ImmutableForm build() {
            return ImmutableForm.validate(new ImmutableForm(this.id, this.rev, this.name, ImmutableForm.createUnmodifiableMap(false, false, this.data), this.metadata, ImmutableForm.createUnmodifiableList(true, this.variables), ImmutableForm.createUnmodifiableMap(false, false, this.namespaces), ImmutableForm.createUnmodifiableList(true, this.valueSets), ImmutableForm.createUnmodifiableMap(false, false, this.requiredErrorText)));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Form", generator="Immutables")
    static final class Json
    implements Form {
        @Nullable
        String id;
        @Nullable
        String rev;
        @Nullable
        String name;
        @Nullable
        Map<String, FormItem> data = Collections.emptyMap();
        @Nullable
        Form.Metadata metadata;
        @Nullable
        List<Variable> variables = Collections.emptyList();
        @Nullable
        Map<String, Form> namespaces = Collections.emptyMap();
        @Nullable
        List<FormValueSet> valueSets = Collections.emptyList();
        @Nullable
        Map<String, String> requiredErrorText = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="_id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="_rev")
        public void setRev(String rev) {
            this.rev = rev;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="data")
        public void setData(Map<String, FormItem> data) {
            this.data = data;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(Form.Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="variables")
        public void setVariables(List<Variable> variables) {
            this.variables = variables;
        }

        @JsonProperty(value="namespaces")
        public void setNamespaces(Map<String, Form> namespaces) {
            this.namespaces = namespaces;
        }

        @JsonProperty(value="valueSets")
        public void setValueSets(List<FormValueSet> valueSets) {
            this.valueSets = valueSets;
        }

        @JsonProperty(value="requiredErrorText")
        public void setRequiredErrorText(Map<String, String> requiredErrorText) {
            this.requiredErrorText = requiredErrorText;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, FormItem> getData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Form.Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Variable> getVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Form> getNamespaces() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FormValueSet> getValueSets() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getRequiredErrorText() {
            throw new UnsupportedOperationException();
        }
    }
}

