/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.ImmutableFormItem;
import io.dialob.api.form.Validation;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.form", generator="Gsons")
public final class GsonAdaptersFormItem
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (FormItemTypeAdapter.adapts(type)) {
            return new FormItemTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersFormItem(FormItem)";
    }

    @Generated(from="FormItem", generator="Gsons")
    private static class FormItemTypeAdapter
    extends TypeAdapter<FormItem> {
        public final Boolean readOnlyTypeSample = null;
        public final Validation validationsTypeSample = null;
        public final Object defaultValueTypeSample = null;
        public final Object propsSecondaryTypeSample = null;
        private final TypeAdapter<Boolean> readOnlyTypeAdapter;
        private final TypeAdapter<Validation> validationsTypeAdapter;
        private final TypeAdapter<Object> defaultValueTypeAdapter;
        private final TypeAdapter<Object> propsSecondaryTypeAdapter;

        FormItemTypeAdapter(Gson gson) {
            this.readOnlyTypeAdapter = gson.getAdapter(Boolean.class);
            this.validationsTypeAdapter = gson.getAdapter(Validation.class);
            this.defaultValueTypeAdapter = gson.getAdapter(Object.class);
            this.propsSecondaryTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return FormItem.class == type.getRawType() || ImmutableFormItem.class == type.getRawType();
        }

        public void write(JsonWriter out, FormItem value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeFormItem(out, value);
            }
        }

        public FormItem read(JsonReader in) throws IOException {
            return this.readFormItem(in);
        }

        private void writeFormItem(JsonWriter out, FormItem instance) throws IOException {
            out.beginObject();
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("id");
                out.nullValue();
            }
            String typeValue = instance.getType();
            if (typeValue != null) {
                out.name("type");
                out.value(typeValue);
            } else if (out.getSerializeNulls()) {
                out.name("type");
                out.nullValue();
            }
            String viewValue = instance.getView();
            if (viewValue != null) {
                out.name("view");
                out.value(viewValue);
            } else if (out.getSerializeNulls()) {
                out.name("view");
                out.nullValue();
            }
            Map<String, String> labelMapping = instance.getLabel();
            out.name("label");
            out.beginObject();
            for (Map.Entry<String, String> entry : labelMapping.entrySet()) {
                String string = entry.getKey();
                out.name(string);
                String value = entry.getValue();
                out.value(value);
            }
            out.endObject();
            Map<String, String> descriptionMapping = instance.getDescription();
            out.name("description");
            out.beginObject();
            for (Map.Entry<String, String> entry : descriptionMapping.entrySet()) {
                String key = entry.getKey();
                out.name(key);
                String string = entry.getValue();
                out.value(string);
            }
            out.endObject();
            String string = instance.getRequired();
            if (string != null) {
                out.name("required");
                out.value(string);
            } else if (out.getSerializeNulls()) {
                out.name("required");
                out.nullValue();
            }
            Map<String, String> map = instance.getRequiredErrorText();
            out.name("requiredErrorText");
            out.beginObject();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                out.name(key);
                String string2 = (String)entry.getValue();
                out.value(string2);
            }
            out.endObject();
            Boolean readOnlyValue = instance.getReadOnly();
            if (readOnlyValue != null) {
                out.name("readOnly");
                this.readOnlyTypeAdapter.write(out, (Object)readOnlyValue);
            } else if (out.getSerializeNulls()) {
                out.name("readOnly");
                out.nullValue();
            }
            List<String> list = instance.getItems();
            out.name("items");
            out.beginArray();
            for (String string3 : list) {
                out.value(string3);
            }
            out.endArray();
            List<String> classNameElements = instance.getClassName();
            out.name("className");
            out.beginArray();
            for (String e : classNameElements) {
                out.value(e);
            }
            out.endArray();
            String string4 = instance.getActiveWhen();
            if (string4 != null) {
                out.name("activeWhen");
                out.value(string4);
            } else if (out.getSerializeNulls()) {
                out.name("activeWhen");
                out.nullValue();
            }
            List<Validation> validationsElements = instance.getValidations();
            out.name("validations");
            out.beginArray();
            for (Validation e : validationsElements) {
                this.validationsTypeAdapter.write(out, (Object)e);
            }
            out.endArray();
            String valueSetIdValue = instance.getValueSetId();
            if (valueSetIdValue != null) {
                out.name("valueSetId");
                out.value(valueSetIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("valueSetId");
                out.nullValue();
            }
            Object defaultValueValue = instance.getDefaultValue();
            if (defaultValueValue != null) {
                out.name("defaultValue");
                this.defaultValueTypeAdapter.write(out, defaultValueValue);
            } else if (out.getSerializeNulls()) {
                out.name("defaultValue");
                out.nullValue();
            }
            Map<String, Object> propsMapping = instance.getProps();
            if (propsMapping != null) {
                out.name("props");
                out.beginObject();
                for (Map.Entry<String, Object> e : propsMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    Object value = e.getValue();
                    this.propsSecondaryTypeAdapter.write(out, value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("props");
                out.nullValue();
            }
            out.endObject();
        }

        private FormItem readFormItem(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableFormItem.Builder builder = ImmutableFormItem.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'i': {
                    if ("id".equals(attributeName)) {
                        this.readInId(in, builder);
                        return;
                    }
                    if (!"items".equals(attributeName)) break;
                    this.readInItems(in, builder);
                    return;
                }
                case 't': {
                    if (!"type".equals(attributeName)) break;
                    this.readInType(in, builder);
                    return;
                }
                case 'v': {
                    if ("view".equals(attributeName)) {
                        this.readInView(in, builder);
                        return;
                    }
                    if ("validations".equals(attributeName)) {
                        this.readInValidations(in, builder);
                        return;
                    }
                    if (!"valueSetId".equals(attributeName)) break;
                    this.readInValueSetId(in, builder);
                    return;
                }
                case 'l': {
                    if (!"label".equals(attributeName)) break;
                    this.readInLabel(in, builder);
                    return;
                }
                case 'd': {
                    if ("description".equals(attributeName)) {
                        this.readInDescription(in, builder);
                        return;
                    }
                    if (!"defaultValue".equals(attributeName)) break;
                    this.readInDefaultValue(in, builder);
                    return;
                }
                case 'r': {
                    if ("required".equals(attributeName)) {
                        this.readInRequired(in, builder);
                        return;
                    }
                    if ("requiredErrorText".equals(attributeName)) {
                        this.readInRequiredErrorText(in, builder);
                        return;
                    }
                    if (!"readOnly".equals(attributeName)) break;
                    this.readInReadOnly(in, builder);
                    return;
                }
                case 'c': {
                    if (!"className".equals(attributeName)) break;
                    this.readInClassName(in, builder);
                    return;
                }
                case 'a': {
                    if (!"activeWhen".equals(attributeName)) break;
                    this.readInActiveWhen(in, builder);
                    return;
                }
                case 'p': {
                    if (!"props".equals(attributeName)) break;
                    this.readInProps(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInType(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.type(in.nextString());
            }
        }

        private void readInView(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.view(in.nextString());
            }
        }

        private void readInLabel(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putLabel(key, value);
                }
                in.endObject();
            }
        }

        private void readInDescription(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putDescription(key, value);
                }
                in.endObject();
            }
        }

        private void readInRequired(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.required(in.nextString());
            }
        }

        private void readInRequiredErrorText(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putRequiredErrorText(key, value);
                }
                in.endObject();
            }
        }

        private void readInReadOnly(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.readOnlyTypeAdapter.read(in);
                builder.readOnly(value);
            }
        }

        private void readInItems(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addItems(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addItems(in.nextString());
            }
        }

        private void readInClassName(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addClassName(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addClassName(in.nextString());
            }
        }

        private void readInActiveWhen(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.activeWhen(in.nextString());
            }
        }

        private void readInValidations(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Validation value = (Validation)this.validationsTypeAdapter.read(in);
                    builder.addValidations(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Validation value = (Validation)this.validationsTypeAdapter.read(in);
                builder.addValidations(value);
            }
        }

        private void readInValueSetId(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.valueSetId(in.nextString());
            }
        }

        private void readInDefaultValue(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Object value = this.defaultValueTypeAdapter.read(in);
                builder.defaultValue(value);
            }
        }

        private void readInProps(JsonReader in, ImmutableFormItem.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                boolean empty = true;
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Object value = this.propsSecondaryTypeAdapter.read(in);
                    builder.putProps(key, value);
                    empty = false;
                }
                if (empty) {
                    builder.putAllProps(Collections.emptyMap());
                }
                in.endObject();
            }
        }
    }
}

