/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.ImmutableForm;
import io.dialob.api.form.ImmutableFormMetadata;
import io.dialob.api.form.Variable;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.dialob.api.form", generator="Gsons")
public final class GsonAdaptersForm
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (FormTypeAdapter.adapts(type)) {
            return new FormTypeAdapter(gson);
        }
        if (MetadataTypeAdapter.adapts(type)) {
            return new MetadataTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersForm(Form, Metadata)";
    }

    @Generated(from="Form", generator="Gsons")
    private static class FormTypeAdapter
    extends TypeAdapter<Form> {
        public final FormItem dataSecondaryTypeSample = null;
        public final Form.Metadata metadataTypeSample = null;
        public final Variable variablesTypeSample = null;
        public final Form namespacesSecondaryTypeSample = null;
        public final FormValueSet valueSetsTypeSample = null;
        private final TypeAdapter<FormItem> dataSecondaryTypeAdapter;
        private final TypeAdapter<Form.Metadata> metadataTypeAdapter;
        private final TypeAdapter<Variable> variablesTypeAdapter;
        private final TypeAdapter<Form> namespacesSecondaryTypeAdapter;
        private final TypeAdapter<FormValueSet> valueSetsTypeAdapter;

        FormTypeAdapter(Gson gson) {
            this.dataSecondaryTypeAdapter = gson.getAdapter(FormItem.class);
            this.metadataTypeAdapter = gson.getAdapter(Form.Metadata.class);
            this.variablesTypeAdapter = gson.getAdapter(Variable.class);
            this.namespacesSecondaryTypeAdapter = gson.getAdapter(Form.class);
            this.valueSetsTypeAdapter = gson.getAdapter(FormValueSet.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Form.class == type.getRawType() || ImmutableForm.class == type.getRawType();
        }

        public void write(JsonWriter out, Form value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeForm(out, value);
            }
        }

        public Form read(JsonReader in) throws IOException {
            return this.readForm(in);
        }

        private void writeForm(JsonWriter out, Form instance) throws IOException {
            out.beginObject();
            String idValue = instance.getId();
            if (idValue != null) {
                out.name("_id");
                out.value(idValue);
            } else if (out.getSerializeNulls()) {
                out.name("_id");
                out.nullValue();
            }
            String revValue = instance.getRev();
            if (revValue != null) {
                out.name("_rev");
                out.value(revValue);
            } else if (out.getSerializeNulls()) {
                out.name("_rev");
                out.nullValue();
            }
            String nameValue = instance.getName();
            if (nameValue != null) {
                out.name("name");
                out.value(nameValue);
            } else if (out.getSerializeNulls()) {
                out.name("name");
                out.nullValue();
            }
            Map<String, FormItem> dataMapping = instance.getData();
            if (!dataMapping.isEmpty()) {
                out.name("data");
                out.beginObject();
                for (Map.Entry<String, FormItem> e : dataMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    FormItem formItem = e.getValue();
                    this.dataSecondaryTypeAdapter.write(out, (Object)formItem);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("data");
                out.beginObject();
                out.endObject();
            }
            Form.Metadata metadataValue = instance.getMetadata();
            if (metadataValue != null) {
                out.name("metadata");
                this.metadataTypeAdapter.write(out, (Object)metadataValue);
            } else if (out.getSerializeNulls()) {
                out.name("metadata");
                out.nullValue();
            }
            List<Variable> variablesElements = instance.getVariables();
            if (!variablesElements.isEmpty()) {
                out.name("variables");
                out.beginArray();
                for (Variable variable : variablesElements) {
                    this.variablesTypeAdapter.write(out, (Object)variable);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("variables");
                out.beginArray();
                out.endArray();
            }
            Map<String, Form> namespacesMapping = instance.getNamespaces();
            if (!namespacesMapping.isEmpty()) {
                out.name("namespaces");
                out.beginObject();
                for (Map.Entry<String, Form> entry : namespacesMapping.entrySet()) {
                    String key = entry.getKey();
                    out.name(key);
                    Form value = entry.getValue();
                    this.namespacesSecondaryTypeAdapter.write(out, (Object)value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("namespaces");
                out.beginObject();
                out.endObject();
            }
            List<FormValueSet> list = instance.getValueSets();
            if (!list.isEmpty()) {
                out.name("valueSets");
                out.beginArray();
                for (FormValueSet e : list) {
                    this.valueSetsTypeAdapter.write(out, (Object)e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("valueSets");
                out.beginArray();
                out.endArray();
            }
            Map<String, String> map = instance.getRequiredErrorText();
            if (!map.isEmpty()) {
                out.name("requiredErrorText");
                out.beginObject();
                for (Map.Entry<String, String> e : map.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    String value = e.getValue();
                    out.value(value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("requiredErrorText");
                out.beginObject();
                out.endObject();
            }
            out.endObject();
        }

        private Form readForm(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableForm.Builder builder = ImmutableForm.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case '_': {
                    if ("_id".equals(attributeName)) {
                        this.readInId(in, builder);
                        return;
                    }
                    if (!"_rev".equals(attributeName)) break;
                    this.readInRev(in, builder);
                    return;
                }
                case 'n': {
                    if ("name".equals(attributeName)) {
                        this.readInName(in, builder);
                        return;
                    }
                    if (!"namespaces".equals(attributeName)) break;
                    this.readInNamespaces(in, builder);
                    return;
                }
                case 'd': {
                    if (!"data".equals(attributeName)) break;
                    this.readInData(in, builder);
                    return;
                }
                case 'm': {
                    if (!"metadata".equals(attributeName)) break;
                    this.readInMetadata(in, builder);
                    return;
                }
                case 'v': {
                    if ("variables".equals(attributeName)) {
                        this.readInVariables(in, builder);
                        return;
                    }
                    if (!"valueSets".equals(attributeName)) break;
                    this.readInValueSets(in, builder);
                    return;
                }
                case 'r': {
                    if (!"requiredErrorText".equals(attributeName)) break;
                    this.readInRequiredErrorText(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInId(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.id(in.nextString());
            }
        }

        private void readInRev(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.rev(in.nextString());
            }
        }

        private void readInName(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.name(in.nextString());
            }
        }

        private void readInData(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    FormItem value = (FormItem)this.dataSecondaryTypeAdapter.read(in);
                    builder.putData(key, value);
                }
                in.endObject();
            }
        }

        private void readInMetadata(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Form.Metadata value = (Form.Metadata)this.metadataTypeAdapter.read(in);
                builder.metadata(value);
            }
        }

        private void readInVariables(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    Variable value = (Variable)this.variablesTypeAdapter.read(in);
                    builder.addVariables(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Variable value = (Variable)this.variablesTypeAdapter.read(in);
                builder.addVariables(value);
            }
        }

        private void readInNamespaces(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Form value = (Form)this.namespacesSecondaryTypeAdapter.read(in);
                    builder.putNamespaces(key, value);
                }
                in.endObject();
            }
        }

        private void readInValueSets(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    FormValueSet value = (FormValueSet)this.valueSetsTypeAdapter.read(in);
                    builder.addValueSets(value);
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                FormValueSet value = (FormValueSet)this.valueSetsTypeAdapter.read(in);
                builder.addValueSets(value);
            }
        }

        private void readInRequiredErrorText(JsonReader in, ImmutableForm.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putRequiredErrorText(key, value);
                }
                in.endObject();
            }
        }
    }

    @Generated(from="Form.Metadata", generator="Gsons")
    private static class MetadataTypeAdapter
    extends TypeAdapter<Form.Metadata> {
        public final Date createdTypeSample = null;
        public final Date lastSavedTypeSample = null;
        public final Boolean validTypeSample = null;
        public final Object additionalPropertiesSecondaryTypeSample = null;
        private final TypeAdapter<Date> createdTypeAdapter;
        private final TypeAdapter<Date> lastSavedTypeAdapter;
        private final TypeAdapter<Boolean> validTypeAdapter;
        private final TypeAdapter<Object> additionalPropertiesSecondaryTypeAdapter;

        MetadataTypeAdapter(Gson gson) {
            this.createdTypeAdapter = gson.getAdapter(Date.class);
            this.lastSavedTypeAdapter = gson.getAdapter(Date.class);
            this.validTypeAdapter = gson.getAdapter(Boolean.class);
            this.additionalPropertiesSecondaryTypeAdapter = gson.getAdapter(Object.class);
        }

        static boolean adapts(TypeToken<?> type) {
            return Form.Metadata.class == type.getRawType() || ImmutableFormMetadata.class == type.getRawType();
        }

        public void write(JsonWriter out, Form.Metadata value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeMetadata(out, value);
            }
        }

        public Form.Metadata read(JsonReader in) throws IOException {
            return this.readMetadata(in);
        }

        private void writeMetadata(JsonWriter out, Form.Metadata instance) throws IOException {
            out.beginObject();
            String labelValue = instance.getLabel();
            if (labelValue != null) {
                out.name("label");
                out.value(labelValue);
            } else if (out.getSerializeNulls()) {
                out.name("label");
                out.nullValue();
            }
            Date createdValue = instance.getCreated();
            if (createdValue != null) {
                out.name("created");
                this.createdTypeAdapter.write(out, (Object)createdValue);
            } else if (out.getSerializeNulls()) {
                out.name("created");
                out.nullValue();
            }
            Date lastSavedValue = instance.getLastSaved();
            if (lastSavedValue != null) {
                out.name("lastSaved");
                this.lastSavedTypeAdapter.write(out, (Object)lastSavedValue);
            } else if (out.getSerializeNulls()) {
                out.name("lastSaved");
                out.nullValue();
            }
            Boolean validValue = instance.getValid();
            if (validValue != null) {
                out.name("valid");
                this.validTypeAdapter.write(out, (Object)validValue);
            } else if (out.getSerializeNulls()) {
                out.name("valid");
                out.nullValue();
            }
            String creatorValue = instance.getCreator();
            if (creatorValue != null) {
                out.name("creator");
                out.value(creatorValue);
            } else if (out.getSerializeNulls()) {
                out.name("creator");
                out.nullValue();
            }
            String tenantIdValue = instance.getTenantId();
            if (tenantIdValue != null) {
                out.name("tenantId");
                out.value(tenantIdValue);
            } else if (out.getSerializeNulls()) {
                out.name("tenantId");
                out.nullValue();
            }
            String savedByValue = instance.getSavedBy();
            if (savedByValue != null) {
                out.name("savedBy");
                out.value(savedByValue);
            } else if (out.getSerializeNulls()) {
                out.name("savedBy");
                out.nullValue();
            }
            Set<String> labelsElements = instance.getLabels();
            if (!labelsElements.isEmpty()) {
                out.name("labels");
                out.beginArray();
                for (String e : labelsElements) {
                    out.value(e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("labels");
                out.beginArray();
                out.endArray();
            }
            String defaultSubmitUrlValue = instance.getDefaultSubmitUrl();
            if (defaultSubmitUrlValue != null) {
                out.name("defaultSubmitUrl");
                out.value(defaultSubmitUrlValue);
            } else if (out.getSerializeNulls()) {
                out.name("defaultSubmitUrl");
                out.nullValue();
            }
            Set<String> languagesElements = instance.getLanguages();
            if (!languagesElements.isEmpty()) {
                out.name("languages");
                out.beginArray();
                for (String e : languagesElements) {
                    out.value(e);
                }
                out.endArray();
            } else if (out.getSerializeNulls()) {
                out.name("languages");
                out.beginArray();
                out.endArray();
            }
            Map<String, Object> additionalPropertiesMapping = instance.getAdditionalProperties();
            if (!additionalPropertiesMapping.isEmpty()) {
                out.name("additionalProperties");
                out.beginObject();
                for (Map.Entry<String, Object> e : additionalPropertiesMapping.entrySet()) {
                    String key = e.getKey();
                    out.name(key);
                    Object value = e.getValue();
                    this.additionalPropertiesSecondaryTypeAdapter.write(out, value);
                }
                out.endObject();
            } else if (out.getSerializeNulls()) {
                out.name("additionalProperties");
                out.beginObject();
                out.endObject();
            }
            out.endObject();
        }

        private Form.Metadata readMetadata(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableFormMetadata.Builder builder = ImmutableFormMetadata.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'l': {
                    if ("label".equals(attributeName)) {
                        this.readInLabel(in, builder);
                        return;
                    }
                    if ("lastSaved".equals(attributeName)) {
                        this.readInLastSaved(in, builder);
                        return;
                    }
                    if ("labels".equals(attributeName)) {
                        this.readInLabels(in, builder);
                        return;
                    }
                    if (!"languages".equals(attributeName)) break;
                    this.readInLanguages(in, builder);
                    return;
                }
                case 'c': {
                    if ("created".equals(attributeName)) {
                        this.readInCreated(in, builder);
                        return;
                    }
                    if (!"creator".equals(attributeName)) break;
                    this.readInCreator(in, builder);
                    return;
                }
                case 'v': {
                    if (!"valid".equals(attributeName)) break;
                    this.readInValid(in, builder);
                    return;
                }
                case 't': {
                    if (!"tenantId".equals(attributeName)) break;
                    this.readInTenantId(in, builder);
                    return;
                }
                case 's': {
                    if (!"savedBy".equals(attributeName)) break;
                    this.readInSavedBy(in, builder);
                    return;
                }
                case 'd': {
                    if (!"defaultSubmitUrl".equals(attributeName)) break;
                    this.readInDefaultSubmitUrl(in, builder);
                    return;
                }
                case 'a': {
                    if (!"additionalProperties".equals(attributeName)) break;
                    this.readInAdditionalProperties(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInLabel(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.label(in.nextString());
            }
        }

        private void readInCreated(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.createdTypeAdapter.read(in);
                builder.created(value);
            }
        }

        private void readInLastSaved(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Date value = (Date)this.lastSavedTypeAdapter.read(in);
                builder.lastSaved(value);
            }
        }

        private void readInValid(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                Boolean value = (Boolean)this.validTypeAdapter.read(in);
                builder.valid(value);
            }
        }

        private void readInCreator(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.creator(in.nextString());
            }
        }

        private void readInTenantId(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.tenantId(in.nextString());
            }
        }

        private void readInSavedBy(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.savedBy(in.nextString());
            }
        }

        private void readInLabels(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addLabels(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addLabels(in.nextString());
            }
        }

        private void readInDefaultSubmitUrl(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.defaultSubmitUrl(in.nextString());
            }
        }

        private void readInLanguages(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addLanguages(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addLanguages(in.nextString());
            }
        }

        private void readInAdditionalProperties(JsonReader in, ImmutableFormMetadata.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    Object value = this.additionalPropertiesSecondaryTypeAdapter.read(in);
                    builder.putAdditionalProperties(key, value);
                }
                in.endObject();
            }
        }
    }
}

