/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.form;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import io.dialob.api.form.Form;
import io.dialob.api.form.FormItem;
import io.dialob.api.form.FormValueSet;
import io.dialob.api.form.Variable;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Form", generator="Repositories")
@ThreadSafe
public class FormRepository
extends Repositories.Repository<Form> {
    private static final String DOCUMENT_COLLECTION_NAME = "forms";
    private final Serialization serialization = new Serialization(this.codecRegistry(), this.fieldNamingStrategy());
    private final Criteria anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());

    public FormRepository(RepositorySetup configuration) {
        super(configuration, DOCUMENT_COLLECTION_NAME, Form.class);
    }

    public FluentFuture<Integer> insert(Form document) {
        return super.doInsert(ImmutableList.of((Object)document));
    }

    public FluentFuture<Integer> insert(Iterable<? extends Form> documents) {
        return super.doInsert(ImmutableList.copyOf(documents));
    }

    @CheckReturnValue
    public Finder findAll() {
        return this.find(this.criteria());
    }

    @CheckReturnValue
    public Finder find(String jsonCriteria) {
        return new Finder(this, Support.jsonQuery((String)jsonCriteria));
    }

    @CheckReturnValue
    public Finder findById(String id) {
        return this.find(this.criteria().id(id));
    }

    public FluentFuture<Integer> upsert(Form document) {
        Criteria byId = this.criteria().id(document.getId());
        return super.doUpsert((Constraints.ConstraintHost)byId.constraint, (Object)document);
    }

    @CheckReturnValue
    public Finder find(Criteria criteria) {
        return new Finder(this, (Constraints.ConstraintHost)criteria.constraint);
    }

    @CheckReturnValue
    public Updater update(Criteria criteria) {
        return new Updater(this, criteria);
    }

    @CheckReturnValue
    public Indexer index() {
        return new Indexer(this);
    }

    public Criteria criteria() {
        return this.anyCriteria;
    }

    @Beta
    Bson toBson(Criteria criteria) {
        return Support.convertToBson((Constraints.ConstraintHost)criteria.constraint);
    }

    @Generated(from="Form", generator="Repositories")
    private static class Serialization {
        final Encoder<FormItem> dataSecondaryEncoder;
        final Encoder<Form.Metadata> metadataEncoder;
        final Encoder<Variable> variablesEncoder;
        final Encoder<Form> namespacesSecondaryEncoder;
        final Encoder<FormValueSet> valueSetsEncoder;
        final CodecRegistry registry;
        final String idName;
        final String revName;
        final String nameName;
        final String dataName;
        final String metadataName;
        final String variablesName;
        final String namespacesName;
        final String valueSetsName;
        final String requiredErrorTextName;

        Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
            this.registry = registry;
            this.dataSecondaryEncoder = this.registry.get(FormItem.class);
            this.metadataEncoder = this.registry.get(Form.Metadata.class);
            this.variablesEncoder = this.registry.get(Variable.class);
            this.namespacesSecondaryEncoder = this.registry.get(Form.class);
            this.valueSetsEncoder = this.registry.get(FormValueSet.class);
            this.idName = "_id";
            this.revName = "_rev";
            this.nameName = Serialization.translateName(fieldNamingStrategy, "name");
            this.dataName = Serialization.translateName(fieldNamingStrategy, "data");
            this.metadataName = Serialization.translateName(fieldNamingStrategy, "metadata");
            this.variablesName = Serialization.translateName(fieldNamingStrategy, "variables");
            this.namespacesName = Serialization.translateName(fieldNamingStrategy, "namespaces");
            this.valueSetsName = Serialization.translateName(fieldNamingStrategy, "valueSets");
            this.requiredErrorTextName = Serialization.translateName(fieldNamingStrategy, "requiredErrorText");
        }

        private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
            try {
                return fieldNamingStrategy.translateName((Member)FormNamingFields.class.getField(fieldName));
            }
            catch (NoSuchFieldException noSuchField) {
                throw new AssertionError((Object)noSuchField);
            }
        }

        @Generated(from="Form", generator="Repositories")
        static final class FormNamingFields {
            public String id;
            public String rev;
            public String name;
            public Map<String, FormItem> data;
            public Form.Metadata metadata;
            public List<Variable> variables;
            public Map<String, Form> namespaces;
            public List<FormValueSet> valueSets;
            public Map<String, String> requiredErrorText;

            FormNamingFields() {
            }
        }
    }

    @Generated(from="Form", generator="Repositories")
    @Immutable
    public static final class Criteria
    extends Repositories.Criteria {
        private final Constraints.Constraint constraint;
        private final Serialization serialization;

        Criteria(Serialization serialization, Constraints.Constraint constraint) {
            this.constraint = constraint;
            this.serialization = serialization;
        }

        public Criteria id(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, false, Support.writable((Object)value)));
        }

        public Criteria idNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.idName, true, Support.writable((Object)value)));
        }

        public Criteria idIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, wrappedValues));
        }

        public Criteria idIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, false, values));
        }

        public Criteria idNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, wrappedValues));
        }

        public Criteria idNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.idName, true, values));
        }

        public Criteria idStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria idMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, false, pattern));
        }

        public Criteria idNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.idName, true, pattern));
        }

        public Criteria idGreaterThan(String lower) {
            return this.idIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria idLessThan(String upper) {
            return this.idIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria idAtMost(String upperInclusive) {
            return this.idIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria idAtLeast(String lowerInclusive) {
            return this.idIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria idIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, false, Support.writable(range)));
        }

        public Criteria idNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.idName, true, Support.writable(range)));
        }

        public Criteria rev(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.revName, false, Support.writable((Object)value)));
        }

        public Criteria revNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.revName, true, Support.writable((Object)value)));
        }

        public Criteria revIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, false, wrappedValues));
        }

        public Criteria revIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, false, values));
        }

        public Criteria revNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, true, wrappedValues));
        }

        public Criteria revNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.revName, true, values));
        }

        public Criteria revStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria revMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, false, pattern));
        }

        public Criteria revNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.revName, true, pattern));
        }

        public Criteria revGreaterThan(String lower) {
            return this.revIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria revLessThan(String upper) {
            return this.revIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria revAtMost(String upperInclusive) {
            return this.revIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria revAtLeast(String lowerInclusive) {
            return this.revIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria revIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.revName, false, Support.writable(range)));
        }

        public Criteria revNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.revName, true, Support.writable(range)));
        }

        public Criteria name(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nameName, false, Support.writable((Object)value)));
        }

        public Criteria nameNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.nameName, true, Support.writable((Object)value)));
        }

        public Criteria nameIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nameName, false, wrappedValues));
        }

        public Criteria nameIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nameName, false, values));
        }

        public Criteria nameNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nameName, true, wrappedValues));
        }

        public Criteria nameNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.nameName, true, values));
        }

        public Criteria nameStartsWith(String prefix) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.nameName, false, Constraints.prefixPatternOf((String)prefix)));
        }

        public Criteria nameMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.nameName, false, pattern));
        }

        public Criteria nameNotMatches(Pattern pattern) {
            return new Criteria(this.serialization, this.constraint.match(this.serialization.nameName, true, pattern));
        }

        public Criteria nameGreaterThan(String lower) {
            return this.nameIn((Range<String>)Range.greaterThan((Comparable)((Object)lower)));
        }

        public Criteria nameLessThan(String upper) {
            return this.nameIn((Range<String>)Range.lessThan((Comparable)((Object)upper)));
        }

        public Criteria nameAtMost(String upperInclusive) {
            return this.nameIn((Range<String>)Range.atMost((Comparable)((Object)upperInclusive)));
        }

        public Criteria nameAtLeast(String lowerInclusive) {
            return this.nameIn((Range<String>)Range.atLeast((Comparable)((Object)lowerInclusive)));
        }

        public Criteria nameIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.nameName, false, Support.writable(range)));
        }

        public Criteria nameNotIn(Range<String> range) {
            return new Criteria(this.serialization, this.constraint.range(this.serialization.nameName, true, Support.writable(range)));
        }

        public Criteria data(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.dataName, false, Support.writable((Object)value)));
        }

        public Criteria dataNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.dataName, true, Support.writable((Object)value)));
        }

        public Criteria dataIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.dataName, false, wrappedValues));
        }

        public Criteria dataIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.dataName, false, values));
        }

        public Criteria dataNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.dataName, true, wrappedValues));
        }

        public Criteria dataNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.dataName, true, values));
        }

        public Criteria metadata(Form.Metadata value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value)));
        }

        public Criteria metadataNot(Form.Metadata value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.metadataName, true, Support.writable(this.serialization.metadataEncoder, (Object)value)));
        }

        public Criteria metadataIn(Iterable<Form.Metadata> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Form.Metadata value : values) {
                wrappedValues.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, false, wrappedValues));
        }

        public Criteria metadataIn(Form.Metadata first, Form.Metadata second, Form.Metadata ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)first));
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)second));
            for (Form.Metadata value : rest) {
                values.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, false, values));
        }

        public Criteria metadataNotIn(Iterable<Form.Metadata> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Form.Metadata value : values) {
                wrappedValues.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, true, wrappedValues));
        }

        public Criteria metadataNotIn(Form.Metadata first, Form.Metadata second, Form.Metadata ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)first));
            values.add(Support.writable(this.serialization.metadataEncoder, (Object)second));
            for (Form.Metadata value : rest) {
                values.add(Support.writable(this.serialization.metadataEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.metadataName, true, values));
        }

        public Criteria variablesEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variablesName, false, 0));
        }

        public Criteria variablesNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variablesName, true, 0));
        }

        public Criteria variablesSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.variablesName, false, size));
        }

        public Criteria variablesContains(Variable value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.variablesName, false, Support.writable(this.serialization.variablesEncoder, (Object)value)));
        }

        public Criteria variablesContainsAll(Iterable<Variable> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Variable value : values) {
                wrappedValues.add(Support.writable(this.serialization.variablesEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.variablesName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria namespaces(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.namespacesName, false, Support.writable((Object)value)));
        }

        public Criteria namespacesNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.namespacesName, true, Support.writable((Object)value)));
        }

        public Criteria namespacesIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.namespacesName, false, wrappedValues));
        }

        public Criteria namespacesIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.namespacesName, false, values));
        }

        public Criteria namespacesNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.namespacesName, true, wrappedValues));
        }

        public Criteria namespacesNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.namespacesName, true, values));
        }

        public Criteria valueSetsEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, false, 0));
        }

        public Criteria valueSetsNonEmpty() {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, true, 0));
        }

        public Criteria valueSetsSize(int size) {
            return new Criteria(this.serialization, this.constraint.size(this.serialization.valueSetsName, false, size));
        }

        public Criteria valueSetsContains(FormValueSet value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value)));
        }

        public Criteria valueSetsContainsAll(Iterable<FormValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (FormValueSet value : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            }
            return new Criteria(this.serialization, this.constraint.nested(this.serialization.valueSetsName, (Constraints.ConstraintHost)Constraints.nilConstraint().equal("$all", false, wrappedValues)));
        }

        public Criteria requiredErrorText(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.requiredErrorTextName, false, Support.writable((Object)value)));
        }

        public Criteria requiredErrorTextNot(String value) {
            return new Criteria(this.serialization, this.constraint.equal(this.serialization.requiredErrorTextName, true, Support.writable((Object)value)));
        }

        public Criteria requiredErrorTextIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.requiredErrorTextName, false, wrappedValues));
        }

        public Criteria requiredErrorTextIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.requiredErrorTextName, false, values));
        }

        public Criteria requiredErrorTextNotIn(Iterable<String> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (String value : values) {
                wrappedValues.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.requiredErrorTextName, true, wrappedValues));
        }

        public Criteria requiredErrorTextNotIn(String first, String second, String ... rest) {
            ArrayList<Object> values = new ArrayList<Object>(2 + rest.length);
            values.add(Support.writable((Object)first));
            values.add(Support.writable((Object)second));
            for (String value : rest) {
                values.add(Support.writable((Object)value));
            }
            return new Criteria(this.serialization, this.constraint.in(this.serialization.requiredErrorTextName, true, values));
        }

        public Criteria or() {
            return new Criteria(this.serialization, this.constraint.disjunction());
        }

        public Criteria with(Criteria criteria) {
            return new Criteria(this.serialization, (Constraints.Constraint)criteria.constraint.accept((Constraints.ConstraintVisitor)this.constraint));
        }

        public String toString() {
            return "FormRepository.criteria(" + Support.stringify((Constraints.ConstraintHost)this.constraint) + ")";
        }
    }

    @Generated(from="Form", generator="Repositories")
    @NotThreadSafe
    public static final class Finder
    extends Repositories.FinderWithDelete<Form, Finder> {
        private final Serialization serialization;

        private Finder(FormRepository repository, Constraints.ConstraintHost criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria;
            this.serialization = repository.serialization;
        }

        public Finder orderById() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Finder orderByIdDesceding() {
            this.ordering = this.ordering.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Finder orderByRev() {
            this.ordering = this.ordering.equal(this.serialization.revName, false, (Object)1);
            return this;
        }

        public Finder orderByRevDesceding() {
            this.ordering = this.ordering.equal(this.serialization.revName, false, (Object)-1);
            return this;
        }

        public Finder orderByName() {
            this.ordering = this.ordering.equal(this.serialization.nameName, false, (Object)1);
            return this;
        }

        public Finder orderByNameDesceding() {
            this.ordering = this.ordering.equal(this.serialization.nameName, false, (Object)-1);
            return this;
        }

        public Finder orderByData() {
            this.ordering = this.ordering.equal(this.serialization.dataName, false, (Object)1);
            return this;
        }

        public Finder orderByDataDesceding() {
            this.ordering = this.ordering.equal(this.serialization.dataName, false, (Object)-1);
            return this;
        }

        public Finder orderByMetadata() {
            this.ordering = this.ordering.equal(this.serialization.metadataName, false, (Object)1);
            return this;
        }

        public Finder orderByMetadataDesceding() {
            this.ordering = this.ordering.equal(this.serialization.metadataName, false, (Object)-1);
            return this;
        }

        public Finder orderByVariables() {
            this.ordering = this.ordering.equal(this.serialization.variablesName, false, (Object)1);
            return this;
        }

        public Finder orderByVariablesDesceding() {
            this.ordering = this.ordering.equal(this.serialization.variablesName, false, (Object)-1);
            return this;
        }

        public Finder orderByNamespaces() {
            this.ordering = this.ordering.equal(this.serialization.namespacesName, false, (Object)1);
            return this;
        }

        public Finder orderByNamespacesDesceding() {
            this.ordering = this.ordering.equal(this.serialization.namespacesName, false, (Object)-1);
            return this;
        }

        public Finder orderByValueSets() {
            this.ordering = this.ordering.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Finder orderByValueSetsDesceding() {
            this.ordering = this.ordering.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        public Finder orderByRequiredErrorText() {
            this.ordering = this.ordering.equal(this.serialization.requiredErrorTextName, false, (Object)1);
            return this;
        }

        public Finder orderByRequiredErrorTextDesceding() {
            this.ordering = this.ordering.equal(this.serialization.requiredErrorTextName, false, (Object)-1);
            return this;
        }

        public Finder excludeData() {
            this.exclusion = this.exclusion.equal(this.serialization.dataName, false, (Object)-1);
            return this;
        }

        public Finder excludeVariables() {
            this.exclusion = this.exclusion.equal(this.serialization.variablesName, false, (Object)-1);
            return this;
        }

        public Finder excludeNamespaces() {
            this.exclusion = this.exclusion.equal(this.serialization.namespacesName, false, (Object)-1);
            return this;
        }

        public Finder excludeValueSets() {
            this.exclusion = this.exclusion.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        public Finder excludeRequiredErrorText() {
            this.exclusion = this.exclusion.equal(this.serialization.requiredErrorTextName, false, (Object)-1);
            return this;
        }

        @CheckReturnValue
        public Modifier andModifyFirst() {
            return new Modifier((FormRepository)this.repository, this.criteria, this.ordering, this.exclusion);
        }

        @CheckReturnValue
        public Replacer andReplaceFirst(Form document) {
            return new Replacer((FormRepository)this.repository, document, this.criteria, this.ordering);
        }
    }

    @Generated(from="Form", generator="Repositories")
    @NotThreadSafe
    public static final class Updater
    extends Repositories.Updater<Form> {
        private final Serialization serialization;

        private Updater(FormRepository repository, Criteria criteria) {
            super((Repositories.Repository)repository);
            this.criteria = criteria.constraint;
            this.serialization = repository.serialization;
        }

        public Updater setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Updater setRev(String value) {
            this.setFields = this.setFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initRev(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Updater setName(String value) {
            this.setFields = this.setFields.equal(this.serialization.nameName, false, Support.writable((Object)value));
            return this;
        }

        public Updater initName(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nameName, false, Support.writable((Object)value));
            return this;
        }

        public Updater clearData() {
            this.setFields = this.setFields.equal(this.serialization.dataName, false, Support.emptyBsonObject());
            return this;
        }

        public Updater putData(String key, FormItem value) {
            this.setFields = this.setFields.equal(this.serialization.dataName + "." + key, false, Support.writable(this.serialization.dataSecondaryEncoder, (Object)value));
            return this;
        }

        public Updater removeData(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.dataName + "." + key, false, (Object)1);
            return this;
        }

        public Updater setMetadata(Form.Metadata value) {
            this.setFields = this.setFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Updater initMetadata(Form.Metadata value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Updater clearVariables() {
            this.unsetFields = this.unsetFields.equal(this.serialization.variablesName, false, (Object)1);
            return this;
        }

        public Updater removeVariables(Variable value) {
            this.pullFields = this.pullFields.equal(this.serialization.variablesName, false, Support.writable(this.serialization.variablesEncoder, (Object)value));
            return this;
        }

        public Updater addVariables(Variable value) {
            this.pushFields = this.pushFields.equal(this.serialization.variablesName, false, Support.writable(this.serialization.variablesEncoder, (Object)value));
            return this;
        }

        public Updater setVariables(Iterable<? extends Variable> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Variable variable : values) {
                wrappedValues.add(Support.writable(this.serialization.variablesEncoder, (Object)variable));
            }
            this.setFields = this.setFields.equal(this.serialization.variablesName, false, wrappedValues);
            return this;
        }

        public Updater addAllVariables(Iterable<? extends Variable> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Variable variable : values) {
                wrappedValues.add(Support.writable(this.serialization.variablesEncoder, (Object)variable));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.variablesName, false, v);
            return this;
        }

        public Updater clearNamespaces() {
            this.setFields = this.setFields.equal(this.serialization.namespacesName, false, Support.emptyBsonObject());
            return this;
        }

        public Updater putNamespaces(String key, Form value) {
            this.setFields = this.setFields.equal(this.serialization.namespacesName + "." + key, false, Support.writable(this.serialization.namespacesSecondaryEncoder, (Object)value));
            return this;
        }

        public Updater removeNamespaces(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.namespacesName + "." + key, false, (Object)1);
            return this;
        }

        public Updater clearValueSets() {
            this.unsetFields = this.unsetFields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Updater removeValueSets(FormValueSet value) {
            this.pullFields = this.pullFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Updater addValueSets(FormValueSet value) {
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Updater setValueSets(Iterable<? extends FormValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (FormValueSet formValueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)formValueSet));
            }
            this.setFields = this.setFields.equal(this.serialization.valueSetsName, false, wrappedValues);
            return this;
        }

        public Updater addAllValueSets(Iterable<? extends FormValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (FormValueSet formValueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)formValueSet));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, v);
            return this;
        }

        public Updater clearRequiredErrorText() {
            this.setFields = this.setFields.equal(this.serialization.requiredErrorTextName, false, Support.emptyBsonObject());
            return this;
        }

        public Updater putRequiredErrorText(String key, String value) {
            this.setFields = this.setFields.equal(this.serialization.requiredErrorTextName + "." + key, false, Support.writable((Object)value));
            return this;
        }

        public Updater removeRequiredErrorText(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.requiredErrorTextName + "." + key, false, (Object)1);
            return this;
        }
    }

    @Generated(from="Form", generator="Repositories")
    @NotThreadSafe
    public static final class Indexer
    extends Repositories.Indexer<Form, Indexer> {
        private final Serialization serialization;

        private Indexer(FormRepository repository) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
        }

        public Indexer withId() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)1);
            return this;
        }

        public Indexer withIdDesceding() {
            this.fields = this.fields.equal(this.serialization.idName, false, (Object)-1);
            return this;
        }

        public Indexer withRev() {
            this.fields = this.fields.equal(this.serialization.revName, false, (Object)1);
            return this;
        }

        public Indexer withRevDesceding() {
            this.fields = this.fields.equal(this.serialization.revName, false, (Object)-1);
            return this;
        }

        public Indexer withName() {
            this.fields = this.fields.equal(this.serialization.nameName, false, (Object)1);
            return this;
        }

        public Indexer withNameDesceding() {
            this.fields = this.fields.equal(this.serialization.nameName, false, (Object)-1);
            return this;
        }

        public Indexer withData() {
            this.fields = this.fields.equal(this.serialization.dataName, false, (Object)1);
            return this;
        }

        public Indexer withDataDesceding() {
            this.fields = this.fields.equal(this.serialization.dataName, false, (Object)-1);
            return this;
        }

        public Indexer withMetadata() {
            this.fields = this.fields.equal(this.serialization.metadataName, false, (Object)1);
            return this;
        }

        public Indexer withMetadataDesceding() {
            this.fields = this.fields.equal(this.serialization.metadataName, false, (Object)-1);
            return this;
        }

        public Indexer withVariables() {
            this.fields = this.fields.equal(this.serialization.variablesName, false, (Object)1);
            return this;
        }

        public Indexer withVariablesDesceding() {
            this.fields = this.fields.equal(this.serialization.variablesName, false, (Object)-1);
            return this;
        }

        public Indexer withNamespaces() {
            this.fields = this.fields.equal(this.serialization.namespacesName, false, (Object)1);
            return this;
        }

        public Indexer withNamespacesDesceding() {
            this.fields = this.fields.equal(this.serialization.namespacesName, false, (Object)-1);
            return this;
        }

        public Indexer withValueSets() {
            this.fields = this.fields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Indexer withValueSetsDesceding() {
            this.fields = this.fields.equal(this.serialization.valueSetsName, false, (Object)-1);
            return this;
        }

        public Indexer withRequiredErrorText() {
            this.fields = this.fields.equal(this.serialization.requiredErrorTextName, false, (Object)1);
            return this;
        }

        public Indexer withRequiredErrorTextDesceding() {
            this.fields = this.fields.equal(this.serialization.requiredErrorTextName, false, (Object)-1);
            return this;
        }
    }

    @Generated(from="Form", generator="Repositories")
    @NotThreadSafe
    public static final class Replacer
    extends Repositories.Replacer<Form, Replacer> {
        protected Replacer(FormRepository repository, Form document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
            super((Repositories.Repository)repository, (Object)document, criteria, ordering);
        }
    }

    @Generated(from="Form", generator="Repositories")
    @NotThreadSafe
    public static final class Modifier
    extends Repositories.Modifier<Form, Modifier> {
        private final Serialization serialization;

        private Modifier(FormRepository repository, Constraints.ConstraintHost criteria, Constraints.Constraint ordering, Constraints.Constraint exclusion) {
            super((Repositories.Repository)repository);
            this.serialization = repository.serialization;
            this.criteria = criteria;
            this.ordering = ordering;
            this.exclusion = exclusion;
        }

        public Modifier setId(String value) {
            this.setFields = this.setFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initId(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.idName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setRev(String value) {
            this.setFields = this.setFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initRev(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.revName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier setName(String value) {
            this.setFields = this.setFields.equal(this.serialization.nameName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier initName(String value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.nameName, false, Support.writable((Object)value));
            return this;
        }

        public Modifier clearData() {
            this.setFields = this.setFields.equal(this.serialization.dataName, false, Support.emptyBsonObject());
            return this;
        }

        public Modifier putData(String key, FormItem value) {
            this.setFields = this.setFields.equal(this.serialization.dataName + "." + key, false, Support.writable(this.serialization.dataSecondaryEncoder, (Object)value));
            return this;
        }

        public Modifier removeData(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.dataName + "." + key, false, (Object)1);
            return this;
        }

        public Modifier setMetadata(Form.Metadata value) {
            this.setFields = this.setFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Modifier initMetadata(Form.Metadata value) {
            this.setOnInsertFields = this.setOnInsertFields.equal(this.serialization.metadataName, false, Support.writable(this.serialization.metadataEncoder, (Object)value));
            return this;
        }

        public Modifier clearVariables() {
            this.unsetFields = this.unsetFields.equal(this.serialization.variablesName, false, (Object)1);
            return this;
        }

        public Modifier removeVariables(Variable value) {
            this.pullFields = this.pullFields.equal(this.serialization.variablesName, false, Support.writable(this.serialization.variablesEncoder, (Object)value));
            return this;
        }

        public Modifier addVariables(Variable value) {
            this.pushFields = this.pushFields.equal(this.serialization.variablesName, false, Support.writable(this.serialization.variablesEncoder, (Object)value));
            return this;
        }

        public Modifier setVariables(Iterable<? extends Variable> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Variable variable : values) {
                wrappedValues.add(Support.writable(this.serialization.variablesEncoder, (Object)variable));
            }
            this.setFields = this.setFields.equal(this.serialization.variablesName, false, wrappedValues);
            return this;
        }

        public Modifier addAllVariables(Iterable<? extends Variable> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (Variable variable : values) {
                wrappedValues.add(Support.writable(this.serialization.variablesEncoder, (Object)variable));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.variablesName, false, v);
            return this;
        }

        public Modifier clearNamespaces() {
            this.setFields = this.setFields.equal(this.serialization.namespacesName, false, Support.emptyBsonObject());
            return this;
        }

        public Modifier putNamespaces(String key, Form value) {
            this.setFields = this.setFields.equal(this.serialization.namespacesName + "." + key, false, Support.writable(this.serialization.namespacesSecondaryEncoder, (Object)value));
            return this;
        }

        public Modifier removeNamespaces(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.namespacesName + "." + key, false, (Object)1);
            return this;
        }

        public Modifier clearValueSets() {
            this.unsetFields = this.unsetFields.equal(this.serialization.valueSetsName, false, (Object)1);
            return this;
        }

        public Modifier removeValueSets(FormValueSet value) {
            this.pullFields = this.pullFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Modifier addValueSets(FormValueSet value) {
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, Support.writable(this.serialization.valueSetsEncoder, (Object)value));
            return this;
        }

        public Modifier setValueSets(Iterable<? extends FormValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (FormValueSet formValueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)formValueSet));
            }
            this.setFields = this.setFields.equal(this.serialization.valueSetsName, false, wrappedValues);
            return this;
        }

        public Modifier addAllValueSets(Iterable<? extends FormValueSet> values) {
            ArrayList<Object> wrappedValues = new ArrayList<Object>();
            for (FormValueSet formValueSet : values) {
                wrappedValues.add(Support.writable(this.serialization.valueSetsEncoder, (Object)formValueSet));
            }
            if (wrappedValues.isEmpty()) {
                return this;
            }
            Object v = wrappedValues.size() == 1 ? wrappedValues.get(0) : Support.bsonObjectAttribute((String)"$each", wrappedValues);
            this.pushFields = this.pushFields.equal(this.serialization.valueSetsName, false, v);
            return this;
        }

        public Modifier clearRequiredErrorText() {
            this.setFields = this.setFields.equal(this.serialization.requiredErrorTextName, false, Support.emptyBsonObject());
            return this;
        }

        public Modifier putRequiredErrorText(String key, String value) {
            this.setFields = this.setFields.equal(this.serialization.requiredErrorTextName + "." + key, false, Support.writable((Object)value));
            return this;
        }

        public Modifier removeRequiredErrorText(String key) {
            this.unsetFields = this.unsetFields.equal(this.serialization.requiredErrorTextName + "." + key, false, (Object)1);
            return this;
        }
    }
}

