/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import io.dialob.api.questionnaire.GsonAdaptersQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaire;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import io.dialob.api.questionnaire.QuestionnaireFactory;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuestionnaireTest {
    @Test
    public void gsonShouldSerializeCompatibleJson() {
        Questionnaire questionnaire = QuestionnaireFactory.questionnaire((String)"12", (String)"123");
        Gson gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GsonAdaptersQuestionnaire()).create();
        String json = gson.toJson((Object)questionnaire);
        Assertions.assertEquals((Object)"{\"_id\":\"12\",\"metadata\":{\"formId\":\"123\",\"status\":\"NEW\"}}", (Object)json);
    }

    @Test
    public void shouldThrowConstraintExceptionOnMissingMetadata() {
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ImmutableQuestionnaire.builder().build());
        Assertions.assertEquals((int)1, (int)exception.getConstraintViolations().size());
        ConstraintViolation constraintViolation = (ConstraintViolation)exception.getConstraintViolations().iterator().next();
        Assertions.assertEquals((Object)"must not be null", (Object)constraintViolation.getMessage());
        Assertions.assertEquals((Object)"metadata", (Object)constraintViolation.getPropertyPath().toString());
    }

    @Test
    public void shouldThrowConstraintExceptionOnPartialMetadata() {
        ConstraintViolationException exception = (ConstraintViolationException)Assertions.assertThrows(ConstraintViolationException.class, () -> ImmutableQuestionnaire.builder().metadata((Questionnaire.Metadata)ImmutableQuestionnaireMetadata.builder().build()).build());
        Assertions.assertEquals((int)1, (int)exception.getConstraintViolations().size());
        ConstraintViolation constraintViolation = (ConstraintViolation)exception.getConstraintViolations().iterator().next();
        Assertions.assertEquals((Object)"must not be null", (Object)constraintViolation.getMessage());
        Assertions.assertEquals((Object)"metadata.formId", (Object)constraintViolation.getPropertyPath().toString());
    }
}

