/*
 * Decompiled with CFR 0.152.
 */
package io.dialob.api.questionnaire;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.dialob.api.questionnaire.ImmutableQuestionnaireMetadata;
import io.dialob.api.questionnaire.Questionnaire;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QuestionnaireMetadataTest {
    @Test
    public void shouldDeserializeUnknownAttributesToAdditionalProperties() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        Questionnaire.Metadata metadata = (Questionnaire.Metadata)objectMapper.readValue("{\"formId\":\"123\",\"status\":\"NEW\",\"extraProp\":\"extraValue\"}", Questionnaire.Metadata.class);
        Assertions.assertTrue((metadata.getAdditionalProperties().size() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"extraValue", metadata.getAdditionalProperties().get("extraProp"));
    }

    @Test
    public void shouldSerializeAdditionalPropertiesToJsonAttributes() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        ImmutableQuestionnaireMetadata metadata = ImmutableQuestionnaireMetadata.builder().formId("123").putAdditionalProperties("extraProp", (Object)"extraValue").build();
        Assertions.assertEquals((Object)"{\"formId\":\"123\",\"status\":\"NEW\",\"extraProp\":\"extraValue\"}", (Object)objectMapper.writeValueAsString((Object)metadata));
    }
}

