package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Response}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResponse.builder()}.
 */
@Generated(from = "Response", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableResponse implements Response {
  private final Boolean ok;
  private final String error;
  private final String reason;

  private ImmutableResponse(Boolean ok, String error, String reason) {
    this.ok = ok;
    this.error = error;
    this.reason = reason;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty("ok")
  @Override
  public Boolean getOk() {
    return ok;
  }

  /**
   * @return The value of the {@code error} attribute
   */
  @JsonProperty("error")
  @Override
  public String getError() {
    return error;
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public String getReason() {
    return reason;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Response#getOk() ok} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ok (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponse withOk(Boolean value) {
    if (Objects.equals(this.ok, value)) return this;
    return new ImmutableResponse(value, this.error, this.reason);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Response#getError() error} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for error (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponse withError(String value) {
    if (Objects.equals(this.error, value)) return this;
    return new ImmutableResponse(this.ok, value, this.reason);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Response#getReason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponse withReason(String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new ImmutableResponse(this.ok, this.error, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResponse
        && equalTo(0, (ImmutableResponse) another);
  }

  private boolean equalTo(int synthetic, ImmutableResponse another) {
    return Objects.equals(ok, another.ok)
        && Objects.equals(error, another.error)
        && Objects.equals(reason, another.reason);
  }

  /**
   * Computes a hash code from attributes: {@code ok}, {@code error}, {@code reason}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(ok);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + Objects.hashCode(reason);
    return h;
  }

  /**
   * Prints the immutable value {@code Response} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Response{"
        + "ok=" + ok
        + ", error=" + error
        + ", reason=" + reason
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Response", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Response {
    @Nullable Boolean ok;
    @Nullable String error;
    @Nullable String reason;
    @JsonProperty("ok")
    public void setOk(Boolean ok) {
      this.ok = ok;
    }
    @JsonProperty("error")
    public void setError(String error) {
      this.error = error;
    }
    @JsonProperty("reason")
    public void setReason(String reason) {
      this.reason = reason;
    }
    @Override
    public Boolean getOk() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public String getReason() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableResponse fromJson(Json json) {
    ImmutableResponse.Builder builder = ImmutableResponse.builder();
    if (json.ok != null) {
      builder.ok(json.ok);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.reason != null) {
      builder.reason(json.reason);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Response} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Response instance
   */
  public static ImmutableResponse copyOf(Response instance) {
    if (instance instanceof ImmutableResponse) {
      return (ImmutableResponse) instance;
    }
    return ImmutableResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResponse ImmutableResponse}.
   * <pre>
   * ImmutableResponse.builder()
   *    .ok(Boolean | null) // nullable {@link Response#getOk() ok}
   *    .error(String | null) // nullable {@link Response#getError() error}
   *    .reason(String | null) // nullable {@link Response#getReason() reason}
   *    .build();
   * </pre>
   * @return A new ImmutableResponse builder
   */
  public static ImmutableResponse.Builder builder() {
    return new ImmutableResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResponse ImmutableResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Response", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean ok;
    private @Nullable String error;
    private @Nullable String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.api.rest.Response} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Response instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.dialob.api.rest.ResponseStatus} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResponseStatus instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Response) {
        Response instance = (Response) object;
        if ((bits & 0x1L) == 0) {
          Boolean okValue = instance.getOk();
          if (okValue != null) {
            ok(okValue);
          }
          bits |= 0x1L;
        }
        String errorValue = instance.getError();
        if (errorValue != null) {
          error(errorValue);
        }
        String reasonValue = instance.getReason();
        if (reasonValue != null) {
          reason(reasonValue);
        }
      }
      if (object instanceof ResponseStatus) {
        ResponseStatus instance = (ResponseStatus) object;
        if ((bits & 0x1L) == 0) {
          Boolean okValue = instance.getOk();
          if (okValue != null) {
            ok(okValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Response#getOk() ok} attribute.
     * @param ok The value for ok (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ok")
    public final Builder ok(Boolean ok) {
      this.ok = ok;
      return this;
    }

    /**
     * Initializes the value for the {@link Response#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link Response#getReason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("reason")
    public final Builder reason(String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResponse ImmutableResponse}.
     * @return An immutable instance of Response
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResponse build() {
      return new ImmutableResponse(ok, error, reason);
    }
  }
}
