package io.dialob.api.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Items}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItems.builder()}.
 */
@Generated(from = "Items", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableItems implements Items {
  private final String activeItem;
  private final List<String> items;
  private final List<String> availableItems;

  private ImmutableItems(
      String activeItem,
      List<String> items,
      List<String> availableItems) {
    this.activeItem = activeItem;
    this.items = items;
    this.availableItems = availableItems;
  }

  /**
   * @return The value of the {@code activeItem} attribute
   */
  @JsonProperty("activeItem")
  @Override
  public String getActiveItem() {
    return activeItem;
  }

  /**
   * @return The value of the {@code items} attribute
   */
  @JsonProperty("items")
  @Override
  public List<String> getItems() {
    return items;
  }

  /**
   * @return The value of the {@code availableItems} attribute
   */
  @JsonProperty("availableItems")
  @Override
  public List<String> getAvailableItems() {
    return availableItems;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Items#getActiveItem() activeItem} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for activeItem
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItems withActiveItem(String value) {
    String newValue = Objects.requireNonNull(value, "activeItem");
    if (this.activeItem.equals(newValue)) return this;
    return new ImmutableItems(newValue, this.items, this.availableItems);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Items#getItems() items}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableItems withItems(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableItems(this.activeItem, newValue, this.availableItems);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Items#getItems() items}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of items elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableItems withItems(Iterable<String> elements) {
    if (this.items == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableItems(this.activeItem, newValue, this.availableItems);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Items#getAvailableItems() availableItems}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableItems withAvailableItems(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableItems(this.activeItem, this.items, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Items#getAvailableItems() availableItems}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of availableItems elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableItems withAvailableItems(Iterable<String> elements) {
    if (this.availableItems == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableItems(this.activeItem, this.items, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItems} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItems
        && equalTo(0, (ImmutableItems) another);
  }

  private boolean equalTo(int synthetic, ImmutableItems another) {
    return activeItem.equals(another.activeItem)
        && items.equals(another.items)
        && availableItems.equals(another.availableItems);
  }

  /**
   * Computes a hash code from attributes: {@code activeItem}, {@code items}, {@code availableItems}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + activeItem.hashCode();
    h += (h << 5) + items.hashCode();
    h += (h << 5) + availableItems.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Items} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Items{"
        + "activeItem=" + activeItem
        + ", items=" + items
        + ", availableItems=" + availableItems
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Items", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Items {
    @Nullable String activeItem;
    @Nullable List<String> items = Collections.emptyList();
    @Nullable List<String> availableItems = Collections.emptyList();
    @JsonProperty("activeItem")
    public void setActiveItem(String activeItem) {
      this.activeItem = activeItem;
    }
    @JsonProperty("items")
    public void setItems(List<String> items) {
      this.items = items;
    }
    @JsonProperty("availableItems")
    public void setAvailableItems(List<String> availableItems) {
      this.availableItems = availableItems;
    }
    @Override
    public String getActiveItem() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getItems() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAvailableItems() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableItems fromJson(Json json) {
    ImmutableItems.Builder builder = ImmutableItems.builder();
    if (json.activeItem != null) {
      builder.activeItem(json.activeItem);
    }
    if (json.items != null) {
      builder.addAllItems(json.items);
    }
    if (json.availableItems != null) {
      builder.addAllAvailableItems(json.availableItems);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Items} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Items instance
   */
  public static ImmutableItems copyOf(Items instance) {
    if (instance instanceof ImmutableItems) {
      return (ImmutableItems) instance;
    }
    return ImmutableItems.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItems ImmutableItems}.
   * <pre>
   * ImmutableItems.builder()
   *    .activeItem(String) // required {@link Items#getActiveItem() activeItem}
   *    .addItems|addAllItems(String) // {@link Items#getItems() items} elements
   *    .addAvailableItems|addAllAvailableItems(String) // {@link Items#getAvailableItems() availableItems} elements
   *    .build();
   * </pre>
   * @return A new ImmutableItems builder
   */
  public static ImmutableItems.Builder builder() {
    return new ImmutableItems.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItems ImmutableItems}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Items", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACTIVE_ITEM = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String activeItem;
    private List<String> items = new ArrayList<String>();
    private List<String> availableItems = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Items} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Items instance) {
      Objects.requireNonNull(instance, "instance");
      activeItem(instance.getActiveItem());
      addAllItems(instance.getItems());
      addAllAvailableItems(instance.getAvailableItems());
      return this;
    }

    /**
     * Initializes the value for the {@link Items#getActiveItem() activeItem} attribute.
     * @param activeItem The value for activeItem 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("activeItem")
    public final Builder activeItem(String activeItem) {
      this.activeItem = Objects.requireNonNull(activeItem, "activeItem");
      initBits &= ~INIT_BIT_ACTIVE_ITEM;
      return this;
    }

    /**
     * Adds one element to {@link Items#getItems() items} list.
     * @param element A items element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(String element) {
      this.items.add(Objects.requireNonNull(element, "items element"));
      return this;
    }

    /**
     * Adds elements to {@link Items#getItems() items} list.
     * @param elements An array of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addItems(String... elements) {
      for (String element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Items#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("items")
    public final Builder items(Iterable<String> elements) {
      this.items.clear();
      return addAllItems(elements);
    }

    /**
     * Adds elements to {@link Items#getItems() items} list.
     * @param elements An iterable of items elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllItems(Iterable<String> elements) {
      for (String element : elements) {
        this.items.add(Objects.requireNonNull(element, "items element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Items#getAvailableItems() availableItems} list.
     * @param element A availableItems element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableItems(String element) {
      this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      return this;
    }

    /**
     * Adds elements to {@link Items#getAvailableItems() availableItems} list.
     * @param elements An array of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAvailableItems(String... elements) {
      for (String element : elements) {
        this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Items#getAvailableItems() availableItems} list.
     * @param elements An iterable of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("availableItems")
    public final Builder availableItems(Iterable<String> elements) {
      this.availableItems.clear();
      return addAllAvailableItems(elements);
    }

    /**
     * Adds elements to {@link Items#getAvailableItems() availableItems} list.
     * @param elements An iterable of availableItems elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAvailableItems(Iterable<String> elements) {
      for (String element : elements) {
        this.availableItems.add(Objects.requireNonNull(element, "availableItems element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableItems ImmutableItems}.
     * @return An immutable instance of Items
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItems build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableItems(activeItem, createUnmodifiableList(true, items), createUnmodifiableList(true, availableItems));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ACTIVE_ITEM) != 0) attributes.add("activeItem");
      return "Cannot build Items, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
