package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Questionnaire.Metadata Metadata} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableQuestionnaireMetadata is not thread-safe</em>
 * @see ImmutableQuestionnaireMetadata
 */
@Generated(from = "Questionnaire.Metadata", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Questionnaire.Metadata"})
@NotThreadSafe
public final class ModifiableQuestionnaireMetadata extends Questionnaire.Metadata {

  private static final long OPT_BIT_STATUS = 0x1L;
  private long optBits;

  private String formId;
  private @Nullable String formName;
  private Questionnaire.Metadata.Status status;
  private @Nullable String formRev;
  private @Nullable String tenantId;
  private @Nullable Date created;
  private @Nullable Date lastAnswer;
  private @Nullable Date opened;
  private @Nullable Date completed;
  private @Nullable String label;
  private @Nullable String submitUrl;
  private @Nullable Questionnaire.Metadata.Reason reason;
  private @Nullable String language;
  private @Nullable String owner;
  private @Nullable String creator;
  private final Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();

  private ModifiableQuestionnaireMetadata() {}

  /**
   * Construct a modifiable instance of {@code Metadata}.
   * @return A new modifiable instance
   */
  public static ModifiableQuestionnaireMetadata create() {
    return new ModifiableQuestionnaireMetadata();
  }

  /**
   * @return value of {@code formId} attribute, may be {@code null}
   */
  @JsonProperty("formId")
  @Override
  public final String getFormId() {
    return formId;
  }

  /**
   * @return value of {@code formName} attribute, may be {@code null}
   */
  @JsonProperty("formName")
  @Override
  public final @Nullable String getFormName() {
    return formName;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public final Questionnaire.Metadata.Status getStatus() {
    if (statusIsSet()) {
      return status;
    } else {
      return super.getStatus();
    }
  }

  /**
   * @return value of {@code formRev} attribute, may be {@code null}
   */
  @JsonProperty("formRev")
  @Override
  public final @Nullable String getFormRev() {
    return formRev;
  }

  /**
   * @return value of {@code tenantId} attribute, may be {@code null}
   */
  @JsonProperty("tenantId")
  @Override
  public final @Nullable String getTenantId() {
    return tenantId;
  }

  /**
   * @return value of {@code created} attribute, may be {@code null}
   */
  @JsonProperty("created")
  @Override
  public final @Nullable Date getCreated() {
    return created;
  }

  /**
   * @return value of {@code lastAnswer} attribute, may be {@code null}
   */
  @JsonProperty("lastAnswer")
  @Override
  public final @Nullable Date getLastAnswer() {
    return lastAnswer;
  }

  /**
   * @return value of {@code opened} attribute, may be {@code null}
   */
  @JsonProperty("opened")
  @Override
  public final @Nullable Date getOpened() {
    return opened;
  }

  /**
   * @return value of {@code completed} attribute, may be {@code null}
   */
  @JsonProperty("completed")
  @Override
  public final @Nullable Date getCompleted() {
    return completed;
  }

  /**
   * @return value of {@code label} attribute, may be {@code null}
   */
  @JsonProperty("label")
  @Override
  public final @Nullable String getLabel() {
    return label;
  }

  /**
   * @return value of {@code submitUrl} attribute, may be {@code null}
   */
  @JsonProperty("submitUrl")
  @Override
  public final @Nullable String getSubmitUrl() {
    return submitUrl;
  }

  /**
   * Completion reason, null if normally completed.
   */
  @JsonProperty("reason")
  @Override
  public final @Nullable Questionnaire.Metadata.Reason getReason() {
    return reason;
  }

  /**
   * @return value of {@code language} attribute, may be {@code null}
   */
  @JsonProperty("language")
  @Override
  public final @Nullable String getLanguage() {
    return language;
  }

  /**
   * userId of document owner
   */
  @JsonProperty("owner")
  @Override
  public final @Nullable String getOwner() {
    return owner;
  }

  /**
   * userId of one who created questionnaire
   */
  @JsonProperty("creator")
  @Override
  public final @Nullable String getCreator() {
    return creator;
  }

  /**
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @JsonInclude
  @Override
  public final Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata clear() {
    optBits = 0;
    formId = null;
    formName = null;
    status = null;
    formRev = null;
    tenantId = null;
    created = null;
    lastAnswer = null;
    opened = null;
    completed = null;
    label = null;
    submitUrl = null;
    reason = null;
    language = null;
    owner = null;
    creator = null;
    additionalProperties.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Questionnaire.Metadata} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata from(Questionnaire.Metadata instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableQuestionnaireMetadata) {
      from((ModifiableQuestionnaireMetadata) instance);
      return this;
    }
    String formIdValue = instance.getFormId();
    if (formIdValue != null) {
      setFormId(formIdValue);
    }
    String formNameValue = instance.getFormName();
    if (formNameValue != null) {
      setFormName(formNameValue);
    }
    setStatus(instance.getStatus());
    String formRevValue = instance.getFormRev();
    if (formRevValue != null) {
      setFormRev(formRevValue);
    }
    String tenantIdValue = instance.getTenantId();
    if (tenantIdValue != null) {
      setTenantId(tenantIdValue);
    }
    Date createdValue = instance.getCreated();
    if (createdValue != null) {
      setCreated(createdValue);
    }
    Date lastAnswerValue = instance.getLastAnswer();
    if (lastAnswerValue != null) {
      setLastAnswer(lastAnswerValue);
    }
    Date openedValue = instance.getOpened();
    if (openedValue != null) {
      setOpened(openedValue);
    }
    Date completedValue = instance.getCompleted();
    if (completedValue != null) {
      setCompleted(completedValue);
    }
    String labelValue = instance.getLabel();
    if (labelValue != null) {
      setLabel(labelValue);
    }
    String submitUrlValue = instance.getSubmitUrl();
    if (submitUrlValue != null) {
      setSubmitUrl(submitUrlValue);
    }
    Questionnaire.Metadata.Reason reasonValue = instance.getReason();
    if (reasonValue != null) {
      setReason(reasonValue);
    }
    String languageValue = instance.getLanguage();
    if (languageValue != null) {
      setLanguage(languageValue);
    }
    String ownerValue = instance.getOwner();
    if (ownerValue != null) {
      setOwner(ownerValue);
    }
    String creatorValue = instance.getCreator();
    if (creatorValue != null) {
      setCreator(creatorValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Questionnaire.Metadata} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata from(ModifiableQuestionnaireMetadata instance) {
    Objects.requireNonNull(instance, "instance");
    String formIdValue = instance.getFormId();
    if (formIdValue != null) {
      setFormId(formIdValue);
    }
    String formNameValue = instance.getFormName();
    if (formNameValue != null) {
      setFormName(formNameValue);
    }
    setStatus(instance.getStatus());
    String formRevValue = instance.getFormRev();
    if (formRevValue != null) {
      setFormRev(formRevValue);
    }
    String tenantIdValue = instance.getTenantId();
    if (tenantIdValue != null) {
      setTenantId(tenantIdValue);
    }
    Date createdValue = instance.getCreated();
    if (createdValue != null) {
      setCreated(createdValue);
    }
    Date lastAnswerValue = instance.getLastAnswer();
    if (lastAnswerValue != null) {
      setLastAnswer(lastAnswerValue);
    }
    Date openedValue = instance.getOpened();
    if (openedValue != null) {
      setOpened(openedValue);
    }
    Date completedValue = instance.getCompleted();
    if (completedValue != null) {
      setCompleted(completedValue);
    }
    String labelValue = instance.getLabel();
    if (labelValue != null) {
      setLabel(labelValue);
    }
    String submitUrlValue = instance.getSubmitUrl();
    if (submitUrlValue != null) {
      setSubmitUrl(submitUrlValue);
    }
    Questionnaire.Metadata.Reason reasonValue = instance.getReason();
    if (reasonValue != null) {
      setReason(reasonValue);
    }
    String languageValue = instance.getLanguage();
    if (languageValue != null) {
      setLanguage(languageValue);
    }
    String ownerValue = instance.getOwner();
    if (ownerValue != null) {
      setOwner(ownerValue);
    }
    String creatorValue = instance.getCreator();
    if (creatorValue != null) {
      setCreator(creatorValue);
    }
    putAllAdditionalProperties(instance.getAdditionalProperties());
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getFormId() formId} attribute.
   * @param formId The value for formId, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setFormId(String formId) {
    this.formId = formId;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getFormName() formName} attribute.
   * @param formName The value for formName, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setFormName(@Nullable String formName) {
    this.formName = formName;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getStatus() status} attribute.
   * <p><em>If not set, this attribute will have a default value returned by the initializer of {@link Questionnaire.Metadata#getStatus() status}.</em>
   * @param status The value for status
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setStatus(Questionnaire.Metadata.Status status) {
    this.status = Objects.requireNonNull(status, "status");
    optBits |= OPT_BIT_STATUS;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getFormRev() formRev} attribute.
   * @param formRev The value for formRev, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setFormRev(@Nullable String formRev) {
    this.formRev = formRev;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getTenantId() tenantId} attribute.
   * @param tenantId The value for tenantId, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setTenantId(@Nullable String tenantId) {
    this.tenantId = tenantId;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getCreated() created} attribute.
   * @param created The value for created, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setCreated(@Nullable Date created) {
    this.created = created;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getLastAnswer() lastAnswer} attribute.
   * @param lastAnswer The value for lastAnswer, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setLastAnswer(@Nullable Date lastAnswer) {
    this.lastAnswer = lastAnswer;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getOpened() opened} attribute.
   * @param opened The value for opened, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setOpened(@Nullable Date opened) {
    this.opened = opened;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getCompleted() completed} attribute.
   * @param completed The value for completed, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setCompleted(@Nullable Date completed) {
    this.completed = completed;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getLabel() label} attribute.
   * @param label The value for label, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setLabel(@Nullable String label) {
    this.label = label;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getSubmitUrl() submitUrl} attribute.
   * @param submitUrl The value for submitUrl, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setSubmitUrl(@Nullable String submitUrl) {
    this.submitUrl = submitUrl;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getReason() reason} attribute.
   * @param reason The value for reason, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setReason(@Nullable Questionnaire.Metadata.Reason reason) {
    this.reason = reason;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getLanguage() language} attribute.
   * @param language The value for language, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setLanguage(@Nullable String language) {
    this.language = language;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getOwner() owner} attribute.
   * @param owner The value for owner, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setOwner(@Nullable String owner) {
    this.owner = owner;
    return this;
  }

  /**
   * Assigns a value to the {@link Questionnaire.Metadata#getCreator() creator} attribute.
   * @param creator The value for creator, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setCreator(@Nullable String creator) {
    this.creator = creator;
    return this;
  }

  /**
   * Put one entry to the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map.
   * @param key The key in additionalProperties map
   * @param value The associated value in the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata putAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(
        Objects.requireNonNull(key, "additionalProperties key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata setAdditionalProperties(Map<String, ? extends Object> entries) {
    this.additionalProperties.clear();
    this.putAllAdditionalProperties(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link Questionnaire.Metadata#getAdditionalProperties() additionalProperties} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to additionalProperties map
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableQuestionnaireMetadata putAllAdditionalProperties(Map<String, ? extends Object> entries) {
    for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
      String k = e.getKey();
      Object v = e.getValue();
      this.additionalProperties.put(
          Objects.requireNonNull(k, "additionalProperties key"),
          v);
    }
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link Questionnaire.Metadata#getStatus() status} is set.
   * @return {@code true} if set
   */
  public final boolean statusIsSet() {
    return (optBits & OPT_BIT_STATUS) != 0;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableQuestionnaireMetadata unsetStatus() {
    optBits |= 0;
    status = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableQuestionnaireMetadata ImmutableQuestionnaireMetadata}.
   * @return An immutable instance of Metadata
   */
  public final ImmutableQuestionnaireMetadata toImmutable() {
    return ImmutableQuestionnaireMetadata.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableQuestionnaireMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableQuestionnaireMetadata)) return false;
    ModifiableQuestionnaireMetadata other = (ModifiableQuestionnaireMetadata) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableQuestionnaireMetadata another) {
    Questionnaire.Metadata.Status status = getStatus();
    return Objects.equals(formId, another.formId)
        && Objects.equals(formName, another.formName)
        && status.equals(another.getStatus())
        && Objects.equals(formRev, another.formRev)
        && Objects.equals(tenantId, another.tenantId)
        && Objects.equals(created, another.created)
        && Objects.equals(lastAnswer, another.lastAnswer)
        && Objects.equals(opened, another.opened)
        && Objects.equals(completed, another.completed)
        && Objects.equals(label, another.label)
        && Objects.equals(submitUrl, another.submitUrl)
        && Objects.equals(reason, another.reason)
        && Objects.equals(language, another.language)
        && Objects.equals(owner, another.owner)
        && Objects.equals(creator, another.creator)
        && additionalProperties.equals(another.additionalProperties);
  }

  /**
   * Computes a hash code from attributes: {@code formId}, {@code formName}, {@code status}, {@code formRev}, {@code tenantId}, {@code created}, {@code lastAnswer}, {@code opened}, {@code completed}, {@code label}, {@code submitUrl}, {@code reason}, {@code language}, {@code owner}, {@code creator}, {@code additionalProperties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(formId);
    h += (h << 5) + Objects.hashCode(formName);
    Questionnaire.Metadata.Status status = getStatus();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(formRev);
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(created);
    h += (h << 5) + Objects.hashCode(lastAnswer);
    h += (h << 5) + Objects.hashCode(opened);
    h += (h << 5) + Objects.hashCode(completed);
    h += (h << 5) + Objects.hashCode(label);
    h += (h << 5) + Objects.hashCode(submitUrl);
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + Objects.hashCode(language);
    h += (h << 5) + Objects.hashCode(owner);
    h += (h << 5) + Objects.hashCode(creator);
    h += (h << 5) + additionalProperties.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Metadata}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableQuestionnaireMetadata{"
        + "formId=" + getFormId()
        + ", formName=" + getFormName()
        + ", status=" + getStatus()
        + ", formRev=" + getFormRev()
        + ", tenantId=" + getTenantId()
        + ", created=" + getCreated()
        + ", lastAnswer=" + getLastAnswer()
        + ", opened=" + getOpened()
        + ", completed=" + getCompleted()
        + ", label=" + getLabel()
        + ", submitUrl=" + getSubmitUrl()
        + ", reason=" + getReason()
        + ", language=" + getLanguage()
        + ", owner=" + getOwner()
        + ", creator=" + getCreator()
        + ", additionalProperties=" + getAdditionalProperties()
        + "}";
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
