package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Error Error} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableError is not thread-safe</em>
 * @see ImmutableError
 */
@Generated(from = "Error", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated({"Modifiables.generator", "Error"})
@NotThreadSafe
public final class ModifiableError implements Error {

  private static final long INIT_BIT_ID = 0x1L;
  private long initBits = 0x1L;

  private String id;
  private @Nullable String code;
  private @Nullable String description;

  private ModifiableError() {}

  /**
   * Construct a modifiable instance of {@code Error}.
   * @param id The value for the {@link Error#getId() id} attribute 
   * @param code The value for the {@link Error#getCode() code} attribute (can be {@code null})
   * @param description The value for the {@link Error#getDescription() description} attribute (can be {@code null})
   * @return A new modifiable instance
   */
  public static ModifiableError create(String id,
    @Nullable String code,
    @Nullable String description) {
    return new ModifiableError()
        .setId(id)
        .setCode(code)
        .setDescription(description);
  }

  /**
   * Construct a modifiable instance of {@code Error}.
   * @return A new modifiable instance
   */
  public static ModifiableError create() {
    return new ModifiableError();
  }

  /**
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public final String getId() {
    if (!idIsSet()) {
      checkRequiredAttributes();
    }
    return id;
  }

  /**
   * @return value of {@code code} attribute, may be {@code null}
   */
  @JsonProperty("code")
  @Override
  public final @Nullable String getCode() {
    return code;
  }

  /**
   * @return value of {@code description} attribute, may be {@code null}
   */
  @JsonProperty("description")
  @Override
  public final @Nullable String getDescription() {
    return description;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError clear() {
    initBits = 0x1L;
    id = null;
    code = null;
    description = null;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Error} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError from(Error instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableError) {
      from((ModifiableError) instance);
      return this;
    }
    setId(instance.getId());
    String codeValue = instance.getCode();
    if (codeValue != null) {
      setCode(codeValue);
    }
    String descriptionValue = instance.getDescription();
    if (descriptionValue != null) {
      setDescription(descriptionValue);
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Error} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError from(ModifiableError instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.idIsSet()) {
      setId(instance.getId());
    }
    String codeValue = instance.getCode();
    if (codeValue != null) {
      setCode(codeValue);
    }
    String descriptionValue = instance.getDescription();
    if (descriptionValue != null) {
      setDescription(descriptionValue);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Error#getId() id} attribute.
   * @param id The value for id
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError setId(String id) {
    this.id = Objects.requireNonNull(id, "id");
    initBits &= ~INIT_BIT_ID;
    return this;
  }

  /**
   * Assigns a value to the {@link Error#getCode() code} attribute.
   * @param code The value for code, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError setCode(@Nullable String code) {
    this.code = code;
    return this;
  }

  /**
   * Assigns a value to the {@link Error#getDescription() description} attribute.
   * @param description The value for description, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableError setDescription(@Nullable String description) {
    this.description = description;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Error#getId() id} is set.
   * @return {@code true} if set
   */
  public final boolean idIsSet() {
    return (initBits & INIT_BIT_ID) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  public final ModifiableError unsetId() {
    initBits |= INIT_BIT_ID;
    id = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!idIsSet()) attributes.add("id");
    return "Error is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableError ImmutableError}.
   * @return An immutable instance of Error
   */
  public final ImmutableError toImmutable() {
    checkRequiredAttributes();
    return ImmutableError.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableError} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableError)) return false;
    ModifiableError other = (ModifiableError) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableError another) {
    return id.equals(another.id)
        && Objects.equals(code, another.code)
        && Objects.equals(description, another.description);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code code}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(code);
    h += (h << 5) + Objects.hashCode(description);
    return h;
  }

  /**
   * Generates a string representation of this {@code Error}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableError{"
        + "id="  + (idIsSet() ? getId() : "?")
        + ", code=" + getCode()
        + ", description=" + getDescription()
        + "}";
  }
}
