package io.dialob.api.questionnaire;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.dialob.api.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableValue.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableVariableValue.of()}.
 */
@Generated(from = "VariableValue", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVariableValue implements VariableValue {
  private final String id;
  private final @Nullable Object value;

  private ImmutableVariableValue(String id, @Nullable Object value) {
    this.id = Objects.requireNonNull(id, "id");
    this.value = value;
  }

  private ImmutableVariableValue(
      ImmutableVariableValue original,
      String id,
      @Nullable Object value) {
    this.id = id;
    this.value = value;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty("value")
  @JsonInclude(JsonInclude.Include.ALWAYS)
  @Override
  public @Nullable Object getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableValue#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableValue withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableVariableValue(this, newValue, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableValue#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableValue withValue(@Nullable Object value) {
    if (this.value == value) return this;
    return new ImmutableVariableValue(this, this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableValue
        && equalTo(0, (ImmutableVariableValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariableValue another) {
    return id.equals(another.id)
        && Objects.equals(value, another.value);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(value);
    return h;
  }

  /**
   * Prints the immutable value {@code VariableValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VariableValue{"
        + "id=" + id
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "VariableValue", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements VariableValue {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable Object value;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public void setValue(@Nullable Object value) {
      this.value = value;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Object getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVariableValue fromJson(Json json) {
    ImmutableVariableValue.Builder builder = ImmutableVariableValue.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.value != null) {
      builder.value(json.value);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code VariableValue} instance.
   * @param id The value for the {@code id} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable VariableValue instance
   */
  public static ImmutableVariableValue of(String id, @Nullable Object value) {
    return new ImmutableVariableValue(id, value);
  }

  /**
   * Creates an immutable copy of a {@link VariableValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableValue instance
   */
  public static ImmutableVariableValue copyOf(VariableValue instance) {
    if (instance instanceof ImmutableVariableValue) {
      return (ImmutableVariableValue) instance;
    }
    return ImmutableVariableValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableValue ImmutableVariableValue}.
   * <pre>
   * ImmutableVariableValue.builder()
   *    .id(String) // required {@link VariableValue#getId() id}
   *    .value(Object | null) // nullable {@link VariableValue#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableVariableValue builder
   */
  public static ImmutableVariableValue.Builder builder() {
    return new ImmutableVariableValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableValue ImmutableVariableValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableValue", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable Object value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableVariableValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ModifiableVariableValue instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.idIsSet()) {
        id(instance.getId());
      }
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code VariableValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VariableValue instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableVariableValue) {
        return from((ModifiableVariableValue) instance);
      }
      id(instance.getId());
      Object valueValue = instance.getValue();
      if (valueValue != null) {
        value(valueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link VariableValue#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableValue#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("value")
    @JsonInclude(JsonInclude.Include.ALWAYS)
    public final Builder value(@Nullable Object value) {
      this.value = value;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableValue ImmutableVariableValue}.
     * @return An immutable instance of VariableValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableValue build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableVariableValue(null, id, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build VariableValue, some of required attributes are not set " + attributes;
    }
  }
}
